/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.datapersistence.listeners.FbFlowHandle;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencySnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequence;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequenceSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.utils.LocalLatencyDistributionSnapshot;
import com.excentis.products.byteblower.run.utils.LocalLatencyResultData;
import com.excentis.products.byteblower.run.utils.LocalOutOfSequenceResultData;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;

public class StoreIntervalSnapshots
implements RuntimeRx.SnapshotVisitor {
    private final FbFlowInstanceReader fbFlowInstanceReader;
    private final String overridenDestination;
    private final BaseEntityManager<FbTriggerSnapshot> fbTriggerSnapshotManager;
    private BaseEntityManager<FbLatencySnapshot> fbLatencySnapshotManager;
    private BaseEntityManager<FbOutOfSequenceSnapshot> fbOutOfSequenceSnapshotManager;
    private final boolean shouldSaveInterval;

    StoreIntervalSnapshots(TestDataPersistenceController pc, FbFlowInstanceReader fbFlowInstanceReader, boolean shouldSaveInterval) {
        this.fbFlowInstanceReader = fbFlowInstanceReader;
        this.overridenDestination = null;
        this.fbTriggerSnapshotManager = new BaseEntityManager(FbTriggerSnapshot.class, pc);
        this.fbLatencySnapshotManager = new BaseEntityManager(FbLatencySnapshot.class, pc);
        this.fbOutOfSequenceSnapshotManager = new BaseEntityManager(FbOutOfSequenceSnapshot.class, pc);
        this.shouldSaveInterval = shouldSaveInterval;
    }

    StoreIntervalSnapshots(TestDataPersistenceController pc, String overridenDestination, FbFlowInstanceReader fbFlowInstanceReader, boolean shouldSaveInterval) {
        this.fbFlowInstanceReader = fbFlowInstanceReader;
        this.overridenDestination = overridenDestination;
        this.fbTriggerSnapshotManager = new BaseEntityManager(FbTriggerSnapshot.class, pc);
        this.fbLatencySnapshotManager = new BaseEntityManager(FbLatencySnapshot.class, pc);
        this.fbOutOfSequenceSnapshotManager = new BaseEntityManager(FbOutOfSequenceSnapshot.class, pc);
        this.shouldSaveInterval = shouldSaveInterval;
    }

    public void visit(RuntimePort port, LocalOutOfSequenceResultData[] trigger) {
        if (trigger.length == 0) {
            return;
        }
        FbDestination destination = this.overridenDestination == null ? FbFlowHandle.getDestination(port, this.fbFlowInstanceReader) : FbFlowHandle.getDestination(this.overridenDestination, this.fbFlowInstanceReader);
        FbOutOfSequence fbOutOfSequence = destination.getOutOfSequence();
        FbOutOfSequenceSnapshot[] dbSnapshots = new FbOutOfSequenceSnapshot[trigger.length];
        int ctr = 0;
        LocalOutOfSequenceResultData[] localOutOfSequenceResultDataArray = trigger;
        int n = trigger.length;
        int n2 = 0;
        while (n2 < n) {
            LocalOutOfSequenceResultData apiIntervalData = localOutOfSequenceResultDataArray[n2];
            FbOutOfSequenceSnapshot newSnapshot = new FbOutOfSequenceSnapshot(fbOutOfSequence, Long.valueOf(apiIntervalData.TimestampGet()), Long.valueOf(apiIntervalData.IntervalDurationGet()), Long.valueOf(apiIntervalData.PacketCountValidGet()), Long.valueOf(apiIntervalData.PacketCountOutOfSequenceGet()));
            dbSnapshots[ctr++] = newSnapshot;
            fbOutOfSequence.setLatestSnapshot(newSnapshot);
            ++n2;
        }
        if (this.shouldSaveInterval) {
            this.fbOutOfSequenceSnapshotManager.persistIdEntity((BaseEntity[])dbSnapshots);
        }
    }

    public void visit(RuntimePort port, LocalLatencyDistributionSnapshot trigger) {
    }

    public void visit(RuntimePort port, LocalTriggerResultData[] snapshots) {
        FbDestination destination = this.overridenDestination == null ? FbFlowHandle.getDestination(port, this.fbFlowInstanceReader) : FbFlowHandle.getDestination(this.overridenDestination, this.fbFlowInstanceReader);
        this.updateRxTriggerResult(destination.getTrigger(), snapshots);
    }

    public void visit(RuntimePort port, LocalLatencyResultData[] trigger) {
        FbDestination destination = this.overridenDestination == null ? FbFlowHandle.getDestination(port, this.fbFlowInstanceReader) : FbFlowHandle.getDestination(this.overridenDestination, this.fbFlowInstanceReader);
        FbLatency fbLatency = destination.getLatency();
        FbLatencySnapshot[] dbSnapshots = new FbLatencySnapshot[trigger.length];
        int ctr = 0;
        LocalLatencyResultData[] localLatencyResultDataArray = trigger;
        int n = trigger.length;
        int n2 = 0;
        while (n2 < n) {
            LocalLatencyResultData snapshot = localLatencyResultDataArray[n2];
            long minLatency = 0L;
            long avgLatency = 0L;
            long maxLatency = 0L;
            long jitter = 0L;
            long validPacketCount = snapshot.PacketCountGet();
            long invalidPackets = snapshot.PacketCountInvalidGet();
            if (validPacketCount > 0L) {
                minLatency = snapshot.LatencyMinimumGet();
                avgLatency = snapshot.LatencyAverageGet();
                maxLatency = snapshot.LatencyMaximumGet();
                jitter = snapshot.JitterGet();
            }
            FbLatencySnapshot newSnapshot = new FbLatencySnapshot(fbLatency, snapshot.TimestampGet(), snapshot.IntervalDurationGet(), validPacketCount, invalidPackets, minLatency, avgLatency, maxLatency, jitter);
            dbSnapshots[ctr++] = newSnapshot;
            fbLatency.setLatestSnapshot(newSnapshot);
            ++n2;
        }
        if (this.shouldSaveInterval) {
            this.fbLatencySnapshotManager.persistIdEntity((BaseEntity[])dbSnapshots);
        }
    }

    private void updateRxTriggerResult(FbTrigger fbTrigger, LocalTriggerResultData[] rtTrigger) {
        if (rtTrigger.length == 0) {
            return;
        }
        if (fbTrigger.getSnapshotResolution() == null) {
            LocalTriggerResultData firstSnapshot = rtTrigger[0];
            fbTrigger.setSnapshotResolution(firstSnapshot.IntervalDurationGet());
        }
        FbTriggerSnapshot[] dbSnapshots = new FbTriggerSnapshot[rtTrigger.length];
        int ctr = 0;
        LocalTriggerResultData[] localTriggerResultDataArray = rtTrigger;
        int n = rtTrigger.length;
        int n2 = 0;
        while (n2 < n) {
            LocalTriggerResultData apiIntervalData = localTriggerResultDataArray[n2];
            FbTriggerSnapshot newSnapshot = new FbTriggerSnapshot(fbTrigger, Long.valueOf(apiIntervalData.TimestampGet()), Long.valueOf(apiIntervalData.IntervalDurationGet()), Long.valueOf(apiIntervalData.PacketCountGet()), Long.valueOf(apiIntervalData.ByteCountGet()));
            dbSnapshots[ctr++] = newSnapshot;
            fbTrigger.setLatestSnapshot(newSnapshot);
            ++n2;
        }
        if (this.shouldSaveInterval) {
            this.fbTriggerSnapshotManager.persistIdEntity((BaseEntity[])dbSnapshots);
        }
    }
}

