/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.datapersistence.listeners.BaseHandle;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.FlowReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.results.dataprovider.data.BaseEntityManager;
import com.excentis.products.byteblower.results.dataprovider.data.MetaDataPersistenceController;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TagManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Event;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.Tag;
import com.excentis.products.byteblower.results.testdata.data.entities.Test;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.results.testdata.data.enums.ScenarioStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.TestStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.TestType;
import com.excentis.products.byteblower.run.actions.ConfigurePorts;
import com.excentis.products.byteblower.run.actions.InitializeScenario;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import java.util.Date;

public class TestProgressHandle
extends BaseHandle
implements InitializeScenario.Listener,
ConfigurePorts.Listener,
RunScenario.Listener {
    private final TestDataReference testDataReference;
    private final com.excentis.products.byteblower.results.testdata.data.BaseEntityManager<Test> testManager;
    private final BaseEntityManager<TestDataReference> testDataReferenceManager;
    private final ScenarioManager scenarioManager;
    private final TagManager tagManager;
    private Test testEntity;
    private Scenario scenarioEntity;
    private TestDataPersistenceController tdpc;

    public TestProgressHandle(TestDataPersistenceController tdpc, MetaDataPersistenceController mdpc, TestDataReference tdr) {
        super(tdpc);
        this.testManager = new com.excentis.products.byteblower.results.testdata.data.BaseEntityManager(Test.class, tdpc);
        this.scenarioManager = new ScenarioManager(tdpc);
        this.testDataReferenceManager = new BaseEntityManager(TestDataReference.class, mdpc);
        this.tagManager = new TagManager(tdpc);
        this.testDataReference = tdr;
        this.tdpc = tdpc;
    }

    @Override
    public void register(Context context) {
        context.listen(InitializeScenario.Listener.class, (Object)this);
        context.listen(ConfigurePorts.Listener.class, (Object)this);
        context.listen(RunScenario.Listener.class, (Object)this);
    }

    public void onScenarioInitializeStarting(RuntimeScenario rtScenario) {
        Date time = new Date();
        ScenarioReader mScenarioReader = rtScenario.getModelScenarioReader();
        ByteBlowerProjectReader projectReader = mScenarioReader.getProjectReader();
        String projectName = projectReader.getName();
        String projectAuthor = projectReader.getAuthor();
        String projectVersion = ((ByteBlowerProject)projectReader.getObject()).getModelVersion();
        String scenarioName = mScenarioReader.getName();
        String testRunTitle = rtScenario.getRunTitle();
        this.testDataReference.setProjectName(projectName);
        this.testDataReference.setProjectAuthor(projectAuthor);
        this.testDataReference.setProjectVersion(projectVersion);
        this.testDataReference.setTestType(com.excentis.products.byteblower.results.dataprovider.data.enums.TestType.SCENARIOTEST);
        this.testDataReference.setTestName(scenarioName);
        this.testDataReference.setTestRunTitle(testRunTitle);
        this.testDataReference.setStatus(com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus.EXECUTING);
        this.testDataReference.setStartTime(time);
        this.testDataReferenceManager.persistIdEntity((BaseEntity)this.testDataReference);
        this.testEntity = new Test(projectName, projectAuthor, projectVersion, TestType.SCENARIOTEST, scenarioName, testRunTitle);
        this.testEntity.setInitStartTime(time);
        this.testEntity.setStatus(TestStatus.INITIALIZING);
        this.testManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.testEntity);
        ScenarioReader reader = rtScenario.getModelScenarioReader();
        EventManager eventManager = new EventManager(this.tdpc);
        Date now = new Date();
        if (!projectReader.isResultsOverTimeEnabled()) {
            Event testEvent = new Event(now, "Graphs with results over time have been disabled in the Report Project Properties. Click here for help.", EventSeverity.TEST_INFO, "SUGGESTION", "https://support.excentis.com/index.php?/Knowledgebase/Article/View/running-big-scenarios");
            eventManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)testEvent);
        } else if (reader.blockResultsOverTime()) {
            Event testEvent = new Event(now, "Graphs with results over time have been disabled automatically because the scenario contains more than 100 flows. Click here for help.", EventSeverity.TEST_INFO, "SUGGESTION", "https://support.excentis.com/index.php?/Knowledgebase/Article/View/running-big-scenarios");
            eventManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)testEvent);
        }
    }

    public void onPortsConfigured(RuntimeScenario rtScenario) {
        Date time = new Date();
        this.testEntity.setInitEndTime(time);
        this.testEntity.setStatus(TestStatus.INITIALIZED);
        this.testEntity.setRunStartTime(time);
        this.testEntity.setStatus(TestStatus.RUNNING);
        this.testManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.testEntity);
        this.scenarioEntity = new Scenario(rtScenario.getName());
        this.scenarioEntity.setInitStartTime(time);
        this.scenarioEntity.setStatus(ScenarioStatus.INITIALIZING);
        this.scenarioManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.scenarioEntity);
    }

    public void onScenarioInitializeFinished(RuntimeScenario rtScenario) {
        Date time = new Date();
        this.scenarioEntity.setInitEndTime(time);
        this.scenarioEntity.setStatus(ScenarioStatus.INITIALIZED);
        this.scenarioManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.scenarioEntity);
        this.addTagsAfterInitialization(rtScenario);
    }

    private void addTagsAfterInitialization(RuntimeScenario rtScenario) {
        for (RuntimePort rtPort : rtScenario.getRuntimePorts()) {
            if (rtPort.hasVlanFilter()) {
                this.addTag("VLAN");
            }
            if (rtPort.isRuntimeLayer3Ipv4()) {
                this.addTag("IPV4");
            }
            if (rtPort.isRuntimeLayer3Ipv6()) {
                this.addTag("IPV6");
            }
            if (rtPort.getModelPortReader().usesDHCP()) {
                this.addTag("DHCP");
            } else if (rtPort.getModelPortReader().usesStatelessAutoconfiguration()) {
                this.addTag("SLAAC");
            } else {
                this.addTag("FIXEDIP");
            }
            if (rtPort.isMobile()) {
                this.addTag("MOBILE");
            }
            if (!rtPort.isNatted()) continue;
            this.addTag("NAT");
        }
        for (RuntimeFlow rtFlow : rtScenario.getRuntimeFlows()) {
            FlowReader flowReader = rtFlow.getModelFlowReader();
            if (flowReader.isFrameBlastingFlow()) {
                this.addTag("FRAMEBLASTING");
                if (flowReader.isUnicast()) {
                    this.addTag("UNICAST");
                } else if (flowReader.isMulticast()) {
                    this.addTag("MULTICAST");
                } else if (flowReader.isBroadcast()) {
                    this.addTag("BROADCAST");
                }
            }
            if (flowReader.isTcpFlow()) {
                this.addTag("TCP");
            }
            if (rtFlow.hasLatencyMeasurement()) {
                this.addTag("LATENCY");
            }
            if (rtFlow.hasOutOfSequenceDetection()) {
                this.addTag("OUTOFSEQUENCE");
            }
            if (rtFlow.getEavesdropperRuntimePorts().isEmpty()) continue;
            this.addTag("EAVESDROPPER");
        }
    }

    private void addTag(String tagName) {
        MetaDataPersistenceController.getInstance().addTag(this.testDataReference, tagName);
        Tag tag = new Tag(tagName);
        this.tagManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)tag);
    }

    public void onScenarioInitializeCancelled(RuntimeScenario rtScenario) {
        Date time = new Date();
        if (this.scenarioEntity != null) {
            this.scenarioEntity.setInitEndTime(time);
            this.scenarioEntity.setStatus(ScenarioStatus.CANCELLED);
            this.scenarioManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.scenarioEntity);
        }
        if (this.testEntity.getStatus() == TestStatus.INITIALIZING) {
            this.testEntity.setInitEndTime(time);
            this.testEntity.setStatus(TestStatus.CANCELLED);
            this.testManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.testEntity);
        } else {
            this.testEntity.setRunEndTime(time);
            this.testEntity.setStatus(TestStatus.CANCELLED);
            this.testManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.testEntity);
        }
        this.testDataReference.setEndTime(time);
        this.testDataReference.setStatus(com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus.CANCELLED);
        this.testDataReferenceManager.persistIdEntity((BaseEntity)this.testDataReference);
        this.addTagsAfterInitialization(rtScenario);
    }

    public void onScenarioInitializeFailed(RuntimeScenario rtScenario, String errorMessage) {
        Date time = new Date();
        if (this.scenarioEntity != null) {
            this.scenarioEntity.setInitEndTime(time);
            this.scenarioEntity.setStatus(ScenarioStatus.ERROR);
            this.scenarioManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.scenarioEntity);
        }
        if (this.testEntity != null) {
            if (this.testEntity.getStatus() == TestStatus.INITIALIZING) {
                this.testEntity.setInitEndTime(time);
                this.testEntity.setStatus(TestStatus.ERROR);
                this.testManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.testEntity);
            } else {
                this.testEntity.setRunEndTime(time);
                this.testEntity.setStatus(TestStatus.ERROR);
                this.testManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.testEntity);
            }
        }
        this.testDataReference.setEndTime(time);
        this.testDataReference.setStatus(com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus.ERROR);
        this.testDataReferenceManager.persistIdEntity((BaseEntity)this.testDataReference);
        this.addTagsAfterInitialization(rtScenario);
    }

    public void onScenarioRunStarting(RuntimeScenario rtScenario) {
        Date time = new Date();
        this.scenarioEntity.setRunStartTime(time);
        this.scenarioEntity.setStatus(ScenarioStatus.RUNNING);
        this.scenarioManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.scenarioEntity);
    }

    public void onScenarioRunUpdate(RuntimeScenario rtScenario) {
    }

    public void onScenarioRunFinished(RuntimeScenario rtScenario) {
        Date time = new Date();
        this.scenarioEntity.setRunEndTime(time);
        this.scenarioEntity.setStatus(ScenarioStatus.FINISHED);
        this.scenarioManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.scenarioEntity);
        this.testEntity.setRunEndTime(time);
        this.testEntity.setStatus(TestStatus.FINISHED);
        this.testManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.testEntity);
        this.testDataReference.setEndTime(time);
        this.testDataReference.setStatus(com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus.FINISHED);
        this.testDataReferenceManager.persistIdEntity((BaseEntity)this.testDataReference);
    }

    public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
        Date time = new Date();
        this.scenarioEntity.setRunEndTime(time);
        this.scenarioEntity.setStatus(ScenarioStatus.CANCELLED);
        this.scenarioManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.scenarioEntity);
        this.testEntity.setRunEndTime(time);
        this.testEntity.setStatus(TestStatus.CANCELLED);
        this.testManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.testEntity);
        this.testDataReference.setEndTime(time);
        this.testDataReference.setStatus(com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus.CANCELLED);
        this.testDataReferenceManager.persistIdEntity((BaseEntity)this.testDataReference);
    }

    public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
        Date time = new Date();
        this.scenarioEntity.setRunEndTime(time);
        this.scenarioEntity.setStatus(ScenarioStatus.ERROR);
        this.scenarioManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.scenarioEntity);
        this.testEntity.setRunEndTime(time);
        this.testEntity.setStatus(TestStatus.ERROR);
        this.testManager.persistIdEntity((com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity)this.testEntity);
        this.testDataReference.setEndTime(time);
        this.testDataReference.setStatus(com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus.ERROR);
        this.testDataReferenceManager.persistIdEntity((BaseEntity)this.testDataReference);
    }
}

