/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.datapersistence.listeners.BaseHandle;
import com.excentis.products.byteblower.datapersistence.util.FrameBlastingUtils;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.FbFlowTemplateManager;
import com.excentis.products.byteblower.results.testdata.data.FbFrameManager;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplate;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplateFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrameSizeFixed;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowResult;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowTest;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.run.actions.CreateFlow;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RFC2544.TestResult;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrameBlastingBenchmark;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThroughputTestHandle
extends BaseHandle
implements CreateFlow.Listener,
RunScenario.Listener {
    private List<RuntimeFrameBlastingBenchmark> flows = new ArrayList<RuntimeFrameBlastingBenchmark>();
    private TestDataPersistenceController pc;

    public ThroughputTestHandle(TestDataPersistenceController pc) {
        super(pc);
        this.pc = pc;
    }

    @Override
    public void register(Context context) {
        context.listen(CreateFlow.Listener.class, (Object)this);
        context.listen(RunScenario.Listener.class, (Object)this);
    }

    public void onFlowCreated(RuntimeFlow rtFlow) {
        if (rtFlow instanceof RuntimeFrameBlastingBenchmark) {
            RuntimeFrameBlastingBenchmark rtt = (RuntimeFrameBlastingBenchmark)rtFlow;
            this.flows.add(rtt);
        }
    }

    public void onFlowCreationFailed(FlowMeasurement mFlowInstance, String errorMessage) {
        String flowName = mFlowInstance.getFlow().getName();
        FlowMeasurementReader reader = ReaderFactory.create((FlowMeasurement)mFlowInstance);
        FrameBlastingUtils utils = new FrameBlastingUtils(this.pc);
        FbFlowInstance fbFlowInstance = utils.persistFbFlowInstance(reader);
        EventManager eventManager = new EventManager(this.pc);
        String message = "Failed to create flow instance '" + flowName + "' due to following error:\n" + errorMessage;
        EventSeverity severity = EventSeverity.TEST_ERROR;
        FlowInstanceEvent event = new FlowInstanceEvent(new Date(), message, severity, (FlowInstance)fbFlowInstance);
        eventManager.persistIdEntity((BaseEntity)event);
    }

    public void onScenarioRunStarting(RuntimeScenario rtScenario) {
    }

    public void onScenarioRunUpdate(RuntimeScenario rtScenario) {
    }

    private FbFlowTemplate persistBenchmarkFlowTemplate(RuntimeFrameBlastingBenchmark benchmark, long size) {
        FbFlowTemplateManager fbFlowTemplateManager = new FbFlowTemplateManager(this.pc);
        String flowTemplateName = String.valueOf(benchmark.getName()) + size;
        long frameInterval = 10L;
        FbFlowTemplate foundTemplate = fbFlowTemplateManager.find(flowTemplateName);
        if (foundTemplate == null) {
            FbFlowTemplate newTemplate = new FbFlowTemplate(flowTemplateName, Long.valueOf(frameInterval));
            fbFlowTemplateManager.persistIdEntity((BaseEntity)newTemplate);
            foundTemplate = newTemplate;
        }
        FbFrameManager fbFrameManager = new FbFrameManager(this.pc);
        BaseEntityManager fbFlowTemplateFrameManager = new BaseEntityManager(FbFlowTemplateFrame.class, this.pc);
        String frameName = "RFC_2544_FRAME_" + size;
        Integer repeatCount = 1;
        Integer position = 0;
        FbFrame fbFrame = fbFrameManager.find(frameName);
        if (fbFrame == null) {
            fbFrame = new FbFrameSizeFixed(frameName, Integer.valueOf((int)size));
            fbFrameManager.persistIdEntity((BaseEntity)fbFrame);
        }
        FbFlowTemplateFrame flowTemplateFrame = new FbFlowTemplateFrame(foundTemplate, fbFrame, position, repeatCount);
        fbFlowTemplateFrameManager.persistIdEntity((BaseEntity)flowTemplateFrame);
        return foundTemplate;
    }

    private void storeResults(RuntimeFrameBlastingBenchmark benchmark, List<TestResult> samesize) {
        long size = samesize.get((int)0).frameSize;
        double resolution = benchmark.getResolution();
        double allowedLoss = benchmark.getAcceptableLoss();
        BaseEntityManager ttFlowTest = new BaseEntityManager(ThroughputFlowTest.class, this.pc);
        FbFlowTemplateManager mng = new FbFlowTemplateManager(this.pc);
        FbFlowTemplate template = mng.find(String.valueOf(benchmark.getFlowTemplateName()) + size);
        if (template == null) {
            template = this.persistBenchmarkFlowTemplate(benchmark, size);
        }
        PortManager portManager = new PortManager(this.pc);
        RuntimePort source = benchmark.getSourceRuntimePort();
        Port psource = portManager.find(source.getName());
        RuntimePort dest = (RuntimePort)benchmark.getDestinationRuntimePorts().get(0);
        Port pdest = portManager.find(dest.getName());
        ThroughputFlowTest test = new ThroughputFlowTest(psource, pdest, template, benchmark.getIterationDuration(), benchmark.getName(), allowedLoss, resolution);
        for (ThroughputFlowTest runningThroughputTests : ttFlowTest.getEntities()) {
            if (!runningThroughputTests.getSource().equals((Object)psource) || !runningThroughputTests.getDestination().equals((Object)pdest) || !runningThroughputTests.getFlowTemplate().equals((Object)template)) continue;
            test = runningThroughputTests;
            break;
        }
        for (TestResult indivual : samesize) {
            ThroughputFlowResult persisted = new ThroughputFlowResult(test, indivual.interFrameGap, indivual.tx, indivual.tx, indivual.rx, indivual.duration, indivual.txPackets, indivual.rxPackets);
            test.mergeResult(persisted);
        }
        ttFlowTest.persistIdEntity((BaseEntity)test);
    }

    private void storeResults(RuntimeScenario rtScenario) {
        for (RuntimeFrameBlastingBenchmark benchmark : this.flows) {
            List result = benchmark.getResults();
            HashMap sizeGrouped = new HashMap();
            for (TestResult testResult : result) {
                List<TestResult> sameSize;
                if (sizeGrouped.containsKey(testResult.frameSize)) {
                    sameSize = (List)sizeGrouped.get(testResult.frameSize);
                } else {
                    sameSize = new ArrayList();
                    sizeGrouped.put(testResult.frameSize, sameSize);
                }
                sameSize.add(testResult);
            }
            for (Map.Entry entry : sizeGrouped.entrySet()) {
                this.storeResults(benchmark, (List)entry.getValue());
            }
        }
    }

    public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
        this.storeResults(rtScenario);
    }

    public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
        this.storeResults(rtScenario);
    }

    public void onScenarioRunFinished(RuntimeScenario rtScenario) {
        this.storeResults(rtScenario);
    }
}

