/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.WeakHashMap;

public class FileBlocks {
    private static final long COUNT_DESCRIPTORS = 1024L;
    private static final long FILE_SIZE_CHUNK = 0x100000L;
    private static final long NO_NEXT = 0L;
    private final WeakHashMap<Long, MappedByteBuffer> bufferCache = new WeakHashMap();
    private RandomAccessFile outputFile;
    private long nextStreamId;
    private long writtenSize = 0L;
    private long allocatedSize = 0L;
    private MODE mode;

    private ByteBuffer getBuffer(long position) throws IOException {
        long startRequestedBuffer = position / 0x100000L * 0x100000L;
        long fileRemaining = this.allocatedSize - startRequestedBuffer;
        if (this.mode == MODE.WRITE && fileRemaining <= 0x100000L) {
            this.allocatedSize += 0x100000L;
            this.outputFile.setLength(this.allocatedSize);
        }
        if (startRequestedBuffer + 524288L < position) {
            startRequestedBuffer += 524288L;
        }
        Object NOT_FOUND = null;
        MappedByteBuffer currentBuffer = this.bufferCache.get(startRequestedBuffer);
        if (currentBuffer == NOT_FOUND) {
            currentBuffer = this.outputFile.getChannel().map(FileChannel.MapMode.READ_WRITE, startRequestedBuffer, 0x100000L);
            this.bufferCache.put(startRequestedBuffer, currentBuffer);
        }
        currentBuffer.rewind();
        currentBuffer.position((int)(position - startRequestedBuffer));
        return currentBuffer.slice();
    }

    public FileBlocks(String fileName, MODE mode) throws IOException {
        this.outputFile = new RandomAccessFile(fileName, "rw");
        this.mode = mode;
        if (mode == MODE.WRITE) {
            this.outputFile.setLength(0L);
            int ctr = 0;
            while ((long)ctr < 1024L) {
                this.outputFile.writeLong(0L);
                ++ctr;
            }
            this.outputFile.setLength(this.writtenSize + 0x100000L);
        }
        this.writtenSize = this.outputFile.getFilePointer();
        this.allocatedSize = this.outputFile.length();
        this.nextStreamId = 0L;
    }

    public Reader createReader(long id) throws IOException {
        Reader result = new Reader(id);
        result.readPosition = this.readFromIndex(id);
        return result;
    }

    public Writer createWriter() {
        long current = this.nextStreamId++;
        return new Writer(current);
    }

    private void write(Writer stream, byte[] data) throws IOException {
        long startPosition = this.writtenSize;
        ByteBuffer writable = this.getBuffer(startPosition);
        writable.putLong(0L);
        writable.putLong(stream.id);
        writable.putLong(data.length);
        writable.put(data);
        this.writtenSize += (long)writable.position();
        if (stream.previous == 0L) {
            this.putIntoIndex(stream.id, startPosition);
        } else {
            ByteBuffer correction = this.getBuffer(stream.previous);
            correction.putLong(startPosition);
        }
        stream.previous = startPosition;
    }

    private void putIntoIndex(long streamId, long startPosition) throws IOException {
        long NEXT_POINTER_OFFSET = 1023L;
        long currentIdxPosition = 0L;
        long writePosition = streamId;
        while (writePosition >= 1023L) {
            ByteBuffer currentBuffer = this.getBuffer(currentIdxPosition + 8184L);
            long nextIdx = currentBuffer.getLong();
            if (nextIdx == 0L) {
                nextIdx = this.writtenSize;
                currentBuffer.rewind();
                currentBuffer.putLong(nextIdx);
                ByteBuffer g = this.getBuffer(nextIdx);
                int ctr = 0;
                while ((long)ctr < 1024L) {
                    g.putLong(0L);
                    ++ctr;
                }
                this.writtenSize += (long)g.position();
            }
            currentIdxPosition = nextIdx;
            writePosition -= 1023L;
        }
        long offset = writePosition * 8L;
        ByteBuffer correction = this.getBuffer(offset + currentIdxPosition);
        correction.putLong(startPosition);
    }

    private long readFromIndex(long streamId) throws IOException {
        long NEXT_POINTER_OFFSET = 1023L;
        long currentIdxPosition = 0L;
        long writePosition = streamId;
        while (writePosition >= 1023L) {
            ByteBuffer currentBuffer = this.getBuffer(currentIdxPosition + 8184L);
            long nextIdx = currentBuffer.getLong();
            if (nextIdx == 0L) {
                return 0L;
            }
            currentIdxPosition = nextIdx;
            writePosition -= 1023L;
        }
        long offset = writePosition * 8L;
        ByteBuffer correction = this.getBuffer(offset + currentIdxPosition);
        return correction.getLong();
    }

    private byte[] read(Reader block) throws IOException {
        ByteBuffer readable = this.getBuffer(block.readPosition);
        long nextPosition = readable.getLong();
        long stream = readable.getLong();
        assert (stream == block.id);
        long length = readable.getLong();
        block.readPosition = nextPosition;
        byte[] result = new byte[(int)length];
        readable.get(result);
        return result;
    }

    public void close() throws IOException {
        if (this.mode == MODE.WRITE) {
            this.outputFile.setLength(this.allocatedSize);
        }
        this.outputFile.close();
    }

    public static enum MODE {
        READ,
        WRITE;

    }

    public class Reader {
        public final long id;
        public long readPosition;

        private Reader(long id) {
            this.id = id;
        }

        public byte[] read() throws IOException {
            return FileBlocks.this.read(this);
        }

        public boolean hasNext() {
            return this.readPosition != 0L;
        }
    }

    public class Writer {
        private long previous = 0L;
        public final long id;

        private Writer(long id) {
            this.id = id;
        }

        public void write(byte[] data) throws IOException {
            FileBlocks.this.write(this, data);
        }
    }
}

