/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.util;

import com.excentis.products.byteblower.communication.api.WiFiBand;
import com.excentis.products.byteblower.run.utils.LocalNetworkInfoResult;

public class LegacyWiFiNaming {
    private static final int MAX_NETIF_LENGTH = 128;
    private static final int MAX_SSID_LENGTH = 40;

    static {
        String someInterface = "aaaaaaaaaabbbbbbbb";
        String veryLongInterface = "a".repeat(129);
        String justLongEnoughInterface = "c".repeat(127);
        assert (LegacyWiFiNaming.simpleInterface("aaaaaaaaaabbbbbbbb").contains("aaaaaaaaaabbbbbbbb"));
        assert (LegacyWiFiNaming.simpleInterface(veryLongInterface).length() <= 128);
        assert (LegacyWiFiNaming.simpleInterface(justLongEnoughInterface).length() <= 128);
        assert (LegacyWiFiNaming.mloInterface("aaaaaaaaaabbbbbbbb", 10L).contains("aaaaaaaaaabbbbbbbb"));
        assert (LegacyWiFiNaming.mloInterface(veryLongInterface, 146L).length() <= 128);
        assert (LegacyWiFiNaming.mloInterface(justLongEnoughInterface, Integer.MAX_VALUE).length() <= 128);
        assert (LegacyWiFiNaming.ssid(null, null).length() == 0);
    }

    public static String humanInterfaceName(LocalNetworkInfoResult.LocalNetworkInterface netIf, LocalNetworkInfoResult.LocalWiFiLink link) {
        if (0L >= link.id) {
            return LegacyWiFiNaming.simpleInterface(netIf.name);
        }
        return LegacyWiFiNaming.mloInterface(netIf.name, link.id);
    }

    private static String mloInterface(String name, long linkId) {
        String template = "Interface: %s (MLO LinkID=%d)";
        String ifName = String.format("Interface: %s (MLO LinkID=%d)", name, linkId);
        int tooManyChars = ifName.length() - 128;
        if (tooManyChars > 0) {
            String shortName = name.substring(0, name.length() - tooManyChars);
            return LegacyWiFiNaming.mloInterface(shortName, linkId);
        }
        return ifName;
    }

    private static String simpleInterface(String ifName) {
        String template = "Interface: %s";
        String humanName = String.format("Interface: %s", ifName);
        if (humanName.length() > 128) {
            return humanName.substring(0, 128);
        }
        return humanName;
    }

    public static String ssid(String ssid, LocalNetworkInfoResult.LocalWiFiLink link) {
        if (ssid == null || ssid.length() == 0) {
            return "";
        }
        String bandInfo = LegacyWiFiNaming.bandToString(link.frequencyBand);
        int naiveLength = bandInfo.length() + ssid.length();
        if (naiveLength > 40) {
            return String.valueOf(ssid.substring(0, naiveLength - 40)) + bandInfo;
        }
        return String.valueOf(ssid) + bandInfo;
    }

    private static String bandToString(WiFiBand frequencyBand) {
        if (frequencyBand == WiFiBand.Band_2_4_GHz) {
            return " [2.4 GHz]";
        }
        if (frequencyBand == WiFiBand.Band_5_GHz) {
            return " [5 GHz]";
        }
        if (frequencyBand == WiFiBand.Band_6_GHz) {
            return " [6 GHz]";
        }
        if (frequencyBand == WiFiBand.Band_60_GHz) {
            return " [60 GHz]";
        }
        return "";
    }
}

