/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.util;

import com.excentis.products.byteblower.datapersistence.util.CorruptJournalException;
import com.excentis.products.byteblower.datapersistence.util.ReportUploadThread;
import com.excentis.products.byteblower.datapersistence.util.SaveTestDataVisitor;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UploadJournal {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final int COMMAND_SIZE = 256;
    private static Path journalFile = Paths.get(UploadJournal.baseSaveLocation().toString(), "upload.journal");

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$datapersistence$util$UploadJournal$JournalCommand = UploadJournal.$SWITCH_TABLE$com$excentis$products$byteblower$datapersistence$util$UploadJournal$JournalCommand();
    }

    public static Path baseSaveLocation() {
        String parent = TestDataPersistenceController.saveLocation();
        Path base = parent.startsWith("~/") ? Paths.get(System.getProperty("user.home"), parent.substring(2)) : Paths.get(parent, new String[0]);
        return base;
    }

    private static int tryParseInt(String val) {
        try {
            return Integer.parseInt(val.strip());
        }
        catch (NumberFormatException e) {
            return Integer.MIN_VALUE;
        }
    }

    private static long tryParseLong(String val) {
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return Long.MIN_VALUE;
        }
    }

    private static Map<String, ReportUploadThread> gatherInfo(FileChannel logChannel, FileLock locked) throws IOException, CorruptJournalException {
        String line;
        if (!locked.isValid()) {
            throw new CorruptJournalException("Only gather info from a locked Journal");
        }
        HashMap<String, ReportUploadThread> openThreads = new HashMap<String, ReportUploadThread>();
        while (!(line = UploadJournal.readCommand(logChannel)).isEmpty()) {
            JournalCommand cmd = JournalCommand.parseCmd(line);
            switch (cmd) {
                case FAIL: {
                    String[] parts = line.split(", ");
                    String testId = parts[1];
                    int uploadCtr = UploadJournal.tryParseInt(parts[2]);
                    String fileName = parts[3].trim();
                    ReportUploadThread thread = openThreads.computeIfAbsent(testId, ReportUploadThread::new);
                    thread.addFail(uploadCtr, fileName);
                    break;
                }
                case SUCCESS: {
                    String[] parts = line.split(", ");
                    String testId = parts[1];
                    int uploadCtr = UploadJournal.tryParseInt(parts[2]);
                    String nextLink = parts[3];
                    String fileName = parts[4].trim();
                    ReportUploadThread thread = openThreads.computeIfAbsent(testId, ReportUploadThread::new);
                    thread.addSuccess(uploadCtr, nextLink, fileName);
                    break;
                }
                case TRY: {
                    String[] parts = line.split(", ");
                    String testId = parts[1];
                    int uploadCtr = UploadJournal.tryParseInt(parts[2]);
                    long when = UploadJournal.tryParseLong(parts[3]);
                    String fileName = parts[4].trim();
                    ReportUploadThread thread = openThreads.computeIfAbsent(testId, ReportUploadThread::new);
                    thread.addTryUpload(uploadCtr, fileName, when);
                    break;
                }
                case FINISH: {
                    String[] parts = line.split(", ");
                    String testId = parts[1];
                    int uploadCtr = UploadJournal.tryParseInt(parts[2]);
                    ReportUploadThread thread = openThreads.computeIfAbsent(testId, ReportUploadThread::new);
                    thread.addFinish(uploadCtr);
                }
            }
        }
        return openThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitNotFinished(SaveTestDataVisitor visitor) {
        void var2_4;
        Object object;
        HashMap hashMap = new HashMap();
        Path path = journalFile;
        synchronized (path) {
            block21: {
                try {
                    object = null;
                    Object var5_10 = null;
                    try {
                        FileChannel logChannel = FileChannel.open(journalFile, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                        try {
                            try (FileLock lock = logChannel.tryLock();){
                                Map<String, ReportUploadThread> map = UploadJournal.gatherInfo(logChannel, lock);
                            }
                            if (logChannel == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (object == null) {
                                object = throwable;
                            } else if (object != throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            if (logChannel == null) throw object;
                            logChannel.close();
                            throw object;
                        }
                        logChannel.close();
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                            throw object;
                        }
                        if (object == throwable) throw object;
                        ((Throwable)object).addSuppressed(throwable);
                        throw object;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, " Failed", e);
                }
                catch (CorruptJournalException e) {
                    LOGGER.log(Level.SEVERE, " The upload has become corrupt journal ", e);
                }
            }
        }
        object = var2_4.values().iterator();
        while (true) {
            if (!object.hasNext()) {
                visitor.finished();
                return;
            }
            ReportUploadThread thread = (ReportUploadThread)object.next();
            boolean isPending = thread.isFinished() && !thread.isFullyUploaded();
            if (!isPending) continue;
            thread.visitNotFinished(visitor, UploadJournal.baseSaveLocation().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int countNotFinished() {
        void var1_3;
        Iterator iterator;
        HashMap hashMap = new HashMap();
        Path path = journalFile;
        synchronized (path) {
            block21: {
                try {
                    Throwable throwable = null;
                    iterator = null;
                    try {
                        FileChannel logChannel = FileChannel.open(journalFile, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                        try {
                            try (FileLock lock = logChannel.tryLock();){
                                Map<String, ReportUploadThread> map = UploadJournal.gatherInfo(logChannel, lock);
                            }
                            if (logChannel == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (logChannel == null) throw throwable;
                            logChannel.close();
                            throw throwable;
                        }
                        logChannel.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, " Failed", e);
                }
                catch (CorruptJournalException e) {
                    LOGGER.log(Level.SEVERE, " The upload has become corrupt journal ", e);
                }
            }
        }
        int resultCtr = 0;
        iterator = var1_3.values().iterator();
        while (iterator.hasNext()) {
            ReportUploadThread anUploadThread = (ReportUploadThread)iterator.next();
            if (!anUploadThread.isFinished() || anUploadThread.isFullyUploaded()) continue;
            ++resultCtr;
        }
        return resultCtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<RedoUpload> searchNotFinished() {
        void var1_3;
        Iterator iterator;
        HashMap hashMap = new HashMap();
        Path path = journalFile;
        synchronized (path) {
            block21: {
                try {
                    Throwable throwable = null;
                    iterator = null;
                    try {
                        FileChannel logChannel = FileChannel.open(journalFile, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                        try {
                            try (FileLock lock = logChannel.tryLock();){
                                Map<String, ReportUploadThread> map = UploadJournal.gatherInfo(logChannel, lock);
                            }
                            if (logChannel == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (logChannel == null) throw throwable;
                            logChannel.close();
                            throw throwable;
                        }
                        logChannel.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, " Failed", e);
                }
                catch (CorruptJournalException e) {
                    LOGGER.log(Level.SEVERE, " The upload has become corrupt journal ", e);
                }
            }
        }
        ArrayList<RedoUpload> remainingWork = new ArrayList<RedoUpload>();
        iterator = var1_3.values().iterator();
        while (iterator.hasNext()) {
            ReportUploadThread anUploadThread = (ReportUploadThread)iterator.next();
            if (!anUploadThread.hasNext()) continue;
            remainingWork.add(anUploadThread.next());
        }
        return remainingWork;
    }

    private static String readCommand(FileChannel channel) throws IOException {
        int current;
        ByteBuffer cmd = ByteBuffer.allocate(256);
        int read = 0;
        do {
            if ((current = channel.read(cmd)) > 0) continue;
            return "";
        } while ((read += current) < 256);
        return new String(cmd.array());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String searchUploadLink(String textrunId, int prevSequence) {
        var3_3 = UploadJournal.journalFile;
        synchronized (var3_3) {
            try {
                var4_4 = null;
                var5_8 = null;
                try {
                    logChannel2 = FileChannel.open(UploadJournal.journalFile, new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE});
                    try {
                        lock = logChannel2.tryLock();
                        try {
                            line = "";
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var4_5) {
                            if (lock == null) throw var4_5;
                            lock.close();
                            throw var4_5;
                        }
lbl18:
                        // 1 sources

                        while (true) {
                            lock.close();
                            while (true) {
                                if (logChannel2 == null) return v0;
                                ** GOTO lbl45
                                break;
                            }
                            break;
                        }
                    }
                    catch (Throwable var5_9) {
                        block22: {
                            if (var4_4 == null) {
                                var4_4 = var5_9;
                            } else if (var4_4 != var5_9) {
                                var4_4.addSuppressed(var5_9);
                            }
                            if (logChannel2 == null) throw var4_4;
                            logChannel2.close();
                            throw var4_4;
                            while (true) {
                                if (JournalCommand.parseCmd(line) != JournalCommand.SUCCESS) continue;
                                parts = line.split(", ");
                                if (parts.length != 5) {
                                    throw new CorruptJournalException();
                                }
                                listedTest = parts[1];
                                sequence = UploadJournal.tryParseInt(parts[2]);
                                link = parts[3];
                                v1 = found = listedTest.equals(textrunId) != false && sequence == prevSequence;
                                if (!found) continue;
                                v0 = link;
                                if (lock == null) ** continue;
                                ** continue;
                                break;
                            }
lbl45:
                            // 1 sources

                            logChannel2.close();
                            return v0;
lbl-1000:
                            // 3 sources

                            {
                                if (!(line = UploadJournal.readCommand(logChannel2)).isEmpty()) ** continue;
                                if (lock == null) break block22;
                            }
                            lock.close();
                        }
                        if (logChannel2 == null) return "";
                        logChannel2.close();
                    }
                }
                catch (Throwable var5_10) {
                    if (var4_4 == null) {
                        var4_4 = var5_10;
                        throw var4_4;
                    }
                    if (var4_4 == var5_10) throw var4_4;
                    var4_4.addSuppressed(var5_10);
                    throw var4_4;
                }
            }
            catch (IOException e) {
                UploadJournal.LOGGER.log(Level.SEVERE, " Failed", e);
            }
            catch (CorruptJournalException e) {
                UploadJournal.LOGGER.log(Level.SEVERE, " The upload journal has become corrupt", e);
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void addToLog(String msg) {
        if (!UploadJournal.$assertionsDisabled && msg.getBytes().length != 256) {
            throw new AssertionError();
        }
        canRetry = true;
        failures = 0;
        while (canRetry) {
            var4_4 = UploadJournal.journalFile;
            synchronized (var4_4) {
                try {
                    var5_5 = null;
                    var6_8 = null;
                    try {
                        block26: {
                            block28: {
                                block27: {
                                    logChannel = FileChannel.open(UploadJournal.journalFile, new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE});
                                    lock = logChannel.tryLock();
                                    if (lock != null) break block26;
                                    ++failures;
                                    if (lock == null) break block27;
                                    lock.close();
                                }
                                if (logChannel == null) break block28;
                                logChannel.close();
                            }
                            continue;
                        }
                        try {
                            block29: {
                                logChannel.write(ByteBuffer.wrap(msg.getBytes()));
                                if (failures > 0) {
                                    logMsg = JournalCommand.LOG.command(new Object[]{"%s, failures, %d %n", JournalCommand.LOG, failures});
                                    logChannel.write(ByteBuffer.wrap(logMsg.getBytes()));
                                }
                                canRetry = false;
                                break block29;
                                {
                                    catch (Throwable var5_6) {
                                        throw var5_6;
                                    }
                                }
                                finally {
                                    if (lock != null) {
                                        lock.close();
                                    }
                                }
                            }
                            ** if (logChannel == null) goto lbl-1000
                        }
                        catch (Throwable var6_9) {
                            if (var5_5 == null) {
                                var5_5 = var6_9;
                            } else if (var5_5 != var6_9) {
                                var5_5.addSuppressed(var6_9);
                            }
                            if (logChannel != null) {
                                logChannel.close();
                            }
                            throw var5_5;
                        }
lbl-1000:
                        // 1 sources

                        {
                            logChannel.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    catch (Throwable var6_10) {
                        if (var5_5 == null) {
                            var5_5 = var6_10;
                        } else if (var5_5 != var6_10) {
                            var5_5.addSuppressed(var6_10);
                        }
                        throw var5_5;
                    }
                }
                catch (IOException e) {
                    UploadJournal.LOGGER.log(Level.SEVERE, "Not able to lock journal", e);
                    canRetry = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lines() {
        int counted = 0;
        Path path = journalFile;
        synchronized (path) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    FileChannel logChannel2 = FileChannel.open(journalFile, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                    try {
                        try (FileLock lock = logChannel2.tryLock();){
                            while (!UploadJournal.readCommand(logChannel2).isEmpty()) {
                                ++counted;
                            }
                        }
                        if (logChannel2 == null) return counted;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (logChannel2 == null) throw throwable;
                        logChannel2.close();
                        throw throwable;
                    }
                    logChannel2.close();
                    {
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Issue with processing lock", e);
            }
            return counted;
        }
    }

    public void addReport(String reportLink, String currentTestRun) {
        String msg = JournalCommand.REPORT.command(currentTestRun, reportLink);
        this.addToLog(msg);
    }

    public void addSuccess(String nextLink, String currentTestRun, int uploadCtr, Path filename) {
        String msg = JournalCommand.SUCCESS.command(currentTestRun, uploadCtr, nextLink, filename.getFileName());
        this.addToLog(msg);
    }

    public void addFail(Path jsonFile, String currentTestRun, int uploadCtr) {
        String msg = JournalCommand.FAIL.command(currentTestRun, uploadCtr, jsonFile.getFileName());
        this.addToLog(msg);
    }

    public void addLog(String msg) {
        String logMsg = JournalCommand.LOG.command(msg);
        this.addToLog(logMsg);
    }

    public void addFinish(String testid, int lastSequence) {
        String logMsg = JournalCommand.FINISH.command(testid, lastSequence);
        this.addToLog(logMsg);
    }

    public void addTry(String currentTestRun, int uploadCtr, Path filename) {
        long epochSeconds = Instant.now().toEpochMilli() / 1000L;
        String logMsg = JournalCommand.TRY.command(currentTestRun, uploadCtr, epochSeconds, filename.getFileName());
        this.addToLog(logMsg);
    }

    private static final class JournalCommand
    extends Enum<JournalCommand> {
        public static final /* enum */ JournalCommand SUCCESS = new JournalCommand();
        public static final /* enum */ JournalCommand FAIL = new JournalCommand();
        public static final /* enum */ JournalCommand UNKNOWN = new JournalCommand();
        public static final /* enum */ JournalCommand REPORT = new JournalCommand();
        public static final /* enum */ JournalCommand LOG = new JournalCommand();
        public static final /* enum */ JournalCommand TRY = new JournalCommand();
        public static final /* enum */ JournalCommand FINISH = new JournalCommand();
        private static final /* synthetic */ JournalCommand[] ENUM$VALUES;

        static {
            ENUM$VALUES = new JournalCommand[]{SUCCESS, FAIL, UNKNOWN, REPORT, LOG, TRY, FINISH};
            assert (SUCCESS.command("1", 2, true).contains("SUCCESS, 1, 2, true"));
            assert (FAIL.command("1", 2, true).getBytes().length == 256);
            assert (JournalCommand.parseCmd(REPORT.command(42)) == REPORT);
        }

        static JournalCommand parseCmd(String line) {
            if (line == null) {
                return UNKNOWN;
            }
            JournalCommand[] journalCommandArray = JournalCommand.values();
            int n = journalCommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                JournalCommand toCheck = journalCommandArray[n2];
                if (line.startsWith(toCheck.name())) {
                    return toCheck;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String command(Object ... vals) {
            ArrayList<String> stringVals = new ArrayList<String>();
            stringVals.add(this.name());
            Object[] objectArray = vals;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                stringVals.add(String.valueOf(arg));
                ++n2;
            }
            String baseMsg = String.join((CharSequence)", ", stringVals);
            int nPadding = 255 - baseMsg.getBytes().length;
            if (nPadding > 0) {
                baseMsg = String.valueOf(baseMsg) + " ".repeat(nPadding);
            }
            baseMsg = String.valueOf(baseMsg) + "\n";
            return baseMsg;
        }

        public static JournalCommand[] values() {
            JournalCommand[] journalCommandArray = ENUM$VALUES;
            int n = journalCommandArray.length;
            JournalCommand[] journalCommandArray2 = new JournalCommand[n];
            System.arraycopy(ENUM$VALUES, 0, journalCommandArray2, 0, n);
            return journalCommandArray2;
        }

        public static JournalCommand valueOf(String string) {
            return Enum.valueOf(JournalCommand.class, string);
        }
    }

    public static class RedoUpload {
        public final String testRun;
        public final int sequenceCtr;
        public final Path filename;

        public RedoUpload(String testRun, int sequenceCtr, String filename) {
            this.testRun = testRun;
            this.sequenceCtr = sequenceCtr;
            this.filename = Paths.get(UploadJournal.baseSaveLocation().toString(), filename.toString());
        }

        public String toString() {
            return String.format("%s [%d] :: %s", this.testRun, this.sequenceCtr, this.filename);
        }
    }
}

