/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.IntegerField;
import com.excentis.products.byteblower.frame.Ipv4AddressField;
import com.excentis.products.byteblower.frame.MacAddressField;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.RawField;
import java.util.Arrays;
import java.util.List;

public class ARPPacket
extends ProtocolLayer {
    private static final int ARPSIZE = 224;
    public static final int HARDWARE_TYPE_ETHERNET = 1;
    public static final int PROTOCOL_TYPE_IPV4 = 2048;
    public static final int OPERATION_REQUEST = 1;
    public static final int OPERATION_REPLY = 2;
    public static final int HARDWARE_LENGTH_ETHERNET = 6;
    public static final int PROTOCOL_LENGTH_IPV4 = 4;
    private static final int HARD_TYPE = 0;
    private static final int PRO_TYPE = 1;
    private static final int HARD_LEN = 2;
    private static final int PRO_LEN = 3;
    private static final int OP = 4;
    private static final int SHA = 5;
    private static final int SPA = 6;
    private static final int THA = 7;
    private static final int TPA = 8;
    private static final int PADDING = 9;
    private static final String[] FIELD_NAMES = new String[]{"Hardware Type", "Protocol Type", "Hardware Length", "Protocol Length", "Operation", "Sender Hardware Address", "Sender Protocol Address", "Target Hardware Address", "Target Protocol Address", "PADDING"};

    public ARPPacket() {
        super(0);
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(8));
        this.fields.add(new IntegerField(8));
        this.fields.add(new IntegerField(16));
        this.fields.add(new MacAddressField(48));
        this.fields.add(new Ipv4AddressField(32));
        this.fields.add(new MacAddressField(48));
        this.fields.add(new Ipv4AddressField(32));
        this.fields.add(new RawField(0));
        this.do_default();
    }

    public ARPPacket(ProtocolLayer parent) {
        this();
        this.setParent(parent);
    }

    private void do_default() {
        this.setHardType(1);
        this.setProType(2048);
        this.setHardLen(6);
        this.setProLen(4);
        this.setSHA("00-00-00-00-00-00");
        this.setSPA("00.00.00.00");
        this.setTHA("00-00-00-00-00-00");
        this.setTPA("00.00.00.00");
        this.size = 224;
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        this.size = 0;
        int initialOffset = offset;
        int used = 0;
        int i = 0;
        while (i <= 9) {
            offset = ((ProtocolField)this.fields.get(i)).set(bufsize - used, buffer, offset);
            used = offset - initialOffset;
            if (offset == -1 || used > bufsize) {
                return -1;
            }
            ++i;
        }
        this.calcSize();
        return initialOffset + used;
    }

    public void setHardType(int i) {
        ((IntegerField)this.fields.get(0)).set(i);
    }

    public void setProType(int i) {
        ((IntegerField)this.fields.get(1)).set(i);
    }

    public void setHardLen(int i) {
        ((IntegerField)this.fields.get(2)).set(i);
    }

    public void setProLen(int i) {
        ((IntegerField)this.fields.get(3)).set(i);
    }

    public void setOperation(int i) {
        ((IntegerField)this.fields.get(4)).set(i);
    }

    public void setSHA(String s) {
        ((MacAddressField)this.fields.get(5)).set(s);
    }

    public void setSPA(String s) {
        ((Ipv4AddressField)this.fields.get(6)).set(s);
    }

    public void setTHA(String s) {
        ((MacAddressField)this.fields.get(7)).set(s);
    }

    public void setTPA(String s) {
        ((Ipv4AddressField)this.fields.get(8)).set(s);
    }

    public int getHardType() {
        return ((IntegerField)this.fields.get(0)).getIntValue();
    }

    public int getProType() {
        return ((IntegerField)this.fields.get(1)).getIntValue();
    }

    public int getHardLen() {
        return ((IntegerField)this.fields.get(2)).getIntValue();
    }

    public int getProLen() {
        return ((IntegerField)this.fields.get(3)).getIntValue();
    }

    public int getOperation() {
        return ((IntegerField)this.fields.get(4)).getIntValue();
    }

    public String getSHA() {
        return ((MacAddressField)this.fields.get(5)).toString();
    }

    public String getSPA() {
        return ((Ipv4AddressField)this.fields.get(6)).toString();
    }

    public String getTHA() {
        return ((MacAddressField)this.fields.get(7)).toString();
    }

    public String getTPA() {
        return ((Ipv4AddressField)this.fields.get(8)).toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.fields.size()) {
            sb.append(this.fields.get(i));
            sb.append("-");
            ++i;
        }
        return sb.toString();
    }

    public Object getValue() {
        System.err.println("ARPPacket::getValue() missing!");
        return new Object();
    }

    @Override
    public List<String> getFieldsNames() {
        return Arrays.asList(FIELD_NAMES);
    }

    @Override
    public void setPayload(ProtocolField pf) {
        this.fields.set(9, pf);
        this.calcSize();
    }

    @Override
    public ProtocolField getPayload() {
        return (ProtocolField)this.fields.get(9);
    }

    @Override
    public String getShortDesc() {
        return null;
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        ARPPacket arp = new ARPPacket((ProtocolLayer)parent);
        arp.fields.clear();
        for (ProtocolField protoField : this.fields) {
            arp.fields.add(protoField.clone(arp));
        }
        return arp;
    }
}

