/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.PcapUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class FrameUtil {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final char[] helphex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private FrameUtil() {
    }

    private static String toHex(byte b) {
        StringBuffer sb = new StringBuffer();
        sb.append(helphex[(b & 0xF0) >> 4]);
        sb.append(helphex[b & 0xF]);
        return sb.toString();
    }

    private static int to_unsigned(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }

    static int calcCheckSum(byte[] buffer, int size, int sum) {
        int cs = sum;
        int pointer = 0;
        while (size > 1) {
            cs += FrameUtil.to_unsigned(buffer[pointer]) << 8;
            cs += FrameUtil.to_unsigned(buffer[pointer + 1]);
            pointer += 2;
            size -= 2;
        }
        if (size > 0) {
            cs += FrameUtil.to_unsigned(buffer[pointer]);
        }
        return cs;
    }

    static int calcCheckSum(byte[] buffer, int size) {
        return FrameUtil.calcCheckSum(buffer, size, 0);
    }

    static int complement(int i) {
        i ^= 0xFFFFFFFF;
        i ^= 0xFFFF;
        ++i;
        i = -i;
        return i;
    }

    static int intFold(int i) {
        i &= 0xFFFFFFFF;
        while (i >> 16 != 0) {
            i = (i & 0xFFFF) + (i >> 16);
        }
        return i;
    }

    static int byteToBitSet(byte b, BitSet bs, int offset) {
        if ((b & 0x80) == 128) {
            bs.set(offset++);
        } else {
            bs.clear(offset++);
        }
        if ((b & 0x40) == 64) {
            bs.set(offset++);
        } else {
            bs.clear(offset++);
        }
        if ((b & 0x20) == 32) {
            bs.set(offset++);
        } else {
            bs.clear(offset++);
        }
        if ((b & 0x10) == 16) {
            bs.set(offset++);
        } else {
            bs.clear(offset++);
        }
        if ((b & 8) == 8) {
            bs.set(offset++);
        } else {
            bs.clear(offset++);
        }
        if ((b & 4) == 4) {
            bs.set(offset++);
        } else {
            bs.clear(offset++);
        }
        if ((b & 2) == 2) {
            bs.set(offset++);
        } else {
            bs.clear(offset++);
        }
        if ((b & 1) == 1) {
            bs.set(offset++);
        } else {
            bs.clear(offset++);
        }
        return offset;
    }

    static String BitSettoString(BitSet bs, int offset, int len) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            char b = FrameUtil.BitSettochar(bs, offset + i);
            if (b < 'A' || b > 'z') {
                sb.append("(" + FrameUtil.toHex((byte)b) + ")");
            } else {
                sb.append(b);
            }
            i += 8;
        }
        return sb.toString();
    }

    private static char BitSettochar(BitSet bs, int offset) {
        char val = '\u0000';
        int i = 0;
        while (i < 8) {
            val = (char)(val << 1);
            if (bs.get(offset + i)) {
                val = (char)(val + '\u0001');
            }
            ++i;
        }
        return val;
    }

    static byte BitSettobyte(BitSet bs, int offset) {
        byte val = 0;
        int i = 0;
        while (i < 8) {
            val = (byte)(val << 1);
            if (bs.get(offset + i)) {
                val = (byte)(val + 1);
            }
            ++i;
        }
        return val;
    }

    static int getBit(byte[] buffer, int offset) {
        return buffer[offset / 8] & 1 << 7 - offset % 8;
    }

    static void setBit(byte[] buffer, int offset) {
        int n = offset / 8;
        buffer[n] = (byte)(buffer[n] | 1 << 7 - offset % 8);
    }

    static void resetBit(byte[] buffer, int offset) {
        int n = offset / 8;
        buffer[n] = (byte)(buffer[n] & ~((byte)(1 << 7 - offset % 8)));
    }

    public static ArrayList<Integer> parseCSV(String line, int end) {
        line = line.replaceAll(" ", "");
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(line, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.contains("-")) {
                list.addAll(FrameUtil.parseRange(token, end));
                continue;
            }
            list.add(Integer.parseInt(token));
        }
        return list;
    }

    private static Collection<? extends Integer> parseRange(String token, int end) {
        ArrayList<Integer> range;
        block3: {
            String[] parts;
            block2: {
                int start;
                range = new ArrayList<Integer>();
                parts = token.split("-");
                if (parts.length != 1) break block2;
                int ctr = start = Integer.parseInt(parts[0]);
                while (ctr <= end) {
                    range.add(ctr);
                    ++ctr;
                }
                break block3;
            }
            if (parts.length != 2) break block3;
            int start = Integer.parseInt(parts[0]);
            int endVal = Integer.parseInt(parts[1]);
            int ctr = start;
            while (ctr <= endVal) {
                range.add(ctr);
                ++ctr;
            }
        }
        return range;
    }

    public static int getnrPacketsInPcap(String location) {
        return PcapUtil.getnrPacketsInPcap(location);
    }

    public static String pcapToHexString(String file, int index) {
        return PcapUtil.pcapToHexString(file, index);
    }

    public static final class NoInstalledPCapException
    extends RuntimeException {
        private static final long serialVersionUID = 7632971431156305223L;
    }
}

