/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.FrameUtil;
import com.excentis.products.byteblower.frame.ProtocolField;
import java.util.BitSet;

class IntegerField
extends ProtocolField {
    int value = 0;
    private String[] labels = null;

    IntegerField(int size) {
        super(size);
    }

    public Object getValue() {
        return new Integer(this.value);
    }

    void setLabels(String[] l) {
        this.labels = (String[])l.clone();
    }

    @Override
    public int dump(byte[] buffer, int offset) {
        int tempvalue = this.value;
        if (offset % 8 != 0 || this.size % 8 != 0) {
            int i = this.size;
            while (i > 0) {
                if ((tempvalue & 1) == 1) {
                    FrameUtil.setBit(buffer, offset + i - 1);
                } else {
                    FrameUtil.resetBit(buffer, offset + i - 1);
                }
                tempvalue >>= 1;
                --i;
            }
        } else {
            int i = this.size / 8 + offset / 8;
            while (i > offset / 8) {
                buffer[i - 1] = (byte)(tempvalue % 256);
                tempvalue >>= 8;
                --i;
            }
        }
        return offset + this.size;
    }

    int dump(BitSet bs, int offset) {
        int temp = this.value;
        int i = this.size - 1;
        while (i >= 0) {
            if (temp % 2 == 1) {
                bs.set(offset + i);
            } else {
                bs.clear(offset + i);
            }
            temp >>= 1;
            --i;
        }
        return offset + this.size;
    }

    public String toString() {
        if (this.labels != null && this.value <= this.labels.length) {
            return this.labels[this.value];
        }
        return Integer.toString(this.value);
    }

    String toHexString() {
        if (this.labels != null && this.value <= this.labels.length) {
            return this.labels[this.value];
        }
        return Integer.toString(0xFF & this.value, 16);
    }

    void set(int i) {
        this.value = i;
    }

    void set(String s) {
        this.value = Integer.parseInt(s);
    }

    int set(BitSet bs, int offset) {
        this.value = 0;
        int i = 0;
        while (i < this.size) {
            this.value <<= 1;
            if (bs.get(i + offset)) {
                ++this.value;
            }
            ++i;
        }
        return offset + this.size;
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        if (bufsize < this.size) {
            return -1;
        }
        this.value = 0;
        if (this.size % 8 != 0 || offset % 8 != 0) {
            int i = 0;
            while (i < this.size) {
                this.value <<= 1;
                if (FrameUtil.getBit(buffer, offset + i) > 0) {
                    ++this.value;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size / 8) {
                this.value *= 256;
                this.value += 0xFF & buffer[offset / 8 + i];
                ++i;
            }
        }
        return offset + this.size;
    }

    public int getIntValue() {
        return this.value;
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        IntegerField intField = new IntegerField(this.getSize());
        intField.value = this.value;
        return intField;
    }
}

