/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.IntegerField;
import com.excentis.products.byteblower.frame.ProtocolField;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class Ipv6AddressField
extends ProtocolField {
    private IntegerField a = new IntegerField(8);
    private IntegerField b = new IntegerField(8);
    private IntegerField c = new IntegerField(8);
    private IntegerField d = new IntegerField(8);
    private IntegerField e = new IntegerField(8);
    private IntegerField f = new IntegerField(8);
    private IntegerField g = new IntegerField(8);
    private IntegerField h = new IntegerField(8);
    private IntegerField i = new IntegerField(8);
    private IntegerField j = new IntegerField(8);
    private IntegerField k = new IntegerField(8);
    private IntegerField l = new IntegerField(8);
    private IntegerField m = new IntegerField(8);
    private IntegerField n = new IntegerField(8);
    private IntegerField o = new IntegerField(8);
    private IntegerField p = new IntegerField(8);
    private static final int LENGTH = 16;
    private static final int COMPLETE_STRING_LENGTH = 39;
    private static final String regexp_hex_block = "[0-9A-Fa-f]{1,4}";

    Ipv6AddressField(int size) {
        super(size);
        this.a.set(0);
        this.b.set(0);
        this.c.set(0);
        this.d.set(0);
        this.e.set(0);
        this.f.set(0);
        this.g.set(0);
        this.h.set(0);
        this.i.set(0);
        this.j.set(0);
        this.k.set(0);
        this.l.set(0);
        this.m.set(0);
        this.n.set(0);
        this.o.set(0);
        this.p.set(0);
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        int initialOffset = offset;
        int used = 0;
        offset = this.a.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.b.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.c.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.d.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.e.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.f.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.g.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.h.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.i.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.j.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.k.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.l.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.m.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.n.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.o.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        offset = this.p.set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        return initialOffset + used;
    }

    private void set(int aa, int bb, int cc, int dd, int ee, int ff, int gg, int hh, int ii, int jj, int kk, int ll, int mm, int nn, int oo, int pp) {
        this.a.set(aa);
        this.b.set(bb);
        this.c.set(cc);
        this.d.set(dd);
        this.e.set(ee);
        this.f.set(ff);
        this.g.set(gg);
        this.h.set(hh);
        this.i.set(ii);
        this.j.set(jj);
        this.k.set(kk);
        this.l.set(ll);
        this.m.set(mm);
        this.n.set(nn);
        this.o.set(oo);
        this.p.set(pp);
    }

    private void set(NetworkAddressBytes ipv6AddressBytes) {
        if (ipv6AddressBytes.size() != 16) {
            throw new NumberFormatException("Invalid IPv6 address byte size : " + ipv6AddressBytes.size());
        }
        int ipv6ByteIndex = 16;
        this.p.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.o.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.n.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.m.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.l.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.k.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.j.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.i.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.h.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.g.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.f.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.e.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.d.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.c.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.b.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
        this.a.set(((Byte)ipv6AddressBytes.get(--ipv6ByteIndex)).byteValue());
    }

    void set(String s) {
        this.set(this.createBytesFromString(s));
    }

    private NetworkAddressBytes createBytesFromString(String string) throws IllegalArgumentException {
        if (this.isValid(string, true)) {
            return this.getBytes(string);
        }
        throw new IllegalArgumentException("Failed to parse IPv6 address from String.");
    }

    private final NetworkAddressBytes getBytes(String address) {
        int i;
        String addr;
        NetworkAddressBytes networkAddressBytes;
        block9: {
            networkAddressBytes = new NetworkAddressBytes();
            if (!this.isValid(address, true)) {
                return null;
            }
            address = address.replaceAll("::", ":Z:");
            String[] addresParts = address.split(":");
            int nofParts = addresParts.length;
            addr = "";
            i = 0;
            while (i < nofParts) {
                String part = addresParts[i];
                if (part.equals("Z")) {
                    part = "";
                    int j = nofParts;
                    while (j <= 8) {
                        part = String.valueOf(part) + "0000";
                        ++j;
                    }
                }
                while (part.length() < 4) {
                    part = "0" + part;
                }
                addr = String.valueOf(addr) + part;
                ++i;
            }
            if (addr.length() == 32) break block9;
            return null;
        }
        try {
            i = 0;
            while (i < 32) {
                String hexByte = addr.substring(i, i + 2);
                Byte newByte = this.toByte(hexByte);
                networkAddressBytes.add(newByte);
                i += 2;
            }
        }
        catch (Exception e) {
            System.out.println("Ipv6AddressField::getBytes : caught Exception : " + e.getMessage());
            return null;
        }
        return networkAddressBytes;
    }

    private Byte toByte(String s) {
        byte b1 = Byte.parseByte("" + s.charAt(0), 16);
        byte b2 = Byte.parseByte("" + s.charAt(1), 16);
        return (byte)((b1 & 0xF) << 4 | b2);
    }

    public static final boolean isValid(String address, boolean allowZero, boolean allowRedundantZeros) {
        int length = address.length();
        if (length == 0) {
            return false;
        }
        if (!allowRedundantZeros && length != 39) {
            return false;
        }
        if (address.indexOf(":::") != -1) {
            return false;
        }
        String zeros = "Z";
        String temp = address.replaceAll("::", ":Z:");
        int lastPos = temp.length() - 1;
        if (temp.indexOf(":") == 0 && temp.indexOf(":Z") != 0 || temp.lastIndexOf(":") == lastPos && temp.lastIndexOf("Z:") != lastPos - 1) {
            return false;
        }
        String[] hexBlocks = temp.split(":");
        int zeroFillerCount = 0;
        int valueCount = 0;
        boolean onlyZeros = true;
        int i = 0;
        while (i < hexBlocks.length) {
            String hexBlock = hexBlocks[i];
            if (hexBlock.length() != 0) {
                if (hexBlock.equals("Z")) {
                    ++zeroFillerCount;
                } else if (Pattern.matches(regexp_hex_block, hexBlock)) {
                    if (Integer.valueOf(hexBlock, 16) != 0) {
                        onlyZeros = false;
                    }
                    ++valueCount;
                } else {
                    return false;
                }
            }
            ++i;
        }
        if (onlyZeros && !allowZero) {
            return false;
        }
        if (valueCount > 8) {
            return false;
        }
        if (valueCount == 8 && zeroFillerCount != 0) {
            return false;
        }
        return valueCount >= 8 || zeroFillerCount == 1;
    }

    private final boolean isValid(String address, boolean allowZero) {
        return Ipv6AddressField.isValid(address, allowZero, true);
    }

    @Override
    public int dump(byte[] buffer, int offset) {
        offset = this.a.dump(buffer, offset);
        offset = this.b.dump(buffer, offset);
        offset = this.c.dump(buffer, offset);
        offset = this.d.dump(buffer, offset);
        offset = this.e.dump(buffer, offset);
        offset = this.f.dump(buffer, offset);
        offset = this.g.dump(buffer, offset);
        offset = this.h.dump(buffer, offset);
        offset = this.i.dump(buffer, offset);
        offset = this.j.dump(buffer, offset);
        offset = this.k.dump(buffer, offset);
        offset = this.l.dump(buffer, offset);
        offset = this.m.dump(buffer, offset);
        offset = this.n.dump(buffer, offset);
        offset = this.o.dump(buffer, offset);
        offset = this.p.dump(buffer, offset);
        return offset;
    }

    private String addZeros(String val) {
        while (val.length() < 2) {
            val = "0" + val;
        }
        return val;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.addZeros(this.a.toHexString()));
        sb.append(this.addZeros(this.b.toHexString()));
        sb.append(":");
        sb.append(this.addZeros(this.c.toHexString()));
        sb.append(this.addZeros(this.d.toHexString()));
        sb.append(":");
        sb.append(this.addZeros(this.e.toHexString()));
        sb.append(this.addZeros(this.f.toHexString()));
        sb.append(":");
        sb.append(this.addZeros(this.g.toHexString()));
        sb.append(this.addZeros(this.h.toHexString()));
        sb.append(":");
        sb.append(this.addZeros(this.i.toHexString()));
        sb.append(this.addZeros(this.j.toHexString()));
        sb.append(":");
        sb.append(this.addZeros(this.k.toHexString()));
        sb.append(this.addZeros(this.l.toHexString()));
        sb.append(":");
        sb.append(this.addZeros(this.m.toHexString()));
        sb.append(this.addZeros(this.n.toHexString()));
        sb.append(":");
        sb.append(this.addZeros(this.o.toHexString()));
        sb.append(this.addZeros(this.p.toHexString()));
        return sb.toString();
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        Ipv6AddressField ipv6 = new Ipv6AddressField(this.getSize());
        ipv6.set(this.a.value, this.b.value, this.c.value, this.d.value, this.e.value, this.f.value, this.g.value, this.h.value, this.i.value, this.j.value, this.k.value, this.l.value, this.m.value, this.n.value, this.o.value, this.p.value);
        return ipv6;
    }

    private class NetworkAddressBytes
    extends ArrayList<Byte> {
        private static final long serialVersionUID = 1L;

        private NetworkAddressBytes() {
        }
    }
}

