/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.FrameUtil;
import com.excentis.products.byteblower.frame.ProtocolField;
import java.util.BitSet;

class RawField
extends ProtocolField {
    private BitSet data;

    public RawField(int s) {
        super(s);
        this.data = new BitSet(s);
    }

    public RawField(int s, int o, byte[] buffer) {
        this(s);
        this.set(s, buffer, o);
    }

    public RawField(String s) {
        this(s.length() * 8, 0, s.getBytes());
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        int initialOffset = offset;
        int i = 0;
        while (i < bufsize / 8) {
            FrameUtil.byteToBitSet(buffer[i + offset / 8], this.data, i * 8);
            ++i;
        }
        this.size = bufsize;
        return initialOffset + this.size;
    }

    @Override
    public int dump(byte[] buffer, int offset) {
        int i = 0;
        while (i < this.size / 8) {
            buffer[offset / 8 + i] = FrameUtil.BitSettobyte(this.data, i * 8);
            ++i;
        }
        return offset + this.size;
    }

    public Object getValue() {
        return new Object();
    }

    public String toString() {
        return FrameUtil.BitSettoString(this.data, 0, this.size);
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        RawField raw = new RawField(this.getSize());
        raw.data = (BitSet)this.data.clone();
        return raw;
    }
}

