/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.FlagsField;
import com.excentis.products.byteblower.frame.FrameUtil;
import com.excentis.products.byteblower.frame.IntegerField;
import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.frame.LongField;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.RawField;
import java.util.Arrays;
import java.util.List;

public class TCPPacket
extends ProtocolLayer {
    private static final int SOURCE = 0;
    private static final int DESTINATION = 1;
    private static final int SEQUENCE = 2;
    private static final int ACK = 3;
    private static final int DATA_OFFSET = 4;
    private static final int RESERVED = 5;
    private static final int FLAGS = 6;
    private static final int WINDOW = 7;
    private static final int CHECKSUM = 8;
    private static final int URGENT = 9;
    private static final int OPTIONS = 10;
    private static final int PADDING = 11;
    private static final int PAYLOAD = 12;
    private static final String[] FIELD_NAMES = new String[]{"Source Port", "Destination Port", "Sequence", "ACK Number", "Data Offset", "Reserved", "TCP Flags", "Window", "Checksum", "Urgent", "Options", "Padding", "Payload"};

    public TCPPacket() {
        this(160);
    }

    public TCPPacket(ProtocolLayer parent) {
        this(160);
        this.setParent(parent);
    }

    private TCPPacket(int s) {
        super(s);
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(16));
        this.fields.add(new LongField(32));
        this.fields.add(new LongField(32));
        this.fields.add(new IntegerField(4));
        this.fields.add(new IntegerField(4));
        this.fields.add(new FlagsField(8, "CWR|ECE|URG|ACK|PSH|RST|SYN|FIN"));
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(0));
        this.fields.add(new RawField(0));
        this.fields.add(new RawField(s - 160));
        this.calcSize();
    }

    public TCPPacket(int s, byte[] buffer, int o) {
        this(s);
        this.set(s, buffer, o);
    }

    public void doCheckSum() {
        byte[] buffer;
        byte[] temp_ip = new byte[8192];
        byte[] temp_tcp = new byte[8192];
        int cs = 0;
        if (this.parent == null) {
            return;
        }
        this.setCheckSum(0);
        this.parent.dump(temp_ip, 0);
        if (this.parent instanceof Ipv4Packet) {
            buffer = new byte[10];
            int i = 0;
            while (i < 8) {
                buffer[i] = temp_ip[12 + i];
                ++i;
            }
            buffer[8] = 0;
            buffer[9] = temp_ip[9];
            cs = FrameUtil.calcCheckSum(buffer, 10);
            cs += this.size / 8;
        } else if (this.parent instanceof Ipv6Packet) {
            buffer = new byte[40];
            int i = 0;
            while (i < 32) {
                buffer[i] = temp_ip[8 + i];
                ++i;
            }
            buffer[32] = 0;
            buffer[33] = 0;
            buffer[34] = temp_ip[4];
            buffer[35] = temp_ip[5];
            buffer[36] = 0;
            buffer[37] = 0;
            buffer[38] = 0;
            buffer[39] = temp_ip[6];
            cs = FrameUtil.calcCheckSum(buffer, 40);
        }
        this.dump(temp_tcp, 0);
        int byteSize = this.size / 8;
        if (byteSize % 2 != 0) {
            temp_tcp[byteSize] = 0;
            ++byteSize;
        }
        cs = FrameUtil.calcCheckSum(temp_tcp, this.size / 8, cs);
        cs = FrameUtil.intFold(cs);
        cs = FrameUtil.complement(cs);
        this.setCheckSum(cs);
    }

    public void setCheckSum(int i) {
        ((IntegerField)this.fields.get(8)).set(i);
    }

    public int getCheckSum() {
        return ((IntegerField)this.fields.get(8)).getIntValue();
    }

    public void setSource(int i) {
        ((IntegerField)this.fields.get(0)).set(i);
    }

    public int getSource() {
        return ((IntegerField)this.fields.get(0)).getIntValue();
    }

    public void setDestination(int i) {
        ((IntegerField)this.fields.get(1)).set(i);
    }

    public int getDestination() {
        return ((IntegerField)this.fields.get(1)).getIntValue();
    }

    public void setSequence(long i) {
        ((LongField)this.fields.get(2)).set(i);
    }

    public long getSequence() {
        return ((LongField)this.fields.get(2)).getLongValue();
    }

    public void setACK(long i) {
        ((LongField)this.fields.get(3)).set(i);
    }

    public long getACK() {
        return ((LongField)this.fields.get(3)).getLongValue();
    }

    public void setDataOffset(int i) {
        ((IntegerField)this.fields.get(4)).set(i);
    }

    public int getDataOffset() {
        return ((IntegerField)this.fields.get(4)).getIntValue();
    }

    public void setReserved(int i) {
        ((IntegerField)this.fields.get(5)).set(i);
    }

    public int getReserved() {
        return ((IntegerField)this.fields.get(5)).getIntValue();
    }

    public void setFlags(String s) {
        ((FlagsField)this.fields.get(6)).set(s);
    }

    public String getFlags() {
        String ret = ((FlagsField)this.fields.get(6)).toString();
        return ret;
    }

    public FlagsField getFlagsField() {
        return (FlagsField)this.fields.get(6);
    }

    public void setWindow(int i) {
        ((IntegerField)this.fields.get(7)).set(i);
    }

    public int getWindow() {
        return ((IntegerField)this.fields.get(7)).getIntValue();
    }

    public void setUrgent(int i) {
        ((IntegerField)this.fields.get(9)).set(i);
    }

    public int getUrgent() {
        return ((IntegerField)this.fields.get(9)).getIntValue();
    }

    public void setOptions(int i) {
        ((IntegerField)this.fields.get(10)).set(i);
    }

    public int getOptions() {
        return ((IntegerField)this.fields.get(10)).getIntValue();
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        int initialOffset = offset;
        int used = 0;
        int i = 0;
        while (i < 11) {
            offset = ((ProtocolField)this.fields.get(i)).set(bufsize - used, buffer, offset);
            used = offset - initialOffset;
            if (offset == -1 || used > bufsize) {
                System.out.println("TCP ERROR");
                return -1;
            }
            ++i;
        }
        offset = ((ProtocolField)this.fields.get(12)).set(bufsize - used, buffer, offset);
        used = offset - initialOffset;
        if (offset == -1 || used > bufsize) {
            System.out.println("TCP ERROR");
            return -1;
        }
        this.calcSize();
        return this.size;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int i = 0;
        while (i < this.fields.size()) {
            sb.append(this.fields.get(i));
            sb.append("-");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public Object getValue() {
        System.err.println("TCPPacket::getValue missig!");
        return new Object();
    }

    public void setPayload(String s) {
        RawField pf = new RawField(s);
        this.setPayload(pf);
    }

    @Override
    public void setPayload(ProtocolField pf) {
        if (this.fields.size() == 13) {
            this.fields.set(12, pf);
        } else {
            this.fields.add(pf);
        }
        this.calcSize();
    }

    @Override
    public ProtocolField getPayload() {
        if (this.fields.size() == 13) {
            return (ProtocolField)this.fields.get(12);
        }
        return null;
    }

    @Override
    public List<String> getFieldsNames() {
        return Arrays.asList(FIELD_NAMES);
    }

    @Override
    public String getShortDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSource());
        sb.append("->");
        sb.append(this.getDestination());
        sb.append(" ");
        return sb.toString();
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        TCPPacket tcp = new TCPPacket((ProtocolLayer)parent);
        tcp.fields.clear();
        for (ProtocolField protoField : this.fields) {
            tcp.fields.add(protoField.clone(tcp));
        }
        return tcp;
    }
}

