/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.actions.file;

import com.excentis.products.byteblower.gui.actions.ByteBlowerWorkbenchAction;
import com.excentis.products.byteblower.gui.actions.advisor.ByteBlowerActionBarAdvisor;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.project.ByteBlowerMenuItemEnabler;
import com.excentis.products.byteblower.gui.widgets.project.EclipseProjectResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;

public class ByteBlowerOpenAction
extends ByteBlowerWorkbenchAction {
    private static final String ID = "com.excentis.products.byteblower.gui.actions.file.open";
    private static String openDirProperty = "byteblower.project.open.dir";

    public ByteBlowerOpenAction(IWorkbenchWindow window) {
        super(window);
    }

    public void run() {
        String fileName = this.openProjectDialog();
        if (fileName != null) {
            ByteBlowerGuiResourceController controller = ByteBlowerGuiResourceController.getInstance();
            if (controller.isOpen() && !controller.close()) {
                return;
            }
            if (controller.openProject(fileName) == null) {
                ByteBlowerActionBarAdvisor.refreshFileMenu();
            }
            ByteBlowerMenuItemEnabler.updateMenuItems();
        }
    }

    private String openProjectDialog() {
        String projectFilePath = null;
        FileDialog dialog = new FileDialog(this.window.getShell());
        String curDir = ByteBlowerPreferences.getPreferences().get(openDirProperty, null);
        if (curDir != null && curDir.length() != 0) {
            dialog.setFilterPath(curDir);
        } else {
            dialog.setFilterPath(EclipseProjectResource.getDefaultProjectLocation());
        }
        dialog.setFilterExtensions(new String[]{"*.bbp"});
        projectFilePath = dialog.open();
        if (projectFilePath != null) {
            Path openPath = new Path(projectFilePath);
            if (!openPath.toFile().exists()) {
                return null;
            }
            if ((openPath = openPath.removeLastSegments(1)).toFile().exists()) {
                ByteBlowerPreferences.getPreferences().put(openDirProperty, openPath.toOSString());
            }
        }
        return projectFilePath;
    }

    public String getText() {
        return "Open...";
    }

    public String getToolTipText() {
        return "Open Project...";
    }

    @Override
    public void updateState() {
    }

    @Override
    protected String getActionId() {
        return ID;
    }

    @Override
    protected String getImageEnabled() {
        return "menu/file/e_open.gif";
    }

    @Override
    protected String getImageDisabled() {
        return "menu/file/d_new_open_close.gif";
    }
}

