/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.actions.file;

import com.excentis.products.byteblower.gui.actions.ByteBlowerWorkbenchAction;
import com.excentis.products.byteblower.gui.actions.advisor.ByteBlowerActionBarAdvisor;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.project.ByteBlowerMenuItemEnabler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.ui.IWorkbenchWindow;

public class ByteBlowerOpenAutoSaveAction
extends ByteBlowerWorkbenchAction {
    private static final String ID = "com.excentis.products.byteblower.gui.actions.file.openautosave";

    public ByteBlowerOpenAutoSaveAction(IWorkbenchWindow window) {
        super(window);
    }

    public void run() {
        String autoSaveLoc = ByteBlowerPreferences.getAutoSaveFile();
        if (Files.exists(Paths.get(autoSaveLoc, new String[0]), new LinkOption[0])) {
            ByteBlowerGuiResourceController controller = ByteBlowerGuiResourceController.getInstance();
            if (controller.isOpen() && !controller.close()) {
                return;
            }
            if (controller.openProject(autoSaveLoc) == null) {
                ByteBlowerActionBarAdvisor.refreshFileMenu();
            }
            ByteBlowerMenuItemEnabler.updateMenuItems();
        }
    }

    public String getText() {
        return "Recover Autosave...";
    }

    public String getToolTipText() {
        return "Recover the autosave file...";
    }

    @Override
    public void updateState() {
    }

    @Override
    protected String getActionId() {
        return ID;
    }

    public boolean isEnabled() {
        String autoSaveLoc = ByteBlowerPreferences.getAutoSaveFile();
        return Files.exists(Paths.get(autoSaveLoc, new String[0]), new LinkOption[0]);
    }

    @Override
    protected String getImageEnabled() {
        return "menu/file/e_open.gif";
    }

    @Override
    protected String getImageDisabled() {
        return "menu/file/d_new_open_close.gif";
    }
}

