/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.actions.run.batch;

import com.excentis.products.byteblower.gui.actions.ShowViewMenuFactory;
import com.excentis.products.byteblower.gui.model.reader.BatchGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.refresher.RefreshConfigurationJob;
import com.excentis.products.byteblower.gui.runner.GuiRunner;
import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.reader.BatchReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.IOpenCloseListener;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RunBatch
implements IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate,
IActionDelegate2,
IOpenCloseListener {
    private static final int MAX_BATCH_COUNT = 5;
    private IAction action;

    public RunBatch() {
        ProjectSwitchNotifier.getInstance().addOpenCloseListener((IOpenCloseListener)this);
        this.updateState();
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        int recentsAvailable = 0;
        if (ByteBlowerGuiResourceController.getInstance().isOpen()) {
            for (Batch batch : GuiRunner.getInstance().getRecentBatchList()) {
                MenuItem item = new MenuItem(menu, 0);
                BatchGuiReader reader = GuiReaderFactory.create((Batch)batch);
                Image object = reader.getImage();
                if (object instanceof Image) {
                    item.setImage(object);
                }
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Batch recentBatch;
                        BatchReader batchReader;
                        MenuItem menuItem;
                        Object itemData;
                        if (e.widget instanceof MenuItem && (itemData = (menuItem = (MenuItem)e.widget).getData()) instanceof Batch && !(batchReader = ReaderFactory.create((Batch)(recentBatch = (Batch)itemData))).hasErrorStatus()) {
                            GuiRunner.getInstance().scheduleBatch(recentBatch);
                        }
                    }
                });
                item.setText(batch.getName());
                item.setData((Object)batch);
                if (++recentsAvailable >= 5) break;
            }
        }
        if (recentsAvailable > 0) {
            new MenuItem(menu, 2);
        }
        ShowViewMenuFactory.showView(menu, "Batch...", "com.excentis.products.byteblower.gui.views.batch.BatchView");
        return menu;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IAction action) {
        this.action = action;
        action.setEnabled(false);
        GuiRunner.getInstance().addListener(new GuiRunner.ActiveJobListener(){

            public void activeScenarioJobChanged() {
                RunBatch.this.updateState();
            }

            public void activeScenarioPaused(GuiRunner.Resumer resume) {
            }

            public void activeScenarioResumed() {
            }
        });
    }

    public void runWithEvent(IAction action, Event event) {
        String errorMessage;
        Batch batchToRun = GuiRunner.getInstance().getMostRecentBatch();
        boolean foundBatch = batchToRun != null;
        boolean canPickValid = false;
        if (foundBatch) {
            BatchReader reader = ReaderFactory.create((Batch)batchToRun);
            canPickValid = !reader.hasErrorStatus();
            errorMessage = String.valueOf(batchToRun.getName()) + " : The last launched Batch is invalid.";
            errorMessage = String.valueOf(errorMessage) + "\nPlease look in the Solution tab for hints to get this fixed.";
        } else if (this.isSingleBatch()) {
            foundBatch = true;
            Collection<Batch> batches = this.getBatches();
            batchToRun = batches.iterator().next();
            BatchReader reader = ReaderFactory.create((Batch)batchToRun);
            canPickValid = !reader.hasErrorStatus();
            errorMessage = "No valid batch";
            errorMessage = String.valueOf(errorMessage) + "\nPlease look in the Solution tab for hints to get this fixed.";
        } else {
            errorMessage = "Can't pick a batch";
        }
        if (foundBatch && canPickValid) {
            GuiRunner.getInstance().scheduleBatch(batchToRun);
        } else {
            if (foundBatch) {
                MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                mb.setMessage(errorMessage);
                mb.open();
            }
            IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                win.getActivePage().showView("com.excentis.products.byteblower.gui.views.SolutionView");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private Collection<Batch> getBatches() {
        ByteBlowerProject project = ProjectSwitchNotifier.getInstance().getCurrentProject();
        if (project == null) {
            return Collections.emptyList();
        }
        return project.getBatch();
    }

    private boolean isValidSingleBatch() {
        Collection<Batch> toPickFrom = this.getBatches();
        if (1 == toPickFrom.size()) {
            Batch first = toPickFrom.iterator().next();
            BatchReader reader = ReaderFactory.create((Batch)first);
            return !reader.hasErrorStatus();
        }
        return false;
    }

    private boolean isSingleBatch() {
        return 1 == this.getBatches().size();
    }

    public void updateState() {
        if (this.action == null) {
            return;
        }
        Batch mostRecentBatch = GuiRunner.getInstance().getMostRecentBatch();
        boolean mostRecentAvailable = mostRecentBatch != null;
        boolean enable = ByteBlowerGuiResourceController.getInstance().isOpen() && (mostRecentAvailable || this.isValidSingleBatch()) && !GuiRunner.getInstance().isRunning() && !RefreshConfigurationJob.isRunning();
        this.action.setEnabled(enable);
    }

    public void projectOpenedOrClosed(ByteBlowerProject project) {
        this.updateState();
        if (project == null) {
            return;
        }
        EContentAdapter g = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                RunBatch.this.updateState();
            }
        };
        project.eAdapters().add((Object)g);
    }
}

