/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.configuration.actions.dnd;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.transfer.ByteBlowerTransfer;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortConfigurationController;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;

class PortConfigTableDropAdapter
extends ViewerDropAdapter
implements IAfterOperationListener {
    private static boolean draggingFromTree = false;

    public PortConfigTableDropAdapter(StructuredViewer viewer) {
        super((Viewer)viewer);
    }

    public boolean performDrop(Object data) {
        StructuredSelection dropData = (StructuredSelection)data;
        if (draggingFromTree) {
            BasicEList commands = new BasicEList();
            for (Object object : dropData) {
                if (!(object instanceof ByteBlowerGuiPortConfiguration)) continue;
                ByteBlowerGuiPortConfigurationController byteblowerGuiPortConfigurationController = new ByteBlowerGuiPortConfigurationController((ByteBlowerGuiPortConfiguration)object);
                commands.add((Object)byteblowerGuiPortConfigurationController.undock());
            }
            boolean multiplePorts = commands.size() > 1;
            UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), multiplePorts ? "Undock Ports" : "Undock Port", (Collection)commands);
            operation.addAfterOperationListener((IAfterOperationListener)this);
            operation.run();
        }
        return true;
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        boolean valid = draggingFromTree && ByteBlowerTransfer.getInstance(ByteBlowerGuiPort.class).isSupportedType(type);
        return valid;
    }

    protected static void startDraggingFromTree() {
        draggingFromTree = true;
    }

    protected static void stopDraggingFromTree() {
        draggingFromTree = false;
    }

    public void afterOperation(UndoableByteBlowerOperation operation) {
        Viewer viewer = this.getViewer();
        if (!viewer.getControl().isDisposed()) {
            viewer.refresh();
        }
    }
}

