/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.configuration.dialogs;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerComposite;
import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.swt.composites.server.ServerComposite;
import com.excentis.products.byteblower.gui.swt.dialogs.ByteBlowerFocusDispatcherDialog;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PhysicalConfigurationDialog
extends ByteBlowerFocusDispatcherDialog
implements ISelectionChangedListener {
    private String titleText;
    private Image dlgTitleImage = null;
    private Button btnOk;
    private ServerComposite serverComposite;
    private PhysicalDockable dockable = null;

    public PhysicalConfigurationDialog(Shell parentShell, boolean isSource) {
        super(parentShell);
        this.titleText = "Select the location where the " + (isSource ? "Source" : "Destination") + " ByteBlower Port will be docked";
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Physical Configuration");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.titleText);
        ImageDescriptor imagedescr = ImageDescriptor.createFromFile(ImageCache.class, (String)"dialogs/SelectPorts.gif");
        this.dlgTitleImage = imagedescr.createImage();
        this.setTitleImage(this.dlgTitleImage);
        this.updateWidgets();
        return contents;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.serverComposite = new ServerComposite(parentComposite, (IByteBlowerAction)this);
        this.serverComposite.addSelectionListener((ISelectionChangedListener)this);
        this.serverComposite.setLayoutData((Object)new GridData(1808));
        this.setCurrentFocusWidget((IByteBlowerComposite)this.serverComposite);
        return parentComposite;
    }

    protected void okPressed() {
        this.dockable = this.getSelectedDockable();
        this.close();
    }

    private void updateWidgets() {
        String errorMessage = null;
        boolean enableOk = true;
        if (this.getSelectedDockable() == null) {
            enableOk = false;
        }
        this.btnOk.setEnabled(enableOk);
        this.setErrorMessage(errorMessage);
    }

    private PhysicalDockable getSelectedDockable() {
        EList selectedDockables = this.serverComposite.getSelectedDockables();
        this.dockable = selectedDockables.size() != 1 ? null : (PhysicalDockable)selectedDockables.get(0);
        return this.dockable;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateWidgets();
    }

    public PhysicalDockable getDockable() {
        return this.dockable;
    }
}

