/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.history.operations.copydown;

import com.excentis.products.byteblower.gui.history.operations.copydown.ICopyDownOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.TimeTextFactory;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IncrementTimeDialog
extends TitleAreaDialog
implements ModifyListener {
    private Button okButton;
    private Text txtIncrement;
    private HighResolutionCalendar incrTime;
    private static final int TYPE_START_UNKNOWN = 0;
    public static final int TYPE_START_TIME = 1;
    private static final int TYPE_INITIALIZATION_TIME = 2;
    public static final int TYPE_DURATION = 3;
    private int type = 0;
    private ICopyDownOperation.ECopyDownMode mode;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$gui$history$operations$copydown$ICopyDownOperation$ECopyDownMode = IncrementTimeDialog.$SWITCH_TABLE$com$excentis$products$byteblower$gui$history$operations$copydown$ICopyDownOperation$ECopyDownMode();
    }

    public IncrementTimeDialog(Shell parentShell, ICopyDownOperation.ECopyDownMode mode, int type) {
        super(parentShell);
        this.mode = mode;
        this.type = type;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        switch (this.type) {
            case 1: {
                shell.setText("Start Time");
                break;
            }
            case 2: {
                shell.setText("Initialization Time");
                break;
            }
            case 3: {
                shell.setText("Duration");
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        switch (this.mode) {
            case decrement: {
                this.setTitle("Copy Down Decrementing");
                break;
            }
            case increment: {
                this.setTitle("Copy Down Incrementing");
                break;
            }
        }
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        String labelText = "";
        switch (this.mode) {
            case decrement: {
                labelText = "Decrement ";
                break;
            }
            case increment: {
                labelText = "Increment ";
                break;
            }
            case normal: {
                break;
            }
        }
        switch (this.type) {
            case 1: {
                labelText = String.valueOf(labelText) + "Start Time with:";
                break;
            }
            case 2: {
                labelText = String.valueOf(labelText) + "Initialization Time with:";
                break;
            }
            case 3: {
                labelText = String.valueOf(labelText) + "Duration with:";
            }
        }
        Label label = new Label(composite, 0);
        label.setText(labelText);
        this.incrTime = new HighResolutionCalendar(Long.valueOf(1000000000L));
        this.txtIncrement = TimeTextFactory.instance().create(composite, 2048);
        this.txtIncrement.addModifyListener((ModifyListener)this);
        int caretPos = this.txtIncrement.getCaretPosition();
        this.txtIncrement.setText(HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)this.incrTime, (boolean)true, (boolean)true));
        this.txtIncrement.setSelection(caretPos, caretPos);
        this.txtIncrement.setLayoutData((Object)new GridData(768));
        this.txtIncrement.setFocus();
        this.txtIncrement.selectAll();
        return parentComposite;
    }

    private void setDialogComplete(boolean value) {
        if (this.okButton != null) {
            this.okButton.setEnabled(value);
        }
    }

    private boolean validateDialog() {
        String duration = this.txtIncrement.getText();
        return duration.length() != 0;
    }

    public void modifyText(ModifyEvent e) {
        String duration;
        Control control = (Control)e.widget;
        if (!control.isFocusControl()) {
            return;
        }
        if (control == this.txtIncrement && (duration = this.txtIncrement.getText()).length() != 0 && !HighResolutionCalendarParser.setRelativeTime((String)duration, (HighResolutionCalendar)this.incrTime)) {
            this.incrTime.setTimeInNanoseconds(0L);
        }
        this.setDialogComplete(this.validateDialog());
    }

    public HighResolutionCalendar getIncrementTime() {
        return this.incrTime;
    }
}

