/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.history.operations.copydown;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TimeTextFactory {
    private static TimeTextFactory instance = null;

    public static TimeTextFactory instance() {
        if (instance == null) {
            instance = new TimeTextFactory();
        }
        instance = new TimeTextFactory();
        return instance;
    }

    public Text create(Composite parent, int style) {
        return this.createTimeText(parent, style, null);
    }

    public Text create(Composite parent, int style, HighResolutionCalendar maxNanoseconds) {
        return this.createTimeText(parent, style, maxNanoseconds);
    }

    private Text createTimeText(Composite parent, int style, HighResolutionCalendar maxTime) {
        Text newItem = new Text(parent, style);
        newItem.addVerifyListener((VerifyListener)new VerifyTime(newItem, maxTime));
        ExpandTime expander = new ExpandTime(newItem);
        newItem.addFocusListener((FocusListener)expander);
        newItem.addMouseMoveListener((MouseMoveListener)expander);
        return newItem;
    }

    private static class ExpandTime
    implements FocusListener,
    MouseMoveListener {
        private final Text sourceWidget;
        private Point mouseLocation;

        public ExpandTime(Text item) {
            this.sourceWidget = item;
            this.mouseLocation = new Point(0, 0);
        }

        public void focusLost(FocusEvent e) {
            HighResolutionCalendar currentTime = new HighResolutionCalendar();
            boolean valid = HighResolutionCalendarParser.setRelativeTime((String)this.sourceWidget.getText(), (HighResolutionCalendar)currentTime);
            if (valid) {
                String expanded = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)currentTime, (boolean)false, (boolean)true);
                this.sourceWidget.setText(expanded);
            }
        }

        public void focusGained(FocusEvent e) {
            HighResolutionCalendar currentTime = new HighResolutionCalendar();
            String origText = this.sourceWidget.getText();
            boolean valid = HighResolutionCalendarParser.setRelativeTime((String)origText, (HighResolutionCalendar)currentTime);
            if (valid) {
                String contracted = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)currentTime, (boolean)true, (boolean)true);
                this.sourceWidget.setText(contracted);
                int txtShift = contracted.indexOf(origText);
                GC gc = new GC((Drawable)this.sourceWidget);
                int ctr = 0;
                ctr = 0;
                while (ctr < origText.length() && txtShift >= 0) {
                    String startTxt = origText.substring(0, ctr);
                    Point extend = gc.stringExtent(startTxt);
                    if (extend.x >= this.mouseLocation.x) break;
                    ++ctr;
                }
                gc.dispose();
                final int loc = txtShift + ctr;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!sourceWidget.isDisposed()) {
                            sourceWidget.setSelection(loc, loc);
                        }
                    }
                });
            }
        }

        public void mouseMove(MouseEvent e) {
            this.mouseLocation = new Point(e.x, e.y);
        }
    }

    private static class VerifyTime
    implements VerifyListener {
        private final Color ERRORCOLOR = ExcentisColors.red;
        private Text sourceWidget;
        private HighResolutionCalendar maxTime;

        public VerifyTime(Text item, HighResolutionCalendar maxTime) {
            this.sourceWidget = item;
            this.maxTime = maxTime == null ? new HighResolutionCalendar(Long.valueOf(Long.MAX_VALUE)) : maxTime.clone();
        }

        public void verifyText(VerifyEvent e) {
            boolean valid;
            HighResolutionCalendar currentTime;
            String previous = this.sourceWidget.getText();
            String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
            HighResolutionCalendarParser.PARSE_RESULT parseFeedback = HighResolutionCalendarParser.parseToRelativeTime((String)result, (HighResolutionCalendar)(currentTime = new HighResolutionCalendar()));
            e.doit = HighResolutionCalendarParser.PARSE_RESULT.SUCCESS == parseFeedback || HighResolutionCalendarParser.PARSE_RESULT.INCOMPLETE_UNIT == parseFeedback || HighResolutionCalendarParser.PARSE_RESULT.OUT_ORDER == parseFeedback || HighResolutionCalendarParser.PARSE_RESULT.BELOW_RESOLUTION == parseFeedback || HighResolutionCalendarParser.PARSE_RESULT.NO_VAL_FOR_UNIT == parseFeedback;
            boolean bl = valid = HighResolutionCalendarParser.PARSE_RESULT.SUCCESS == parseFeedback;
            if (valid && (this.maxTime == null || !currentTime.after((Object)this.maxTime))) {
                this.sourceWidget.setForeground(null);
            } else {
                this.sourceWidget.setForeground(this.ERRORCOLOR);
            }
        }
    }
}

