/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.history.operations.status;

import com.excentis.products.byteblower.gui.history.operations.status.UndoableByteBlowerStatusOperation;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerStatusWrapper;
import com.excentis.products.byteblower.status.model.ByteBlowerStatus;
import com.excentis.products.byteblower.status.model.ByteBlowerStatusModelFactory;
import com.excentis.products.byteblower.status.model.StatusRoot;
import com.excentis.products.byteblower.status.model.controller.StatusRootController;
import com.excentis.products.byteblower.status.model.reader.ByteBlowerStatusReader;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ByteBlowerStatusContainer {
    private StatusRootController controller;
    private static ByteBlowerStatusContainer instance;

    public ByteBlowerStatusContainer() {
        StatusRoot statusRoot = ByteBlowerStatusModelFactory.eINSTANCE.createStatusRoot();
        this.controller = new StatusRootController(statusRoot);
    }

    public static ByteBlowerStatusContainer getInstance() {
        if (instance == null) {
            instance = new ByteBlowerStatusContainer();
        }
        return instance;
    }

    public synchronized EList<ByteBlowerStatus> getStatuses() {
        return this.controller.getStatuses();
    }

    private StatusRoot getStatusRoot() {
        return this.controller.getStatusRoot();
    }

    public synchronized void addStatus(ByteBlowerStatusWrapper wrapper) {
        ByteBlowerStatus status = wrapper.getStatus();
        Command command = this.controller.createAddStatusCommand(status);
        UndoableByteBlowerStatusOperation operation = this.createOperation("ADDING STATUS OPERATION", command);
        operation.runWithoutHistory();
    }

    public synchronized void removeStatus(ByteBlowerStatusWrapper wrapper) {
        ByteBlowerStatus status = wrapper.getStatus();
        Command command = this.controller.createDeleteStatusCommand(status);
        UndoableByteBlowerStatusOperation operation = this.createOperation("DELETING STATUS OPERATION", command);
        operation.runWithoutHistory();
    }

    private void erase(EList<ByteBlowerStatus> statuses) {
        Command command = this.controller.createDeleteStatusesCommand(statuses);
        UndoableByteBlowerStatusOperation operation = this.createOperation("ERASING STATUSES OPERATION", command);
        operation.runWithoutHistory();
    }

    private UndoableByteBlowerStatusOperation createOperation(String string, Command command) {
        return new UndoableByteBlowerStatusOperation(string, command);
    }

    synchronized void clear() {
        ByteBlowerStatusContainer container = ByteBlowerStatusContainer.getInstance();
        container.erase(container.getStatuses());
    }

    public synchronized boolean isEmpty() {
        return this.getStatuses().isEmpty();
    }

    public void addAdapter(Adapter adapter) {
        this.getStatusRoot().eAdapters().add((Object)adapter);
    }

    public synchronized EList<EObject> getAllItems() {
        return this.controller.getAllItems();
    }

    public synchronized String getOverviewString(boolean rootCausesOnly) {
        int nofErrors = 0;
        int nofWarnings = 0;
        for (ByteBlowerStatus status : this.getStatuses()) {
            ByteBlowerStatusReader reader;
            if (rootCausesOnly && !(reader = ReaderFactory.create((ByteBlowerStatus)status)).isRootCause()) continue;
            if (status.getSeverity() == 4) {
                ++nofErrors;
                continue;
            }
            if (status.getSeverity() != 2) continue;
            ++nofWarnings;
        }
        return String.valueOf(nofErrors) + (nofErrors == 1 ? " error" : " errors") + ", " + nofWarnings + (nofWarnings == 1 ? " warning" : " warnings");
    }
}

