/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.images;

import com.excentis.products.byteblower.gui.images.ImageCache;
import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayIcon
extends CompositeImageDescriptor {
    private Image base;
    private ImageDescriptor descriptorBase;
    private Image[] overlays;
    private Point size;
    private int[] locations;
    public static final int TOP_LEFT = 0;
    private static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;

    public OverlayIcon(Image base, Image[] overlays, int[] locations, Point size) {
        this.base = base;
        this.descriptorBase = null;
        this.overlays = overlays;
        this.locations = locations;
        this.size = size;
    }

    public Image createImage() {
        String id = this.getId();
        Image image = ImageCache.getImage(id);
        if (image == null) {
            image = super.createImage();
            ImageCache.save(id, image);
        }
        return image;
    }

    private String getId() {
        String id = this.base.toString();
        int i = 0;
        while (i < this.overlays.length) {
            Image overlay = this.overlays[i];
            id = String.valueOf(id) + overlay.toString();
            ++i;
        }
        return id;
    }

    private void drawOverlays(Image[] overlays, int[] locations) {
        Point size = this.getSize();
        int i = 0;
        while (i < overlays.length) {
            Image overlay = overlays[i];
            ImageData overlayData = overlay.getImageData();
            switch (locations[i]) {
                case 0: {
                    this.drawImage(overlayData, 0, 0);
                    break;
                }
                case 1: {
                    this.drawImage(overlayData, size.x - overlayData.width, 0);
                    break;
                }
                case 2: {
                    this.drawImage(overlayData, 0, size.y - overlayData.height);
                    break;
                }
                case 3: {
                    this.drawImage(overlayData, size.x - overlayData.width, size.y - overlayData.height);
                }
            }
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof OverlayIcon)) {
            return false;
        }
        OverlayIcon other = (OverlayIcon)((Object)o);
        return this.base.equals((Object)other.base) && Arrays.equals(this.overlays, other.overlays);
    }

    public int hashCode() {
        int code = this.base.hashCode();
        int i = 0;
        while (i < this.overlays.length) {
            code ^= this.overlays[i].hashCode();
            ++i;
        }
        return code;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg;
        if (this.descriptorBase != null) {
            if (this.descriptorBase == null || (bg = this.descriptorBase.getImageData()) == null) {
                bg = DEFAULT_IMAGE_DATA;
            }
        } else {
            bg = this.base.getImageData();
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays(this.overlays, this.locations);
    }

    protected Point getSize() {
        return this.size;
    }
}

