/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.gui.jface.viewers.IpAddressValidator;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.IpAddressController;
import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class IpAddressCellEditor
extends TextCellEditor {
    public IpAddressCellEditor(Composite parent) {
        super(parent);
        this.setValidator(new IpAddressValidator());
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text t = (Text)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                e.doit = IpAddressController.isValidPartialInput((String)result);
            }
        });
    }

    protected void editOccured(ModifyEvent e) {
        super.editOccured(e);
        String valueString = (String)super.doGetValue();
        if (IpAddressController.isValid((String)valueString)) {
            this.text.setForeground(null);
        } else {
            this.text.setForeground(ByteBlowerColor.red);
        }
    }

    public Object doGetValue() {
        Object value = super.doGetValue();
        if (value instanceof String) {
            try {
                return IpAddressController.createBytesFromString((String)((String)value));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public void doSetValue(Object value) {
        IpAddressController ipAddressController;
        String result = value instanceof IpAddress ? ((ipAddressController = ControllerFactory.create((IpAddress)((IpAddress)value))) != null ? ipAddressController.getAddress() : "") : "";
        super.doSetValue((Object)result);
    }
}

