/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.gui.jface.viewers.Ipv4AddressValidator;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class Ipv4AddressCellEditor
extends TextCellEditor {
    public Ipv4AddressCellEditor(Composite parent) {
        super(parent);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text t = (Text)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                e.doit = Ipv4AddressController.isValidPartialInput((String)result);
            }
        });
        this.setValidator(new Ipv4AddressValidator());
    }

    protected void editOccured(ModifyEvent e) {
        super.editOccured(e);
        if (this.isValueValid()) {
            this.text.setForeground(null);
        } else {
            this.text.setForeground(ByteBlowerColor.red);
        }
    }

    public Object doGetValue() {
        Object value = super.doGetValue();
        if (value instanceof String) {
            try {
                return Ipv4AddressController.createBytesFromString((String)((String)value));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public void doSetValue(Object value) {
        String result;
        if (value instanceof Ipv4Address) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create((Ipv4Address)((Ipv4Address)value));
            result = ipv4AddressController.getAddress();
        } else {
            result = "";
        }
        super.doSetValue((Object)result);
    }
}

