/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.gui.jface.viewers.Ipv6AddressValidator;
import com.excentis.products.byteblower.model.Ipv6Address;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.Ipv6AddressController;
import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class Ipv6AddressCellEditor
extends TextCellEditor {
    public Ipv6AddressCellEditor(Composite parent) {
        super(parent);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text t = (Text)e.widget;
                String previous = t.getText();
                e.text = e.text.replaceAll("\\.", ":");
                e.text = e.text.replaceAll("-", ":");
                e.text = e.text.replaceAll(";", ":");
                e.text = e.text.replaceAll("_", ":");
                e.text = e.text.replaceAll(" ", ":");
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                e.doit = Ipv6AddressController.isValidPartialInput((String)result);
            }
        });
        this.setValidator(new Ipv6AddressValidator());
    }

    protected void editOccured(ModifyEvent e) {
        super.editOccured(e);
        if (this.isValueValid()) {
            this.text.setForeground(null);
        } else {
            this.text.setForeground(ByteBlowerColor.red);
        }
    }

    public Object doGetValue() {
        Object value = super.doGetValue();
        if (value instanceof String) {
            try {
                return Ipv6AddressController.createBytesFromString((String)((String)value));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public void doSetValue(Object value) {
        String result;
        if (value instanceof Ipv6Address) {
            Ipv6AddressController ipv6AddressController = ControllerFactory.create((Ipv6Address)((Ipv6Address)value));
            result = ipv6AddressController.getAddress();
        } else {
            result = "";
        }
        super.doSetValue((Object)result);
    }
}

