/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.gui.jface.viewers.SpinnerValidator;
import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerCellEditor
extends CellEditor {
    private Spinner spinner;
    private int min;
    private int max;

    public SpinnerCellEditor(Composite parent, int min, int max) {
        super(parent, 0);
        this.min = min;
        this.max = max;
        this.spinner.setMinimum(min);
        this.spinner.setMaximum(max);
        int textLimit = Integer.toString(max).length();
        this.spinner.setTextLimit(textLimit);
        this.setValidator(new SpinnerValidator(min, max));
    }

    protected Control createControl(Composite parent) {
        this.spinner = new Spinner(parent, 1024);
        this.spinner.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    SpinnerCellEditor.this.fireCancelEditor();
                } else if (e.character == '\r') {
                    SpinnerCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        this.spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    int current = Integer.parseInt(SpinnerCellEditor.this.spinner.getText());
                    SpinnerCellEditor.this.spinner.setForeground((Color)(current < SpinnerCellEditor.this.min || current > SpinnerCellEditor.this.max ? ByteBlowerColor.red : null));
                    SpinnerCellEditor.this.markDirty();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        this.spinner.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                SpinnerCellEditor.this.fireApplyEditorValue();
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        return this.spinner;
    }

    protected void doSetFocus() {
        this.spinner.setFocus();
    }

    protected Object doGetValue() {
        int intValue = this.spinner.getSelection();
        return intValue;
    }

    protected void doSetValue(Object value) {
        Integer intValue = (Integer)value;
        this.spinner.setSelection(intValue.intValue());
    }
}

