/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.model.reader.impl;

import com.excentis.products.byteblower.gui.images.OverlayIcon;
import com.excentis.products.byteblower.gui.model.reader.BatchActionGuiReader;
import com.excentis.products.byteblower.gui.model.reader.ScenarioGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.gui.model.reader.factory.IconCache;
import com.excentis.products.byteblower.model.BatchAction;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.TimedStartType;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.impl.BatchActionReaderImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public final class BatchActionGuiReaderImpl
extends BatchActionReaderImpl
implements BatchActionGuiReader {
    private static final String STARTTYPE_UNKNOWN = "?";
    private static final String STARTTIME_UNKNOWN = "?";

    public BatchActionGuiReaderImpl(BatchAction batchAction) {
        super(batchAction);
    }

    @Override
    public Image getImage() {
        BatchAction action = (BatchAction)this.getObject();
        Image baseImage = IconCache.getImage("full/obj16/BatchAction");
        if (baseImage == null) {
            return null;
        }
        Image overlayImage = null;
        Scenario scenario = action.getScenario();
        if (scenario != null) {
            if (this.hasErrorStatus()) {
                overlayImage = IconCache.getImage("full/obj16/notok_ovr");
            } else if (this.hasWarningStatus()) {
                baseImage = IconCache.getImage("full/obj16/BatchAction_gray");
                overlayImage = IconCache.getImage("full/obj16/question_ovr");
            } else {
                overlayImage = null;
            }
        } else {
            overlayImage = IconCache.getImage("full/obj16/notok_ovr");
        }
        int arraySize = overlayImage != null ? 1 : 0;
        Image[] overlays = new Image[arraySize];
        int[] locations = new int[arraySize];
        if (overlayImage != null) {
            overlays[0] = overlayImage;
            locations[0] = 3;
        }
        OverlayIcon result = new OverlayIcon(baseImage, overlays, locations, new Point(26, 16));
        return result.createImage();
    }

    @Override
    public ScenarioGuiReader getScenarioGuiReader() {
        Scenario scenario = this.getScenario();
        return GuiReaderFactory.create(scenario);
    }

    @Override
    public String getStartTimeString() {
        TimedStartType startType = this.getStartType();
        int type = startType.getValue();
        switch (type) {
            case 0: {
                return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)this.getStartTime(), (boolean)false, (boolean)true);
            }
        }
        return "?";
    }

    @Override
    public String getScenarioString() {
        Scenario scenario = this.getScenario();
        if (scenario == null) {
            return "click to specify";
        }
        return scenario.getName();
    }

    @Override
    public String getDurationString() {
        HighResolutionDuration duration = this.getDuration();
        if (duration != null) {
            return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)duration);
        }
        return "-";
    }

    public HighResolutionDuration getDuration() {
        ScenarioReader scenarioReader = this.getScenarioReader();
        return scenarioReader.getDuration();
    }
}

