/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.model.reader.impl;

import com.excentis.products.byteblower.gui.images.OverlayIcon;
import com.excentis.products.byteblower.gui.model.reader.ByteBlowerGuiPortGuiReader;
import com.excentis.products.byteblower.gui.model.reader.DhcpGuiReader;
import com.excentis.products.byteblower.gui.model.reader.PortForwardingGuiReader;
import com.excentis.products.byteblower.gui.model.reader.VlanStackGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.gui.model.reader.factory.IconCache;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.PortForwarding;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerGuiPortReaderImpl;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public final class ByteBlowerGuiPortGuiReaderImpl
extends ByteBlowerGuiPortReaderImpl
implements ByteBlowerGuiPortGuiReader {
    public ByteBlowerGuiPortGuiReaderImpl(ByteBlowerGuiPort object) {
        super(object);
    }

    @Override
    public DhcpGuiReader getDhcpGuiReader() {
        Dhcp dhcp = this.getDhcpv4();
        return GuiReaderFactory.create(dhcp);
    }

    @Override
    public VlanStackGuiReader getVlanStackGuiReader() {
        VlanStack vlanStack = this.getVlanStack();
        return GuiReaderFactory.create(vlanStack);
    }

    @Override
    public PortForwardingGuiReader getPortForwardingGuiReader() {
        PortForwarding portForwarding = this.getPortForwarding();
        return GuiReaderFactory.create(portForwarding);
    }

    @Override
    public Image getImage() {
        Image baseImage = IconCache.getImage("/full/obj16/ByteBlowerPort");
        Image ipOverlayImage = null;
        ipOverlayImage = this.hasActiveIpv4Configuration() ? IconCache.getImage("full/obj16/v4") : (this.hasActiveIpv6Configuration() ? IconCache.getImage("full/obj16/v6") : IconCache.getImage("full/obj16/question_ovr"));
        Image overlayImage = null;
        if (this.hasErrorStatus()) {
            overlayImage = IconCache.getImage("full/obj16/notok_ovr");
        } else if (this.hasWarningStatus()) {
            overlayImage = IconCache.getImage("full/obj16/skipped_ovr");
        }
        int arraySize = overlayImage != null ? 2 : 1;
        Image[] overlays = new Image[arraySize];
        int[] locations = new int[arraySize];
        overlays[0] = ipOverlayImage;
        locations[0] = 0;
        if (overlayImage != null) {
            overlays[1] = overlayImage;
            locations[1] = 3;
        }
        OverlayIcon result = new OverlayIcon(baseImage, overlays, locations, new Point(26, 16));
        return result.createImage();
    }

    @Override
    public Object getNatImage() {
        Image baseImage = null;
        if (this.usesPortForwarding()) {
            return this.getPortForwardingGuiReader().getImage();
        }
        if (this.isNatted()) {
            baseImage = IconCache.getImage("/full/obj16/Nat");
            return baseImage;
        }
        return null;
    }

    @Override
    public Object getDhcpImage() {
        if (this.usesDHCP() && !this.isDockedOnMobileDevice()) {
            return this.getDhcpGuiReader().getImage();
        }
        return null;
    }

    @Override
    public Object getVlanStackImage() {
        if (this.usesVlanStack() && !this.isDockedOnMobileDevice()) {
            return this.getVlanStackGuiReader().getImage();
        }
        return null;
    }
}

