/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.model.reader.impl;

import com.excentis.products.byteblower.gui.images.OverlayIcon;
import com.excentis.products.byteblower.gui.model.reader.AddressableDestinationGuiReader;
import com.excentis.products.byteblower.gui.model.reader.AddressableSourceGuiReader;
import com.excentis.products.byteblower.gui.model.reader.FlowGuiReader;
import com.excentis.products.byteblower.gui.model.reader.FlowTemplateGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.gui.model.reader.factory.IconCache;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.AddressableSource;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.LatencyAndJitterType;
import com.excentis.products.byteblower.model.OutOfSequenceType;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.reader.FlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerGuiPortReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.FlowReaderImpl;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public final class FlowGuiReaderImpl
extends FlowReaderImpl
implements FlowGuiReader {
    public FlowGuiReaderImpl(Flow object) {
        super(object);
    }

    @Override
    public Image getImage() {
        ByteBlowerGuiPort sourcePort;
        Flow flow = (Flow)this.getObject();
        if (flow == null) {
            return null;
        }
        FlowReader reader = ReaderFactory.create((Flow)flow);
        Image baseImage = IconCache.getImage("full/obj16/Flow");
        Image ipOverlayImage = null;
        if (flow.getSource() instanceof ByteBlowerGuiPort && (sourcePort = (ByteBlowerGuiPort)flow.getSource()) != null) {
            ByteBlowerGuiPortReaderImpl portReader = new ByteBlowerGuiPortReaderImpl(sourcePort);
            ipOverlayImage = portReader.isActiveLayer3Configuration(SupportedLayer3Configuration.IPV6) ? IconCache.getImage("full/obj16/v6") : (portReader.isActiveLayer3Configuration(SupportedLayer3Configuration.IPV4) ? IconCache.getImage("full/obj16/v4") : IconCache.getImage("full/obj16/question_ovr"));
        }
        Image overlayImage = null;
        if (reader.hasErrorStatus()) {
            overlayImage = IconCache.getImage("full/obj16/notok_ovr");
        }
        int arraySize = 0;
        if (overlayImage != null) {
            ++arraySize;
        }
        if (ipOverlayImage != null) {
            ++arraySize;
        }
        Image[] overlays = new Image[arraySize];
        int[] locations = new int[arraySize];
        int index = 0;
        if (overlayImage != null) {
            overlays[index] = overlayImage;
            locations[index] = 3;
            ++index;
        }
        if (ipOverlayImage != null) {
            overlays[index] = ipOverlayImage;
            locations[index] = 0;
            ++index;
        }
        OverlayIcon result = new OverlayIcon(baseImage, overlays, locations, new Point(26, 16));
        return result.createImage();
    }

    @Override
    public FlowTemplateGuiReader<?> getFlowTemplateGuiReader() {
        FlowTemplate flowTemplate = this.getFlowTemplate();
        return GuiReaderFactory.create(flowTemplate);
    }

    @Override
    public AddressableSourceGuiReader<?> getAddressableSourceGuiReader() {
        AddressableSource source = this.getAddressableSource();
        return GuiReaderFactory.create(source);
    }

    @Override
    public AddressableDestinationGuiReader<?> getAddressableDestinationGuiReader() {
        AddressableDestination destination = this.getAddressableDestination();
        return GuiReaderFactory.create(destination);
    }

    @Override
    public String getTosString() {
        return super.getTosString(" -> Set in Frame");
    }

    @Override
    public String getLatencyString() {
        if (this.flowSupportsLatencyAndOos()) {
            LatencyAndJitterType latencyAndJitterType = this.getLatencyAndJitterType();
            return latencyAndJitterType == null ? "click to specify" : latencyAndJitterType.getLiteral();
        }
        return "-";
    }

    private LatencyAndJitterType getLatencyAndJitterType() {
        return ((Flow)this.getObject()).getLatencyAndJitterType();
    }

    private boolean flowSupportsLatencyAndOos() {
        FlowTemplate flowTemplate = this.getFlowTemplate();
        if (flowTemplate instanceof FrameBlastingFlow) {
            return !this.isUnicast() || this.hasEavesDroppers();
        }
        return false;
    }

    @Override
    public String getOosString() {
        if (this.flowSupportsLatencyAndOos()) {
            OutOfSequenceType outOfSequenceType = this.getOutOfSequenceType();
            return outOfSequenceType == null ? "click to specify" : outOfSequenceType.getName();
        }
        return "-";
    }

    private OutOfSequenceType getOutOfSequenceType() {
        return ((Flow)this.getObject()).getOutOfSequenceDetection();
    }
}

