/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.model.reader.impl;

import com.excentis.products.byteblower.gui.images.OverlayIcon;
import com.excentis.products.byteblower.gui.model.reader.FlowGuiReader;
import com.excentis.products.byteblower.gui.model.reader.FlowMeasurementGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.gui.model.reader.factory.IconCache;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.FlowMeasurementReaderImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public final class FlowMeasurementGuiReaderImpl
extends FlowMeasurementReaderImpl
implements FlowMeasurementGuiReader {
    private static final String unspecifiedFlow = "click to specify";
    private static final String irrelevant = "-";

    public FlowMeasurementGuiReaderImpl(FlowMeasurement object) {
        super(object);
    }

    @Override
    public Image getImage() {
        Image baseImage = IconCache.getImage("full/obj16/ScenarioAction");
        Object overlayImage = IconCache.getImage("full/obj16/question_ovr");
        overlayImage = this.hasError() ? IconCache.getImage("full/obj16/notok_ovr") : (this.isOverlapping() ? IconCache.getImage("full/obj16/overlap_ovr") : null);
        int arraySize = 0;
        if (overlayImage != null) {
            ++arraySize;
        }
        Image[] overlays = new Image[arraySize];
        int[] locations = new int[arraySize];
        if (overlayImage != null) {
            overlays[0] = overlayImage;
            locations[0] = 3;
        }
        OverlayIcon result = new OverlayIcon(baseImage, overlays, locations, new Point(26, 16));
        return result.createImage();
    }

    @Override
    public FlowGuiReader getFlowGuiReader() {
        Flow flow = this.getFlow();
        return GuiReaderFactory.create(flow);
    }

    @Override
    public String getDurationString() {
        Flow flow = this.getFlow();
        FlowTemplate flowTemplate = null;
        if (flow != null) {
            flowTemplate = flow.getFlowTemplate();
        }
        if (flowTemplate instanceof TcpFlow) {
            TcpFlow tcpFlow = (TcpFlow)flowTemplate;
            TcpFlowReader tcpReader = ReaderFactory.create((TcpFlow)tcpFlow);
            if (tcpReader.isPayloadBased()) {
                return irrelevant;
            }
        } else if (HighResolutionCalendar.MAX_VALUE().equals((Object)this.getDuration())) {
            return "No end defined";
        }
        String time = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)this.getDuration());
        return time;
    }

    @Override
    public String getNumberOfFramesString() {
        Flow flow = this.getFlow();
        if (flow == null) {
            return irrelevant;
        }
        FlowTemplate flowTemplate = flow.getFlowTemplate();
        if (flowTemplate == null) {
            return irrelevant;
        }
        if (flowTemplate instanceof TcpFlow) {
            return irrelevant;
        }
        if (flowTemplate instanceof FrameBlastingFlow) {
            HighResolutionDuration duration = this.getDuration();
            if (HighResolutionCalendar.MAX_VALUE().equals((Object)duration)) {
                return irrelevant;
            }
            return this.getNumberOfFramesBigInteger().toString();
        }
        return irrelevant;
    }

    @Override
    public String getFlowString() {
        Flow flow = this.getFlow();
        if (flow == null) {
            return unspecifiedFlow;
        }
        return flow.getName();
    }
}

