/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.server.model.reader.impl;

import com.excentis.products.byteblower.gui.images.OverlayIcon;
import com.excentis.products.byteblower.gui.model.reader.factory.IconCache;
import com.excentis.products.byteblower.gui.server.model.reader.MeetingPointGuiReader;
import com.excentis.products.byteblower.model.reader.server.impl.MeetingPointReaderImpl;
import com.excentis.products.byteblower.server.model.LicenseType;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.osgi.framework.Version;

public final class MeetingPointGuiReaderImpl
extends MeetingPointReaderImpl
implements MeetingPointGuiReader {
    public MeetingPointGuiReaderImpl(MeetingPoint myMeetingPoint) {
        super(myMeetingPoint);
    }

    @Override
    public Image getImage() {
        boolean hasUpdate;
        Image overlayImage;
        Image baseImage;
        switch (this.getServerLinkStatus()) {
            case ONLINE: {
                baseImage = IconCache.getImage("full/obj16/MeetingPoint");
                overlayImage = null;
                break;
            }
            case INCOMPATIBLE_VERSION: {
                baseImage = IconCache.getImage("full/obj16/MeetingPoint");
                overlayImage = IconCache.getImage("full/obj16/notok_ovr");
                break;
            }
            case OFFLINE: {
                baseImage = IconCache.getImage("full/obj16/MeetingPoint_nok");
                overlayImage = IconCache.getImage("full/obj16/notok_ovr");
                break;
            }
            default: {
                baseImage = IconCache.getImage("full/obj16/MeetingPoint_nok");
                overlayImage = IconCache.getImage("full/obj16/question_ovr");
            }
        }
        int arraySize = 0;
        if (overlayImage != null) {
            ++arraySize;
        }
        if (this.isAvahiAvailable()) {
            ++arraySize;
        }
        if (hasUpdate = this.hasUpdateAvailable()) {
            ++arraySize;
        }
        Image[] overlays = new Image[arraySize];
        int[] locations = new int[arraySize];
        int iterator = 0;
        if (overlayImage != null) {
            overlays[iterator] = overlayImage;
            locations[iterator] = 3;
            ++iterator;
        }
        if (this.isAvahiAvailable()) {
            overlays[iterator] = IconCache.getImage("full/obj16/autodetect_ovr");
            locations[iterator] = 2;
            ++iterator;
        }
        if (hasUpdate) {
            overlays[iterator] = IconCache.getImage("full/obj16/serverUpdate_ovr");
            locations[iterator] = 0;
        }
        OverlayIcon result = new OverlayIcon(baseImage, overlays, locations, new Point(22, 16));
        return result.createImage();
    }

    @Override
    public String getToolTipText() {
        String sysLocation;
        EList currentUsers;
        MeetingPoint MeetingPoint2 = (MeetingPoint)this.getObject();
        String toolTip = new String();
        String localName = MeetingPoint2.getLocalName();
        if (localName != null) {
            toolTip = String.valueOf(toolTip) + localName;
        }
        if (MeetingPoint2.getLicenseType() == LicenseType.NOT_BOUGHT) {
            toolTip = String.valueOf(toolTip) + "\nNo MeetingPoint installed. More information about this add-on is found at http://byteblower.com";
            return toolTip;
        }
        toolTip = String.valueOf(toolTip) + " ( " + MeetingPoint2.getAddress() + " ) \n";
        String version = MeetingPoint2.getVersion();
        String serverType = MeetingPoint2.getServerType();
        if (serverType != null && !"Unknown".equals(serverType)) {
            toolTip = String.valueOf(toolTip) + MeetingPoint2.getServerType() + "\n";
        }
        if ((currentUsers = MeetingPoint2.getCurrentUsers()) != null) {
            toolTip = currentUsers.isEmpty() ? String.valueOf(toolTip) + "Current users on the system : none \n" : String.valueOf(toolTip) + "Current users on the system : " + currentUsers.toString() + "\n";
        }
        if ((sysLocation = MeetingPoint2.getSysLocation()) != null) {
            toolTip = String.valueOf(toolTip) + "\n Location : " + sysLocation;
        }
        if (version != null) {
            toolTip = String.valueOf(toolTip) + "Version : " + version;
            Version latestVersion = this.getLatestVersion();
            if (this.getCurrentVersion().compareTo(latestVersion) < 0) {
                toolTip = String.valueOf(toolTip) + ". Upgrade to " + latestVersion.toString() + " available !";
            }
        } else {
            toolTip = String.valueOf(toolTip) + "Version : unknown";
        }
        return toolTip;
    }

    @Override
    public Color getForegroundColor() {
        MeetingPoint server = (MeetingPoint)this.getObject();
        if (server.getLicenseType() == LicenseType.NOT_BOUGHT) {
            return COLOR_NO_LICENSE;
        }
        return null;
    }
}

