/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.server.model.reader.impl;

import com.excentis.products.byteblower.gui.images.OverlayIcon;
import com.excentis.products.byteblower.gui.model.reader.factory.IconCache;
import com.excentis.products.byteblower.gui.server.model.reader.MobileDeviceGuiReader;
import com.excentis.products.byteblower.model.reader.server.impl.MobileDeviceReaderImpl;
import com.excentis.products.byteblower.server.model.InterfaceLinkStatus;
import com.excentis.products.byteblower.server.model.MobileInterface;
import com.excentis.products.byteblower.server.model.MobileType;
import com.excentis.products.byteblower.server.model.PhysicalMobileDevice;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public final class MobileDeviceGuiReaderImpl
extends MobileDeviceReaderImpl
implements MobileDeviceGuiReader {
    private static final Point ICON_SIZE = new Point(22, 16);

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$server$model$MobileType = MobileDeviceGuiReaderImpl.$SWITCH_TABLE$com$excentis$products$byteblower$server$model$MobileType();
        $SWITCH_TABLE$com$excentis$products$byteblower$server$model$InterfaceLinkStatus = MobileDeviceGuiReaderImpl.$SWITCH_TABLE$com$excentis$products$byteblower$server$model$InterfaceLinkStatus();
    }

    public MobileDeviceGuiReaderImpl(PhysicalMobileDevice myMobileDevice) {
        super(myMobileDevice);
    }

    @Override
    public Image getImage() {
        InterfaceLinkStatus status = this.getInterfaceLinkStatus();
        boolean baseOk = this.isOk(status);
        Image overlayImage = this.linkstatusImage(status);
        Image baseImage = this.mobileTypeImage(baseOk, this.getMobileType());
        int arraySize = 0;
        if (overlayImage != null) {
            ++arraySize;
        }
        Image[] overlays = new Image[arraySize];
        int[] locations = new int[arraySize];
        int iterator = 0;
        if (overlayImage != null) {
            overlays[iterator] = overlayImage;
            locations[iterator] = 3;
            ++iterator;
        }
        OverlayIcon result = new OverlayIcon(baseImage, overlays, locations, ICON_SIZE);
        return result.createImage();
    }

    private boolean isOk(InterfaceLinkStatus status) {
        boolean baseOk = status == InterfaceLinkStatus.ONLINE || status == InterfaceLinkStatus.TEST_RUNNING || status == InterfaceLinkStatus.OTHER_TEST_RUNNING || status == InterfaceLinkStatus.USER_RESERVED || status == InterfaceLinkStatus.OTHER_USER_RESERVED;
        return baseOk;
    }

    private Image mobileTypeImage(boolean baseOk, MobileType mobileType) {
        String imageLocation = baseOk ? this.locationMobileImageGood(mobileType) : this.locationMobileImageBad(mobileType);
        return IconCache.getImage(imageLocation);
    }

    private String locationMobileImageBad(MobileType mobileType) {
        switch (mobileType) {
            case ANDROID: {
                return "full/obj16/MobileDeviceAndroidNok";
            }
            case IOS: {
                return "full/obj16/MobileDeviceAppleNok";
            }
            case LINUX: {
                return "full/obj16/MobileDeviceLinuxNok";
            }
            case OSX: {
                return "full/obj16/MobileDeviceOsxNok";
            }
            case WINDOWS: {
                return "full/obj16/MobileDeviceWindowsNok";
            }
        }
        return "full/obj16/MobileDeviceUnknownNok";
    }

    private String locationMobileImageGood(MobileType mobileType) {
        switch (mobileType) {
            case ANDROID: {
                return "full/obj16/MobileDeviceAndroid";
            }
            case IOS: {
                return "full/obj16/MobileDeviceApple";
            }
            case LINUX: {
                return "full/obj16/MobileDeviceLinux";
            }
            case OSX: {
                return "full/obj16/MobileDeviceOsx";
            }
            case WINDOWS: {
                return "full/obj16/MobileDeviceWindows";
            }
        }
        return "full/obj16/MobileDeviceUnknown";
    }

    private Image linkstatusImage(InterfaceLinkStatus status) {
        switch (status) {
            case ONLINE: {
                return null;
            }
            case TEST_RUNNING: {
                return IconCache.getImage("full/obj16/run_ovr_green");
            }
            case OTHER_TEST_RUNNING: {
                return IconCache.getImage("full/obj16/run_ovr_red");
            }
            case USER_RESERVED: {
                return IconCache.getImage("full/obj16/lock_ovr_green");
            }
            case OTHER_USER_RESERVED: {
                return IconCache.getImage("full/obj16/lock_ovr_red");
            }
            case OFFLINE: {
                return IconCache.getImage("full/obj16/notok_ovr");
            }
        }
        return IconCache.getImage("full/obj16/question_ovr");
    }

    @Override
    public String getToolTipText() {
        String name = this.getName();
        String toolTip = "Mobile Device : " + name + "\n";
        String ipAddress = this.getIpAddress();
        toolTip = String.valueOf(toolTip) + "IP Address : " + ipAddress + "\n";
        String deviceType = this.getDeviceType();
        toolTip = String.valueOf(toolTip) + "Device : " + deviceType + "\n";
        String mobileType = this.getMobileTypeString();
        toolTip = String.valueOf(toolTip) + "OS : " + mobileType + "\n";
        String osVersion = this.getOsVersion();
        toolTip = String.valueOf(toolTip) + "OS Version : " + osVersion + "\n";
        String deviceId = this.getDeviceId();
        toolTip = String.valueOf(toolTip) + "Device ID : " + deviceId + "\n";
        String appVersion = this.getAppVersion();
        toolTip = String.valueOf(toolTip) + "ByteBlower App Version : " + appVersion + "\n";
        String batteryLevel = this.getBatteryLevelString(true);
        toolTip = String.valueOf(toolTip) + "Battery Level : " + batteryLevel;
        if (this.isLocked()) {
            toolTip = String.valueOf(toolTip) + "\nLocked by :" + (this.getLockIsOwner() ? " me, " : " ") + this.getLockOwner();
        }
        toolTip = this.describeNetInterfaces(toolTip);
        if (this.isTestRunning()) {
            toolTip = String.valueOf(toolTip) + "\nTest Running !";
        }
        return toolTip;
    }

    private String describeNetInterfaces(String toolTip) {
        StringBuilder builder = new StringBuilder(toolTip);
        String header = "\nInterfaces : ";
        for (MobileInterface netIf : ((PhysicalMobileDevice)this.getObject()).getInterfaces()) {
            String ifName = netIf.getDisplayName();
            if (ifName.isEmpty()) continue;
            builder.append(header);
            builder.append(netIf.getDisplayName());
            header = ", ";
        }
        return builder.toString();
    }
}

