/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.server.model.reader.impl;

import com.excentis.products.byteblower.gui.images.OverlayIcon;
import com.excentis.products.byteblower.gui.model.reader.factory.IconCache;
import com.excentis.products.byteblower.gui.server.model.reader.PhysicalServerGuiReader;
import com.excentis.products.byteblower.model.reader.server.impl.PhysicalServerReaderImpl;
import com.excentis.products.byteblower.server.model.LicenseType;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.osgi.framework.Version;

public final class PhysicalServerGuiReaderImpl
extends PhysicalServerReaderImpl
implements PhysicalServerGuiReader {
    public PhysicalServerGuiReaderImpl(PhysicalServer myPhysicalServer) {
        super(myPhysicalServer);
    }

    @Override
    public Image getImage() {
        boolean hasUpdate;
        Image overlayImage;
        Image baseImage;
        switch (this.getServerLinkStatus()) {
            case ONLINE: {
                baseImage = IconCache.getImage("full/obj16/server");
                overlayImage = null;
                break;
            }
            case INCOMPATIBLE_VERSION: {
                baseImage = IconCache.getImage("full/obj16/server");
                overlayImage = IconCache.getImage("full/obj16/notok_ovr");
                break;
            }
            case OFFLINE: {
                baseImage = IconCache.getImage("full/obj16/server_nok");
                overlayImage = IconCache.getImage("full/obj16/notok_ovr");
                break;
            }
            default: {
                baseImage = IconCache.getImage("full/obj16/server_nok");
                overlayImage = IconCache.getImage("full/obj16/question_ovr");
            }
        }
        int arraySize = 0;
        if (overlayImage != null) {
            ++arraySize;
        }
        if (this.isAvahiAvailable()) {
            ++arraySize;
        }
        if (hasUpdate = this.hasUpdateAvailable()) {
            ++arraySize;
        }
        Image[] overlays = new Image[arraySize];
        int[] locations = new int[arraySize];
        int iterator = 0;
        if (overlayImage != null) {
            overlays[iterator] = overlayImage;
            locations[iterator] = 3;
            ++iterator;
        }
        if (this.isAvahiAvailable()) {
            overlays[iterator] = IconCache.getImage("full/obj16/autodetect_ovr");
            locations[iterator] = 2;
            ++iterator;
        }
        if (hasUpdate) {
            overlays[iterator] = IconCache.getImage("full/obj16/serverUpdate_ovr");
            locations[iterator] = 0;
        }
        OverlayIcon result = new OverlayIcon(baseImage, overlays, locations, new Point(22, 16));
        return result.createImage();
    }

    @Override
    public String getToolTipText() {
        String sysLocation;
        EList currentUsers;
        PhysicalServer physicalServer = (PhysicalServer)this.getObject();
        String toolTip = new String();
        String localName = physicalServer.getLocalName();
        if (localName != null) {
            toolTip = String.valueOf(toolTip) + localName;
        }
        toolTip = String.valueOf(toolTip) + " ( " + physicalServer.getAddress() + " ) \n";
        String version = physicalServer.getVersion();
        String serverSeries = physicalServer.getServerType();
        if (serverSeries != null && !"Unknown".equals(serverSeries)) {
            toolTip = String.valueOf(toolTip) + "ByteBlower " + serverSeries + " series\n";
        }
        if ((currentUsers = physicalServer.getCurrentUsers()) != null) {
            toolTip = currentUsers.isEmpty() ? String.valueOf(toolTip) + "Current users on the system : none \n" : String.valueOf(toolTip) + "Current users on the system : " + currentUsers.toString() + "\n";
        }
        if ((sysLocation = physicalServer.getSysLocation()) != null) {
            toolTip = String.valueOf(toolTip) + "\n Location : " + sysLocation;
        }
        if (version != null) {
            toolTip = String.valueOf(toolTip) + "Version : " + version;
            Version latestVersion = this.getLatestVersion();
            if (this.getCurrentVersion().compareTo(latestVersion) < 0) {
                toolTip = String.valueOf(toolTip) + ". Upgrade to " + latestVersion.toString() + " available !";
            }
        } else {
            toolTip = String.valueOf(toolTip) + "Version : unknown";
        }
        return toolTip;
    }

    @Override
    public Color getForegroundColor() {
        PhysicalServer server = (PhysicalServer)this.getObject();
        if (server.getLicenseType() == LicenseType.NOT_BOUGHT) {
            return COLOR_NO_LICENSE;
        }
        return null;
    }
}

