/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.preferences.ui.general;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class CloudApiKeyCheck {
    private static final int DEBOUNCE = 100;
    private AtomicReference<ToCheck> keyToCheck = new AtomicReference<ToCheck>(ToCheck.NothingToCheck);
    private Job checkJob = new Job("Cloud API Key check"){

        public IStatus run(IProgressMonitor arg0) {
            CloudApiKeyCheck.this.doCheckKey();
            return Status.OK_STATUS;
        }
    };

    private static String version() {
        Version v = FrameworkUtil.getBundle(CloudApiKeyCheck.class).getVersion();
        return v.toString();
    }

    public void addCheck(String key, Consumer<KeyResult> processor) {
        ToCheck check = new ToCheck();
        check.key = key;
        check.processor = processor;
        ToCheck old = this.keyToCheck.getAndSet(check);
        if (ToCheck.NothingToCheck == old) {
            this.checkJob.setPriority(50);
            this.checkJob.schedule(100L);
        }
    }

    private void doCheckKey() {
        ToCheck key = this.keyToCheck.getAndSet(ToCheck.NothingToCheck);
        if (key == ToCheck.NothingToCheck) {
            return;
        }
        try {
            boolean wrongEncoding;
            ProxySelector defaultProxy = ProxySelector.getDefault();
            URI target = new URI(String.valueOf(ByteBlowerPreferences.getExcentisCloudUrl()) + "api/");
            String sanitizedKey = new String(key.key.getBytes(StandardCharsets.US_ASCII));
            boolean bl = wrongEncoding = !sanitizedKey.equals(key.key);
            if (wrongEncoding) {
                key.processor.accept(new KeyResult(key.key, ValidationResult.UNUSABLE));
                return;
            }
            long start = System.nanoTime();
            HttpClient client = HttpClient.newBuilder().proxy(defaultProxy).connectTimeout(Duration.ofSeconds(30L)).build();
            System.out.format("HttpClient built in %f ms %n", (double)(System.nanoTime() - start) / 1000000.0);
            String authorizationScheme = "ApiKey";
            String authorization = String.valueOf(authorizationScheme) + " " + sanitizedKey;
            HttpRequest req = HttpRequest.newBuilder().uri(target).header("Authorization", authorization).header("accept", "application/json").header("User-Agent", String.format("ByteBlower-RCP/%s", CloudApiKeyCheck.version())).method("OPTIONS", HttpRequest.BodyPublishers.noBody()).build();
            HttpResponse<Void> check = client.send(req, HttpResponse.BodyHandlers.discarding());
            boolean keyIsAccepted = check.statusCode() < 300;
            key.processor.accept(new KeyResult(key.key, keyIsAccepted ? ValidationResult.VALID : ValidationResult.UNUSABLE));
        }
        catch (SSLException ex) {
            Logger.getGlobal().log(Level.WARNING, "Unable to setup secure connection", ex);
            key.processor.accept(new KeyResult(key.key, ValidationResult.UNCERTAIN));
        }
        catch (IOException | URISyntaxException exception) {
            key.processor.accept(new KeyResult(key.key, ValidationResult.UNCERTAIN));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            key.processor.accept(new KeyResult(key.key, ValidationResult.UNUSABLE));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static class KeyResult {
        final String key;
        final ValidationResult result;

        public KeyResult(String key, ValidationResult result) {
            this.key = key;
            this.result = result;
        }
    }

    private static class ToCheck {
        static final ToCheck NothingToCheck = new ToCheck();
        String key;
        Consumer<KeyResult> processor;

        private ToCheck() {
        }
    }

    static enum ValidationResult {
        VALID,
        UNCERTAIN,
        UNUSABLE;

    }
}

