/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.preferences;

import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.cloud.CloudStatusPoller;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class ByteBlowerPreferences {
    public static final String defaultCloud = "https://cloud.excentis.com/";
    static IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.excentis.products.byteblower.gui.preferences");
    private static final String projectFileExtension = ".bbp";
    private static final String defaultWarningLossLevel = "0.01";
    private static final String defaultErrorLossLevel = "0.02";
    private static final int defaultNumberOfDecimals = 2;
    private static final int defaultNumberOfLatencyDecimals = 3;
    private static final String defaultWaitTimeAfterScenario = "5000000000";
    private static final String defaultDhcpTimeout = "1000000000";
    private static final String defaultDhcpRetries = "5";
    private static final String defaultLatencyRangeStart = "0";
    private static final String defaultLatencyRangeEnd = "100000000";
    private static final long defaultHttpGracePeriod = Long.MAX_VALUE;
    private static final boolean defaultVlanSortingDirection_OUTER_ON_TOP = Boolean.TRUE;
    private static final String defaultRecentRunTitle = "";
    private static final boolean defaultShowSolutionView = true;
    private static final boolean defaultShowRootCausesOnly = true;
    public static final String maximumDhcpRetries = "999999";
    public static final String maximumDhcpTimeout = "64000000000";
    public static final String minimumDhcpTimeout = "1000000";
    private static final int defaultUndoLimit = 100;
    private static final int defaultNofRecentProjectsLimit = 20;
    private static final String SERVER = "Server";
    private static final String NAME = "Name";
    private static final String ADDRESS = "Address";
    private static final String AVAHIID = "AvahiID";
    private static final int defaultOpenmetricsPort = 8123;
    private static final long defaultScenarioHeartbeatInterval = 5000000000L;
    private static final int defaultThroughputUnit = 2;
    private static final int defaultLatencyUnit = 14;
    private static final int defaultThroughputType = 0;
    private static final Set<SimpleChangeListener> changeListeners = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    private static final Map<String, Object> overriddenSettings = new HashMap<String, Object>();
    public static final int missingwidth = -1;

    static {
        prefs.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent arg0) {
                for (SimpleChangeListener listen : changeListeners) {
                    listen.preferenceChanged();
                }
            }
        });
    }

    public static void addListener(SimpleChangeListener interest) {
        changeListeners.add(interest);
    }

    public static String getProjectFileExtension() {
        return projectFileExtension;
    }

    public static String getWarningLossLevel() {
        return prefs.get("warningLossLevel", defaultWarningLossLevel);
    }

    public static String getErrorLossLevel() {
        return prefs.get("errorLossLevel", defaultErrorLossLevel);
    }

    public static int getNumberOfDecimals() {
        return prefs.getInt("numberOfDecimals", 2);
    }

    public static int getNumberOfLatencyDecimals() {
        return prefs.getInt("numberOfLatencyDecimals", 3);
    }

    public static boolean getOutputToHtml() {
        return prefs.getBoolean("outputToHtml", false);
    }

    public static boolean getOutputToPdf() {
        return prefs.getBoolean("outputToPdf", false);
    }

    public static boolean getOutputToDocx() {
        return prefs.getBoolean("outputToDocx", false);
    }

    public static boolean getOutputToExcel() {
        return prefs.getBoolean("outputToExcel", false);
    }

    public static boolean getOutputToCsv() {
        return prefs.getBoolean("outputToCsv", false);
    }

    public static boolean getOutputToJson() {
        return prefs.getBoolean("outputToJson", false);
    }

    public static boolean getOutputProjectBackup() {
        return prefs.getBoolean("outputProjectBackup", true);
    }

    public static int getThroughputUnit() {
        return prefs.getInt("throughputUnit", 2);
    }

    public static int getThroughputType() {
        return prefs.getInt("throughputType", 0);
    }

    public static int getLatencyUnit() {
        return prefs.getInt("latencyUnit", 14);
    }

    public static String getExportDir() {
        String exportDir = prefs.get("exportdir", ByteBlowerPreferences.getArchiveLocation());
        if (exportDir == defaultRecentRunTitle) {
            exportDir = ByteBlowerPreferences.getArchiveLocation();
            ByteBlowerPreferences.setExportDir(exportDir);
        }
        return exportDir;
    }

    public static String getAutoSaveFile() {
        StringBuilder name = new StringBuilder();
        name.append(ByteBlowerPreferences.getArchiveLocation());
        name.append(File.separatorChar);
        name.append("autosaved-project");
        name.append(ByteBlowerPreferences.getProjectFileExtension());
        return name.toString();
    }

    public static String getArchiveLocation() {
        File path;
        String archiveLocation = prefs.get("archiveLocation", ByteBlowerPreferences.getDefaultArchiveLocation());
        if (archiveLocation.equals(defaultRecentRunTitle)) {
            archiveLocation = ByteBlowerPreferences.getDefaultArchiveLocation();
        }
        if (!(path = new File(archiveLocation)).exists()) {
            archiveLocation = ByteBlowerPreferences.getDefaultArchiveLocation();
        }
        return archiveLocation;
    }

    private static String getDefaultArchiveLocation() {
        Path path = new Path(ByteBlowerPreferences.getRuntimeWorkspaceLocation());
        path = path.append("Archive");
        return path.toOSString();
    }

    public static String getRuntimeWorkspaceLocation() {
        return Platform.getLocation().toOSString();
    }

    public static void setWarningLossLevel(String string) {
        prefs.put("warningLossLevel", string);
    }

    public static void setErrorLossLevel(String string) {
        prefs.put("errorLossLevel", string);
    }

    public static void setNumberOfDecimals(int integer) {
        prefs.putInt("numberOfDecimals", integer);
    }

    public static void setNumberOfLatencyDecimals(int integer) {
        prefs.putInt("numberOfLatencyDecimals", integer);
    }

    public static boolean setArchiveLocation(String defaultReportOutput) {
        boolean error = false;
        File path = new File(defaultReportOutput);
        boolean bl = error = !path.exists();
        if (!error) {
            prefs.put("archiveLocation", defaultReportOutput);
        }
        return error;
    }

    public static void setOutputToExcel(boolean selection) {
        prefs.putBoolean("outputToExcel", selection);
    }

    public static void setOutputToHtml(boolean selection) {
        prefs.putBoolean("outputToHtml", selection);
    }

    public static void setOutputToCsv(boolean selection) {
        prefs.putBoolean("outputToCsv", selection);
    }

    public static void setOutputToDocx(boolean selection) {
        prefs.putBoolean("outputToDocx", selection);
    }

    public static void setOutputToPdf(boolean selection) {
        prefs.putBoolean("outputToPdf", selection);
    }

    public static void setOutputToJson(boolean selection) {
        prefs.putBoolean("outputToJson", selection);
    }

    public static void setOutputProjectBackup(boolean selection) {
        prefs.putBoolean("outputProjectBackup", selection);
    }

    public static void setThroughputUnit(int throughput) {
        prefs.putInt("throughputUnit", throughput);
    }

    public static void setLatencyUnit(int unit) {
        prefs.putInt("latencyUnit", unit);
    }

    public static void setThroughputType(int throughput) {
        prefs.putInt("throughputType", throughput);
    }

    public static boolean getIdenticalFramesWarning() {
        return prefs.getBoolean("identicalFramesWarning", true);
    }

    public static boolean getPauseAfterDhcp() {
        return prefs.getBoolean("pauseAfterDhcp", true);
    }

    public static boolean getAutoRefreshAtStartup() {
        return prefs.getBoolean("autoRefreshAtStartup", true);
    }

    public static boolean getEnableScoutingFrames() {
        return prefs.getBoolean("enableScoutingFrames", true);
    }

    public static boolean getEnableAutomaticTcpRestart() {
        return prefs.getBoolean("enableAutomaticTcpRestart", true);
    }

    public static boolean getIgnoreInitializationErrors() {
        return prefs.getBoolean("ignoreInitializationErrors", false);
    }

    public static void setIdenticalFramesWarning(boolean check) {
        prefs.putBoolean("identicalFramesWarning", check);
    }

    public static void setPauseAfterDhcp(boolean check) {
        prefs.putBoolean("pauseAfterDhcp", check);
    }

    public static void setAutoRefreshAtStartup(boolean check) {
        prefs.putBoolean("autoRefreshAtStartup", check);
    }

    public static void setEnableScoutingFrames(boolean check) {
        prefs.putBoolean("enableScoutingFrames", check);
    }

    public static void setIgnoreInitializationErrors(boolean check) {
        prefs.putBoolean("ignoreInitializationErrors", check);
    }

    public static void setExportDir(String string) {
        prefs.put("exportdir", string);
    }

    public static void setDhcpTimeout(String string) {
        prefs.put("dhcpTimeout", string);
    }

    public static void setDhcpRetries(String string) {
        prefs.put("dhcpRetries", string);
    }

    public static int getNofServers() {
        return prefs.getInt("nofServers", 0);
    }

    public static String getServerName(int serverID) {
        return prefs.get(SERVER + serverID + NAME, null);
    }

    public static String getServerAddress(int serverID) {
        return prefs.get(SERVER + serverID + ADDRESS, null);
    }

    public static String getServerAvahiID(int serverID) {
        return prefs.get(SERVER + serverID + AVAHIID, null);
    }

    public static boolean getSyncServer() {
        return prefs.getBoolean("syncedServers", false);
    }

    public static void setSyncServer(boolean sync) {
        prefs.putBoolean("syncedServers", sync);
    }

    public static int getUndoLimit() {
        return prefs.getInt("undoLimit", 100);
    }

    public static void setUndoLimit(int undoLimit) {
        prefs.putInt("undoLimit", undoLimit);
    }

    public static int getRecentProjectsLimit() {
        return prefs.getInt("recentProjectsLimit", 20);
    }

    public static void setRecentProjectsLimit(int limit) {
        prefs.putInt("recentProjectsLimit", limit);
    }

    public static boolean getPortViewShowIpv4() {
        return prefs.getBoolean("portViewShowIpv4", true);
    }

    public static boolean getPortViewShowIpv6() {
        return prefs.getBoolean("portViewShowIpv6", true);
    }

    public static void setPortViewShowIpv4(boolean show) {
        prefs.putBoolean("portViewShowIpv4", show);
    }

    public static void setPortViewShowIpv6(boolean show) {
        prefs.putBoolean("portViewShowIpv6", show);
    }

    public static boolean getMulticastViewShowSourceSpecificMulticast() {
        return prefs.getBoolean("multicastViewShowSourceSpecificMulticast", true);
    }

    public static void setMulticastViewShowSourceSpecificMulticast(boolean show) {
        prefs.putBoolean("multicastViewShowSourceSpecificMulticast", show);
    }

    public static String getWaitTimeAfterScenario() {
        return prefs.get("waitTimeAfterScenario", defaultWaitTimeAfterScenario);
    }

    public static void setWaitTimeAfterScenario(String string) {
        prefs.put("waitTimeAfterScenario", string);
    }

    public static String getDhcpTimeout() {
        return prefs.get("dhcpTimeout", defaultDhcpTimeout);
    }

    public static String getDhcpRetries() {
        return prefs.get("dhcpRetries", defaultDhcpRetries);
    }

    public static String getLatencyRangeStart() {
        return prefs.get("latencyRangeStart", defaultLatencyRangeStart);
    }

    public static void setLatencyRangeStart(String string) {
        prefs.put("latencyRangeStart", string);
    }

    public static String getLatencyRangeEnd() {
        return prefs.get("latencyRangeEnd", defaultLatencyRangeEnd);
    }

    public static void setLatencyRangeEnd(String string) {
        prefs.put("latencyRangeEnd", string);
    }

    @Deprecated
    public static long getHttpGracePeriod() {
        return prefs.getLong("httpGracePeriod", Long.MAX_VALUE);
    }

    @Deprecated
    private static void setHttpGracePeriod(long ns) {
        prefs.putLong("httpGracePeriod", ns);
    }

    @Deprecated
    public static void setHttpGracePeriod(HighResolutionCalendar killTime) {
        ByteBlowerPreferences.setHttpGracePeriod(killTime.getTimeInNanoseconds());
    }

    public static IEclipsePreferences getPreferences() {
        return prefs;
    }

    public static boolean getVlanSortingDirection() {
        return prefs.getBoolean("vlanSortingDirection", defaultVlanSortingDirection_OUTER_ON_TOP);
    }

    public static void setVlanSortingDirection(boolean outerOnTop) {
        prefs.putBoolean("vlanSortingDirection", outerOnTop);
    }

    public static String getRecentRunTitle() {
        return prefs.get("recentRunTitle", defaultRecentRunTitle);
    }

    public static void setRecentRunTitle(String runTitle) {
        prefs.put("recentRunTitle", runTitle);
    }

    public static boolean getShowSolutionView() {
        return prefs.getBoolean("showSolutionView", true);
    }

    public static void setShowSolutionView(boolean showSolutionView) {
        prefs.putBoolean("showSolutionView", showSolutionView);
    }

    public static boolean getShowRootCausesOnly() {
        return prefs.getBoolean("showRootCausesOnly", true);
    }

    public static void setShowRootCausesOnly(boolean show) {
        prefs.putBoolean("showRootCausesOnly", show);
    }

    public static void storeColumnWidth(String columnIdentifier, int width) {
        prefs.putInt(columnIdentifier, width);
    }

    public static int getStoredColumnWidth(String columnIdentifier) {
        int width = prefs.getInt(columnIdentifier, -1);
        return width;
    }

    public static void setEnableAutomaticTcpRestart(boolean check) {
        prefs.putBoolean("enableAutomaticTcpRestart", check);
    }

    public static boolean getUseHighcharts() {
        return true;
    }

    public static String getPopuppedVersion(String type) {
        return prefs.get("latestShownServerVersionForType" + type, null);
    }

    public static void setPopuppedVersion(String type, String version) {
        prefs.put("latestShownServerVersionForType" + type, version);
    }

    public static boolean get64BitVersionAvailableMessageShown() {
        return prefs.getBoolean("64BitVersionAvailableMessageShown", false);
    }

    public static void set64BitVersionAvailableMessageShown() {
        prefs.putBoolean("64BitVersionAvailableMessageShown", true);
    }

    public static boolean setDefaultResultsOverTimeEnabled(boolean isEnabled) {
        prefs.putBoolean("embeddedResultsOverTime", isEnabled);
        return isEnabled;
    }

    public static boolean getDefaultResultsOverTimeEnabled() {
        return prefs.getBoolean("embeddedResultsOverTime", true);
    }

    public static String getDefaultAuthor() {
        return prefs.get("defaultAuthor", System.getProperty("user.name"));
    }

    public static void setDefaultAuthor(String defaultAuthor) {
        prefs.put("defaultAuthor", defaultAuthor);
    }

    public static boolean setWarningNoRotEnabled(boolean isEnabled) {
        prefs.putBoolean("warningNoRotEnabled", isEnabled);
        return isEnabled;
    }

    public static boolean getWarningNoRotEnabled() {
        return prefs.getBoolean("warningNoRotEnabled", true);
    }

    public static int getOpenMetricsPort() {
        return prefs.getInt("openMetricsTCPPort", 8123);
    }

    public static int setOpenMetricsPort(int newPort) {
        prefs.putInt("openMetricsTCPPort", newPort);
        return newPort;
    }

    public static String getDefaultProjectName() {
        return prefs.get("defaultProjectName", "ByteBlower_Project");
    }

    public static void setDefaultProjectName(String defaultProjectName) {
        prefs.put("defaultProjectName", defaultProjectName);
    }

    public static long getDefaultScenarioHeartbeatInterval() {
        return prefs.getLong("scenarioHeartbeatInterval", 5000000000L);
    }

    public static void setDefaultScenarioHeartbeatInterval(long scenarioHeartbeatInterval) {
        prefs.putLong("scenarioHeartbeatInterval", scenarioHeartbeatInterval);
    }

    public static boolean isReportOutputToDeprecatedHtml() {
        return prefs.getBoolean("outputToDeprecatedHtml", false);
    }

    public static void setOutputToDeprecatedHtml(boolean generateDeprecatedHtml) {
        prefs.putBoolean("outputToDeprecatedHtml", generateDeprecatedHtml);
    }

    public static boolean getOutputToDynamicHtml() {
        return prefs.getBoolean("outputToDynamicHtml", true);
    }

    public static boolean setOutputToDynamicHtml(boolean generateDynamicHtml) {
        prefs.putBoolean("outputToDynamicHtml", generateDynamicHtml);
        return generateDynamicHtml;
    }

    public static boolean hasApiKey() {
        return ByteBlowerPreferences.getApiKey() != null && !ByteBlowerPreferences.getApiKey().isBlank();
    }

    public static boolean allowCloudFunctionality() {
        return !ByteBlowerPreferences.getApiKey().equals(defaultRecentRunTitle);
    }

    public static String getApiKey() {
        String originalKey = prefs.get("excentisCloudApiKey", defaultRecentRunTitle);
        return String.valueOf(overriddenSettings.getOrDefault("excentisCloudApiKey", originalKey));
    }

    public static String setApiKey(String key) {
        prefs.put("excentisCloudApiKey", key);
        CloudStatusPoller.getInstance().setCloudApiKey(key);
        return key;
    }

    public static String overrideApiKeyTemporarily(String key) {
        overriddenSettings.put("excentisCloudApiKey", key);
        return key;
    }

    public static String getExcentisCloudUrl() {
        return prefs.get("excentisCloudBaseUrlKey", defaultCloud);
    }

    public static boolean showCloudOnboarding() {
        return prefs.getBoolean("excentisCloudShowOnboarding", true);
    }

    public static void setCloudShowOnboarding(boolean value) {
        prefs.putBoolean("excentisCloudShowOnboarding", value);
    }

    public static enum PreferredBrowser {
        EMBEDDED,
        DEFAULT_EXTERN;

    }

    public static interface SimpleChangeListener {
        public void preferenceChanged();
    }
}

