/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.project;

import com.excentis.products.byteblower.gui.history.ByteBlowerHistoryListener;
import com.excentis.products.byteblower.gui.history.IHistorySavedStateListener;
import com.excentis.products.byteblower.gui.history.actions.ByteBlowerModelHistory;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerProjectOperation;
import com.excentis.products.byteblower.gui.history.operations.status.StatusUpdater;
import com.excentis.products.byteblower.gui.preferences.Activator;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerMenuItemEnabler;
import com.excentis.products.byteblower.gui.project.IProjectModificationListener;
import com.excentis.products.byteblower.gui.project.WizardLauncher;
import com.excentis.products.byteblower.gui.refresher.IRefreshListener;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.undo.ByteBlowerMainUndoContext;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import com.excentis.products.byteblower.project.ByteBlowerResource;
import com.excentis.products.byteblower.project.ByteBlowerResourceController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;

public class ByteBlowerGuiResourceController
extends ByteBlowerResourceController
implements IProjectModificationListener,
IRefreshListener {
    private static Logger LOGGER = Logger.getGlobal();
    private static ByteBlowerGuiResourceController instance;
    private ProjectSwitchNotifier projectSwitchNotifier;
    private ByteBlowerProjectController activeProjectController;
    private PhysicalConfigurationManager configurationManager = PhysicalConfigurationManager.getInstance();
    public static final String DEPRECATED_JASPER_HTML_URL = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/306";
    public static final String DEPRECATED_PDF_XLSX_URL = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/305";
    private final ByteBlowerHistoryListener byteBlowerHistoryListener = new ByteBlowerHistoryListener(ByteBlowerModelHistory.history, new IHistorySavedStateListener(){

        public void historySavedStateUpdated(boolean historyAtSavedState) {
            ByteBlowerGuiResourceController.this.updateTitleBar(ByteBlowerGuiResourceController.this.atSaveState());
            ByteBlowerMenuItemEnabler.updateMenuItems();
        }
    });
    private static IWorkbenchWindowConfigurer configurer;
    private static final String ByteBlowerGuiName = "Excentis ByteBlower";

    static {
        Job saveJob = new Job("auto save job"){
            private int previousProjectHashcode;

            protected IStatus run(IProgressMonitor arg0) {
                ByteBlowerGuiResourceController instance = ByteBlowerGuiResourceController.getInstance();
                ByteBlowerResource activeResource = instance.getActiveResource();
                if (activeResource != null) {
                    try {
                        String str = instance.getActiveResourceAsXmlString();
                        if (str.hashCode() != this.previousProjectHashcode) {
                            this.saveToFile(str);
                        }
                    }
                    catch (Exception e) {
                        Status logStatus = new Status(4, "com.excentis.products.byteblower.gui.preferences", "Failed to save project", (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)logStatus);
                    }
                }
                this.schedule(TimeUnit.SECONDS.toMillis(20L));
                return Status.OK_STATUS;
            }

            private void saveToFile(String str) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (FileOutputStream save = new FileOutputStream(ByteBlowerPreferences.getAutoSaveFile());){
                        save.write(str.getBytes());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        saveJob.schedule();
    }

    public static final ByteBlowerGuiResourceController getInstance() {
        if (instance == null) {
            instance = new ByteBlowerGuiResourceController();
        }
        return instance;
    }

    public ByteBlowerGuiResourceController() {
        this.projectSwitchNotifier = ProjectSwitchNotifier.getInstance();
    }

    private void setCurrentProject(ByteBlowerProject project, URI location) {
        ByteBlowerProject currentProject = this.projectSwitchNotifier.getCurrentProject();
        if (project == currentProject) {
            return;
        }
        this.projectSwitchNotifier.changeProject(project, location);
        this.activeProjectController = project == null ? null : new ByteBlowerProjectController(project);
        if (project != null) {
            this.configurationManager.setRefreshListener((IRefreshListener)this);
        }
        UndoableByteBlowerProjectOperation.setCurrentProject((ByteBlowerProject)project);
        StatusUpdater.getInstance().update(project);
        this.configurationManager.setProject((ByteBlowerProjectReader)this.activeProjectController);
        IUndoContext undoContext = this.getUndoContext();
        this.byteBlowerHistoryListener.saveState(undoContext);
    }

    public ByteBlowerProject getActiveProject() {
        return this.projectSwitchNotifier.getCurrentProject();
    }

    public static ByteBlowerProject getProject() {
        return ByteBlowerGuiResourceController.getInstance().getActiveProject();
    }

    public static ByteBlowerProjectReader getProjectReader() {
        return ByteBlowerGuiResourceController.getInstance().activeProjectController;
    }

    public static ByteBlowerProjectController getProjectController() {
        return ByteBlowerGuiResourceController.getInstance().activeProjectController;
    }

    public String getActiveResourceAsXmlString() {
        String xmlString = null;
        try {
            ByteBlowerResource resource = this.getActiveResource();
            if (resource == null) {
                throw new Exception("ByteBlower resource for active project unavailable");
            }
            HashMap options = new HashMap();
            StringWriter writer = new StringWriter();
            resource.save((Writer)writer, options);
            xmlString = writer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return xmlString;
    }

    public boolean isOpen() {
        return this.isLoaded();
    }

    public boolean atSaveState() {
        return this.byteBlowerHistoryListener.atSavedState();
    }

    private IUndoContext getUndoContext() {
        ByteBlowerProjectController projectController = ByteBlowerGuiResourceController.getProjectController();
        Object undoContext = projectController != null ? projectController.getUndoContext() : ByteBlowerMainUndoContext.instance;
        return undoContext;
    }

    private final boolean fileExists(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    /*
     * Loose catch block
     */
    public boolean create(final String projectName, final String authorName, String location, WizardLauncher wizard) {
        if (this.isOpen()) {
            System.err.println("The current project should be closed before creating a new one !");
            return false;
        }
        final String fileName = this.createFilename(projectName, location);
        IWorkbench wb = PlatformUI.getWorkbench();
        if (this.fileExists(fileName) && !MessageDialog.openQuestion((Shell)wb.getActiveWorkbenchWindow().getShell(), (String)"Overwrite ?", (String)("\"" + fileName + "\" already exists.\n\n" + "Would you like to overwrite it ?"))) {
            return false;
        }
        IRunnableWithProgress createOperation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ByteBlowerGuiResourceController.this.create(fileName, projectName, authorName, monitor);
            }
        };
        IRunnableWithProgress openOperation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ByteBlowerResource resource = ByteBlowerGuiResourceController.this.openProject(fileName, monitor);
                URI location = URI.createFileURI((String)fileName);
                ByteBlowerGuiResourceController.this.setCurrentProject(resource.getByteBlowerProject(), location);
            }
        };
        try {
            try {
                IWorkbenchWindow wbWindow = wb.getActiveWorkbenchWindow();
                wbWindow.run(false, false, createOperation);
                wbWindow.run(false, false, openOperation);
                this.configurationManager.setProject((ByteBlowerProjectReader)this.activeProjectController);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                this.tellOpenCloseListeners();
                return false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
                this.tellOpenCloseListeners();
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Exception caught while creating new project");
                this.tellOpenCloseListeners();
                return false;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.tellOpenCloseListeners();
        }
        wizard.launch();
        return true;
    }

    private void tellOpenCloseListeners() {
        ProjectSwitchNotifier.getInstance().tellOpenCloseListeners();
    }

    private boolean closeAskSaveChanges(String fileName) {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            Shell shell = win.getShell();
            String message = "Do you want to save the changes you made to\r\nByteBlower project \"" + fileName + "\" ?";
            MessageDialog dialog = new MessageDialog(shell, "ByteBlower", null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            int answer = dialog.open();
            switch (answer) {
                case 0: {
                    return this.save();
                }
                case 1: {
                    return true;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
            throw new RuntimeException();
        }
        return true;
    }

    public boolean close() {
        String lastSegment;
        if (!this.atSaveState() && !this.closeAskSaveChanges(lastSegment = this.getActiveFileNameLastSegment())) {
            return false;
        }
        this.closeActiveProject();
        this.updateTitleBar(true);
        ByteBlowerMenuItemEnabler.updateMenuItems();
        return true;
    }

    protected void openProjectNotifyOpenFailed(String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Project Error", (String)message);
    }

    public ByteBlowerProject openProject(final String fileName) {
        block6: {
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Opening project...", -1);
                    ByteBlowerResource resource = ByteBlowerGuiResourceController.this.openProject(fileName, monitor);
                    URI location = URI.createFileURI((String)fileName);
                    ByteBlowerGuiResourceController.this.setCurrentProject(resource.getByteBlowerProject(), location);
                }
            };
            IWorkbench wb = PlatformUI.getWorkbench();
            try {
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                window.run(false, false, operation);
            }
            catch (InvocationTargetException e) {
                final Throwable cause = e.getCause();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Failed to load project", (String)cause.getMessage(), (IStatus)new Status(4, "com.excentis.products.byteblower.gui.project", cause.getMessage(), cause.getCause()));
                    }
                });
                this.tellOpenCloseListeners();
                this.updateTitleBar(true);
                ByteBlowerMenuItemEnabler.updateMenuItems();
                break block6;
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.tellOpenCloseListeners();
                    this.updateTitleBar(true);
                    ByteBlowerMenuItemEnabler.updateMenuItems();
                    throw throwable;
                }
            }
            this.tellOpenCloseListeners();
            this.updateTitleBar(true);
            ByteBlowerMenuItemEnabler.updateMenuItems();
        }
        return this.projectSwitchNotifier.getCurrentProject();
    }

    public static void setConfigurer(IWorkbenchWindowConfigurer myConfigurer) {
        configurer = myConfigurer;
        configurer.setTitle(ByteBlowerGuiName);
    }

    private void updateTitleBar(boolean atSavedState) {
        String title;
        ByteBlowerProject project = this.getActiveProject();
        if (project != null) {
            String fileName = this.getActiveFileNameLastSegment();
            if (!atSavedState) {
                fileName = String.valueOf(fileName) + "*";
            }
            title = String.valueOf(fileName) + " - " + ByteBlowerGuiName;
        } else {
            title = ByteBlowerGuiName;
        }
        final String finalTitle = title;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb.isClosing()) {
            return;
        }
        wb.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                configurer.setTitle(finalTitle);
            }
        });
    }

    public boolean checkAndSaveas(String fileName) {
        File testOverwrite = new File(fileName);
        if (testOverwrite.exists() && !this.saveasAskBeforeOverwrite(fileName)) {
            return false;
        }
        return this.saveas(fileName);
    }

    private ByteBlowerResource getActiveResource() {
        ByteBlowerProject activeProject = this.projectSwitchNotifier.getCurrentProject();
        if (activeProject == null) {
            return null;
        }
        return this.getAddedResource(activeProject);
    }

    private final boolean isLoaded() {
        ByteBlowerResource activeResource = this.getActiveResource();
        if (activeResource == null) {
            return false;
        }
        return activeResource.isLoaded();
    }

    public boolean save() {
        boolean isSuccess = false;
        if (ByteBlowerGuiResourceController.getProject() == null) {
            LOGGER.log(Level.WARNING, "Trying to save without open project");
            return isSuccess;
        }
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Saving project...", -1);
                ByteBlowerResource activeResource = ByteBlowerGuiResourceController.this.getActiveResource();
                ByteBlowerGuiResourceController.this.save(activeResource, monitor);
                IUndoContext undoContext = ByteBlowerGuiResourceController.this.getUndoContext();
                ByteBlowerGuiResourceController.this.byteBlowerHistoryListener.saveState(undoContext);
            }
        };
        IWorkbench wb = PlatformUI.getWorkbench();
        try {
            IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
            window.run(false, false, operation);
            isSuccess = true;
        }
        catch (InvocationTargetException e) {
            Status logStatus = new Status(4, "com.excentis.products.byteblower.gui.preferences", "Failed to save project", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)logStatus);
            final Throwable cause = e.getCause();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Failed to save project", null, (IStatus)new Status(4, "com.excentis.products.byteblower.gui.project", cause.getMessage(), cause.getCause()));
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return isSuccess;
    }

    private boolean saveasAskBeforeOverwrite(String fileName) {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Overwrite ?", (String)("\"" + fileName + "\" already exists.\n\n" + "Would you like to overwrite it ?"));
    }

    private boolean saveas(String fileName) {
        ByteBlowerResource activeResource = this.getActiveResource();
        if (activeResource == null) {
            return false;
        }
        URI originalUri = activeResource.getURI();
        activeResource.setResourceFileName(fileName);
        if (!this.save()) {
            activeResource.setURI(originalUri);
            return false;
        }
        return true;
    }

    public String getActiveFileName() {
        String activeFileName = null;
        ByteBlowerResource activeResource = this.getActiveResource();
        if (activeResource != null) {
            activeFileName = activeResource.getURI().toFileString();
        }
        return activeFileName;
    }

    public String getActiveFileNameLastSegment() {
        String lastSegment = null;
        ByteBlowerResource activeResource = this.getActiveResource();
        if (activeResource != null) {
            lastSegment = URI.decode((String)activeResource.getURI().lastSegment());
        }
        return lastSegment;
    }

    private boolean closeActiveProject() {
        if (!this.isOpen()) {
            System.out.println("NO NEED TO CLOSE");
            return true;
        }
        ByteBlowerResource activeResource = this.getActiveResource();
        this.close(activeResource);
        this.setCurrentProject(null, null);
        this.configurationManager.setProject(null);
        this.tellOpenCloseListeners();
        return true;
    }

    public ByteBlowerResource openProject(String filename, IProgressMonitor progressMonitor) {
        if (this.isOpen()) {
            System.out.println("The current project should be closed before opening a new one !");
            return null;
        }
        return super.openProject(filename, progressMonitor);
    }

    public void refreshDone() {
        this.configurationManager.unsetRefreshListener();
        IUndoContext undoContext = this.getUndoContext();
        this.byteBlowerHistoryListener.saveState(undoContext);
    }
}

