/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.refresher;

import com.excentis.products.byteblower.communication.api.Capability;
import com.excentis.products.byteblower.communication.api.CapabilityList;
import com.excentis.products.byteblower.communication.api.CapabilityValue;
import com.excentis.products.byteblower.communication.api.DeviceInfo;
import com.excentis.products.byteblower.communication.api.DeviceOsType;
import com.excentis.products.byteblower.communication.api.DeviceStatus;
import com.excentis.products.byteblower.communication.api.LinkStatus;
import com.excentis.products.byteblower.communication.api.LinkType;
import com.excentis.products.byteblower.communication.api.NetworkInfo;
import com.excentis.products.byteblower.communication.api.NetworkInterface;
import com.excentis.products.byteblower.communication.api.PhysicalInterfaceList;
import com.excentis.products.byteblower.communication.api.PhysicalInterfaceType;
import com.excentis.products.byteblower.communication.api.TechnicalError;
import com.excentis.products.byteblower.communication.api.WirelessEndpoint;
import com.excentis.products.byteblower.gui.history.operations.server.UndoableByteBlowerConfigurationOperation;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.refresher.IRefreshListener;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigResources;
import com.excentis.products.byteblower.gui.refresher.RefreshConfigurationJob;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.ByteBlowerServerType;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortConfigurationController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.AbstractServerController;
import com.excentis.products.byteblower.model.control.server.CapabilityController;
import com.excentis.products.byteblower.model.control.server.DockedByteBlowerPortController;
import com.excentis.products.byteblower.model.control.server.MeetingPointController;
import com.excentis.products.byteblower.model.control.server.MobileDeviceController;
import com.excentis.products.byteblower.model.control.server.MobileInterfaceController;
import com.excentis.products.byteblower.model.control.server.PhysicalConfigurationController;
import com.excentis.products.byteblower.model.control.server.PhysicalDockableController;
import com.excentis.products.byteblower.model.control.server.PhysicalInterfaceController;
import com.excentis.products.byteblower.model.control.server.PhysicalPortController;
import com.excentis.products.byteblower.model.control.server.PhysicalServerController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.AbstractServerReader;
import com.excentis.products.byteblower.model.reader.server.CapabilityReader;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalConfigurationReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalDockableReader;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.InterfaceLinkStatus;
import com.excentis.products.byteblower.server.model.InterfaceType;
import com.excentis.products.byteblower.server.model.MobileInterface;
import com.excentis.products.byteblower.server.model.MobileType;
import com.excentis.products.byteblower.server.model.PhysicalConfiguration;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalInterface;
import com.excentis.products.byteblower.server.model.PhysicalMobileDevice;
import com.excentis.products.byteblower.server.model.PhysicalPort;
import com.excentis.products.byteblower.server.model.PortLinkStatus;
import com.excentis.products.byteblower.server.model.ServerLinkStatus;
import com.excentis.products.byteblower.utils.DeviceIPv6InterfaceAddress;
import com.excentis.products.byteblower.utils.Pair;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PhysicalConfigurationManager {
    static final Logger LOGGER = Logger.getGlobal();
    private static final PhysicalConfigurationManager instance = new PhysicalConfigurationManager();
    private static final int CONNECTION_TIMEOUT = 3;
    private static final int SERVER_PORT = 9002;
    private static final int MEETING_POINT_PORT = 9101;
    private IRefreshListener refreshListener;

    private PhysicalConfigurationManager() {
        Job initJob = new Job("Init server config"){

            protected IStatus run(IProgressMonitor monitor) {
                PhysicalConfigResources.initialize();
                return Status.OK_STATUS;
            }
        };
        initJob.schedule();
    }

    public static PhysicalConfigurationManager getInstance() {
        return instance;
    }

    void close() throws InterruptedException {
        try {
            PhysicalConfigResources.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not cleanly close " + this.getClass().getName(), e);
        }
    }

    public PhysicalConfiguration getPhysicalConfiguration() {
        return PhysicalConfigResources.physicalConfiguration;
    }

    public PhysicalConfigurationReader getPhysicalConfigurationReader() {
        return ReaderFactory.create((PhysicalConfiguration)this.getPhysicalConfiguration());
    }

    public PhysicalConfigurationController getPhysicalConfigurationController() {
        return ControllerFactory.create((PhysicalConfiguration)this.getPhysicalConfiguration());
    }

    /*
     * Exception decompiling
     */
    Command refreshServer(AbstractServerReader<?> server, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private MeetingPointController resolveMeetingPoint(IProgressMonitor monitor, String serverAddress, String serverLocalName, CompoundCommandController compound, PhysicalConfigurationController configController, MeetingPointController meetingPointController) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MeetingPointController addMeetingPointController(String serverAddress, String serverLocalName, CompoundCommandController compound, PhysicalConfigurationController configController) {
        PhysicalConfigurationController.CommandWithMeetingPointReference ref = configController.addMeetingPoint();
        compound.appendCommand(ref.getCommand());
        MeetingPointController meetingPointController = (MeetingPointController)ref.getCommandReference();
        compound.appendCommand(meetingPointController.createSetAddressCommand(serverAddress));
        String meetingPointName = serverLocalName;
        if (meetingPointName.equals("ByteBlower Server")) {
            meetingPointName = "Meeting Point";
        }
        compound.appendCommand(meetingPointController.createSetLocalNameCommand(meetingPointName));
        return meetingPointController;
    }

    private Command refreshProjectObjects(AbstractServerController<?> controller) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(this.refreshAllDockedPorts(controller));
        compound.appendCommand(this.refreshAllDockedPortConfigurations(controller));
        return compound.getCompoundCommand();
    }

    private Command refreshAllDockedPortConfigurations(AbstractServerController<?> controller) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (DockedByteBlowerPortReader reader : controller.getAllDockedPortReaders()) {
            ByteBlowerGuiPortConfiguration portConfig = reader.getByteBlowerGuiPortConfiguration();
            ByteBlowerGuiPortConfigurationController ctrl = ControllerFactory.create((ByteBlowerGuiPortConfiguration)portConfig);
            compound.appendCommand(ctrl.createSetStatusUnknownCommand());
        }
        return compound.getCompoundCommand();
    }

    private Command refreshAllDockedPorts(AbstractServerController<?> server) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        Collection controllers = server.getAllDockedPortControllers();
        for (DockedByteBlowerPortController controller : controllers) {
            compound.appendCommand(controller.createSetStatusUnknownCommand());
        }
        return compound.getCompoundCommand();
    }

    private Command markServerUnusable(PhysicalServerController controller, ServerLinkStatus serverStatus, InterfaceLinkStatus interfaceStatus, PortLinkStatus portStatus) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(controller.setServerLinkStatus(serverStatus));
        for (PhysicalInterfaceController interfaceController : controller.getPhysicalInterfaceControllers()) {
            compound.appendCommand(interfaceController.setInterfaceLinkStatus(interfaceStatus));
            for (PhysicalPortController portController : interfaceController.getPhysicalPortControllers()) {
                compound.appendCommand(portController.setPortLinkStatus(portStatus));
            }
        }
        compound.appendCommand(this.refreshProjectObjects((AbstractServerController<?>)controller));
        return compound.getCompoundCommand();
    }

    private Command markServerUnusable(MeetingPointController controller, ServerLinkStatus serverStatus, InterfaceLinkStatus interfaceStatus) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(controller.setServerLinkStatus(serverStatus));
        for (MobileDeviceController mobileDeviceController : controller.getMobileDeviceControllers()) {
            compound.appendCommand(mobileDeviceController.setLinkStatus(interfaceStatus));
        }
        compound.appendCommand(this.refreshProjectObjects((AbstractServerController<?>)controller));
        return compound.getCompoundCommand();
    }

    private Command markServerIncompatible(PhysicalServerController controller) {
        return this.markServerUnusable(controller, ServerLinkStatus.INCOMPATIBLE_VERSION, InterfaceLinkStatus.OFFLINE, PortLinkStatus.OFFLINE);
    }

    private Command markServerIncompatible(MeetingPointController controller) {
        return this.markServerUnusable(controller, ServerLinkStatus.INCOMPATIBLE_VERSION, InterfaceLinkStatus.OFFLINE);
    }

    private Command markServerOffline(PhysicalServerController controller) {
        return this.markServerUnusable(controller, ServerLinkStatus.OFFLINE, InterfaceLinkStatus.OFFLINE, PortLinkStatus.OFFLINE);
    }

    private Command markServerOffline(MeetingPointController controller) {
        return this.markServerUnusable(controller, ServerLinkStatus.OFFLINE, InterfaceLinkStatus.OFFLINE);
    }

    private Command refreshMobileDevices(MeetingPointController controller, List<WirelessEndpoint> apiMobileDevices) {
        MobileDeviceController mobileDeviceController;
        CompoundCommandController compound = CompoundCommandController.createInstance();
        HashSet<String> connectedDeviceIds = new HashSet<String>();
        for (WirelessEndpoint apiMobileDevice : apiMobileDevices) {
            String id = apiMobileDevice.DeviceIdentifierGet();
            connectedDeviceIds.add(id);
            mobileDeviceController = controller.getMobileDeviceController(id);
            if (mobileDeviceController == null) {
                PhysicalConfigurationController.CommandWithMobileDeviceReference ref = controller.createAddMobileDeviceCommand(id);
                compound.appendCommand(ref.getCommand());
                mobileDeviceController = (MobileDeviceController)ref.getCommandReference();
            }
            compound.appendCommand(this.refreshMobileDevice(mobileDeviceController, apiMobileDevice));
        }
        EList alreadyKnowDevices = controller.getMobileDevices();
        for (PhysicalMobileDevice device : alreadyKnowDevices) {
            if (connectedDeviceIds.contains(device.getId())) continue;
            mobileDeviceController = ControllerFactory.create((PhysicalMobileDevice)device);
            compound.appendCommand(mobileDeviceController.undock());
            compound.appendCommand(controller.deleteMobileDevice(device));
        }
        return compound.unwrap();
    }

    private MobileType convertType(DeviceOsType apiMobileType) {
        if (apiMobileType == DeviceOsType.Android) {
            return MobileType.ANDROID;
        }
        if (apiMobileType == DeviceOsType.iOS) {
            return MobileType.IOS;
        }
        if (apiMobileType == DeviceOsType.Linux) {
            return MobileType.LINUX;
        }
        if (apiMobileType == DeviceOsType.OSx) {
            return MobileType.OSX;
        }
        if (apiMobileType == DeviceOsType.Windows) {
            return MobileType.WINDOWS;
        }
        return MobileType.UNKNOWN;
    }

    private Command refreshMobileDevice(MobileDeviceController mobileDeviceController, WirelessEndpoint apiMobileDevice) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        boolean locked = apiMobileDevice.LockGet();
        compound.appendCommand(mobileDeviceController.setIsLocked(locked));
        boolean lockIsOwner = apiMobileDevice.LockIsOwner();
        compound.appendCommand(mobileDeviceController.setLockIsOwner(lockIsOwner));
        DeviceStatus deviceState = apiMobileDevice.StatusGet();
        InterfaceLinkStatus translatedLink = DeviceStatus.Available == deviceState ? InterfaceLinkStatus.ONLINE : (DeviceStatus.Reserved == deviceState ? (lockIsOwner ? InterfaceLinkStatus.USER_RESERVED : InterfaceLinkStatus.OTHER_USER_RESERVED) : (DeviceStatus.Running == deviceState ? (lockIsOwner ? InterfaceLinkStatus.TEST_RUNNING : InterfaceLinkStatus.OTHER_TEST_RUNNING) : (DeviceStatus.Unavailable == deviceState ? InterfaceLinkStatus.OFFLINE : InterfaceLinkStatus.UNKNOWN)));
        compound.appendCommand(mobileDeviceController.setLinkStatus(translatedLink));
        String lockOwner = apiMobileDevice.LockOwnerGet();
        compound.appendCommand(mobileDeviceController.setLockOwner(lockOwner));
        DeviceInfo deviceInfo = apiMobileDevice.DeviceInfoGet();
        String givenName = deviceInfo.GivenNameGet();
        compound.appendCommand(mobileDeviceController.createSetNameCommand(givenName));
        String deviceId = apiMobileDevice.DeviceIdentifierGet();
        compound.appendCommand(mobileDeviceController.setId(deviceId));
        compound.appendCommand(this.checkCapabilities((PhysicalDockableController<?>)mobileDeviceController, apiMobileDevice.CapabilityListGet()));
        DeviceOsType apiType = deviceInfo.OsTypeGet();
        MobileType type = this.convertType(apiType);
        compound.appendCommand(mobileDeviceController.setType(type));
        String osVersion = deviceInfo.OsVersionGet();
        compound.appendCommand(mobileDeviceController.setOsVersion(osVersion));
        String deviceType = deviceInfo.TypeGet();
        compound.appendCommand(mobileDeviceController.setDeviceType(deviceType));
        long batteryLevel = deviceInfo.BatteryLevelGet();
        compound.appendCommand(mobileDeviceController.setBatteryLevel(batteryLevel));
        String appVersion = apiMobileDevice.AppVersionGet();
        compound.appendCommand(mobileDeviceController.setMobileAppVersion(appVersion));
        NetworkInfo networkInfo = apiMobileDevice.DeviceInfoGet().NetworkInfoGet();
        compound.appendCommand(mobileDeviceController.removeInterfaces());
        for (NetworkInterface apiIfs : networkInfo.InterfaceGet()) {
            MobileInterface netInterface = MobileInterfaceController.create();
            netInterface.setDisplayName(apiIfs.DisplayNameGet());
            netInterface.setName(apiIfs.NameGet());
            netInterface.setMacAddress(apiIfs.MacGet());
            netInterface.setLinkStatus(InterfaceLinkStatus.ONLINE);
            for (String ipv4String : apiIfs.IPv4Get()) {
                try {
                    Inet4Address addr = (Inet4Address)Inet4Address.getByName(ipv4String);
                    netInterface.getIpv4Addresses().add((Object)addr);
                }
                catch (UnknownHostException ex) {
                    LOGGER.log(Level.SEVERE, "Received invalid IPv4 addresses from the API: " + ipv4String, ex);
                }
            }
            ArrayList ipv6s = new ArrayList();
            ipv6s.addAll(apiIfs.IPv6GlobalGet());
            ipv6s.addAll(apiIfs.IPv6LinkLocalGet());
            for (String ipv6String : ipv6s) {
                try {
                    netInterface.getIpv6Addresses().add((Object)new DeviceIPv6InterfaceAddress(ipv6String));
                }
                catch (UnknownHostException ex) {
                    LOGGER.log(Level.SEVERE, "Received invalid IPv6 addresses from the API: " + ipv6String, ex);
                }
            }
            compound.appendCommand(mobileDeviceController.addInterfaces(netInterface));
        }
        compound.appendCommand(mobileDeviceController.refreshPorts());
        return compound.unwrap();
    }

    private Command checkCapabilities(PhysicalDockableController<?> dockable, CapabilityList refreshedCapabilities) {
        CompoundCommandController commands = CompoundCommandController.createInstance();
        HashSet<String> origCaps = new HashSet<String>();
        HashSet<String> newCaps = new HashSet<String>();
        for (Capability newCapability : refreshedCapabilities) {
            newCaps.add(newCapability.NameGet());
        }
        for (CapabilityReader oldCap : dockable.getCapabilities()) {
            origCaps.add(oldCap.capName());
        }
        commands.appendCommand(dockable.removeAllCapabilities());
        for (Capability newCapability : refreshedCapabilities) {
            com.excentis.products.byteblower.server.model.Capability cap;
            String capName = newCapability.NameGet();
            String description = newCapability.DescriptionGet();
            CapabilityValue value = newCapability.ValueGet();
            if (CapabilityValue.Type.BOOLEAN.equals(value.TypeGet())) {
                cap = CapabilityController.create((String)capName, (String)description, (long)(value.BooleanGet() ? 1 : 0));
            } else if (CapabilityValue.Type.INTEGER.equals(value.TypeGet())) {
                cap = CapabilityController.create((String)capName, (String)description, (long)value.IntegerGet());
            } else if (CapabilityValue.Type.STRING.equals(value.TypeGet())) {
                cap = CapabilityController.create((String)capName, (String)description, (String)value.StringGet());
            } else {
                throw new RuntimeException("Invalid types:" + value.TypeGet());
            }
            commands.appendCommand(dockable.addCapability(cap));
        }
        return commands.unwrap();
    }

    private Command refreshPhysicalInterfaces(PhysicalServerController physicalServerController, PhysicalInterfaceList apiPhysicalInterfaces) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        int apiSize = apiPhysicalInterfaces.size();
        int i = 0;
        while (i < apiSize) {
            com.excentis.products.byteblower.communication.api.PhysicalInterface apiPhysicalInterface = apiPhysicalInterfaces.get(i);
            String physicalInterfaceId = Integer.toString(apiPhysicalInterface.IdGet());
            PhysicalInterfaceController interfaceController = physicalServerController.getPhysicalInterfaceController(physicalInterfaceId);
            if (interfaceController == null) {
                PhysicalServerController.CommandWithPhysicalInterfaceListReference ref = physicalServerController.addPhysicalInterface(physicalInterfaceId);
                compound.appendCommand(ref.getCommand());
                interfaceController = (PhysicalInterfaceController)((List)ref.getCommandReference()).get(0);
            }
            compound.appendCommand(this.refreshPhysicalInterface(interfaceController, apiPhysicalInterface));
            ++i;
        }
        int size = physicalServerController.getNofInterfaces();
        if (size > apiSize) {
            EList presentInterfaces = physicalServerController.getPhysicalInterfaces();
            int i2 = apiSize;
            while (i2 < size) {
                PhysicalInterface badPhysicalInterface = (PhysicalInterface)presentInterfaces.get(i2);
                PhysicalInterfaceController interfaceController = physicalServerController.getPhysicalInterfaceController(Integer.toString(i2));
                compound.appendCommand(interfaceController.undock());
                compound.appendCommand(physicalServerController.deletePhysicalInterface(badPhysicalInterface));
                ++i2;
            }
        }
        return compound.unwrap();
    }

    /*
     * Unable to fully structure code
     */
    private Command refreshPhysicalInterface(PhysicalInterfaceController interfaceController, com.excentis.products.byteblower.communication.api.PhysicalInterface apiPhysicalInterface) {
        block6: {
            compound = CompoundCommandController.createInstance();
            apiLinkStatus = apiPhysicalInterface.LinkStatusGet();
            linkStatus = this.createLinkStatus(apiLinkStatus);
            compound.appendCommand(interfaceController.setInterfaceLinkStatus(linkStatus));
            apiLinkType = apiPhysicalInterface.LinkTypeGet();
            linkType = this.createLinkType(apiLinkType);
            compound.appendCommand(interfaceController.setLinkType(linkType));
            mac = apiPhysicalInterface.MacAddressGet();
            compound.appendCommand(interfaceController.setMacAddress(mac));
            id = apiPhysicalInterface.IdGet();
            interfaceId = Integer.toString(id);
            compound.appendCommand(interfaceController.setId(interfaceId));
            name = "Interface " + (id + 1);
            compound.appendCommand(interfaceController.createSetNameCommand(name));
            productName = apiPhysicalInterface.ProductNameGet();
            compound.appendCommand(interfaceController.setProductName(productName));
            type = apiPhysicalInterface.TypeGet();
            interfaceType = this.createInterfaceType(type);
            originalType = interfaceController.getInterfaceType();
            if (!originalType.equals((Object)interfaceType)) {
                compound.appendCommand(interfaceController.setInterfaceType(interfaceType));
                compound.appendCommand(interfaceController.undock());
            }
            vendorName = apiPhysicalInterface.VendorNameGet();
            compound.appendCommand(interfaceController.setVendorName(vendorName));
            nofPorts = 0;
            if (type == PhysicalInterfaceType.Trunk) {
                nofPorts = (int)apiPhysicalInterface.ByteBlowerInterfaceCountGet();
            }
            compound.appendCommand(this.refreshPhysicalPorts(interfaceController, nofPorts, apiPhysicalInterface));
            try {
                server = apiPhysicalInterface.GetByteBlowerServer();
                capabilities = server.PortCreate(apiPhysicalInterface, 1).CapabilityListGet();
                compound.appendCommand(this.checkCapabilities((PhysicalDockableController<?>)interfaceController, capabilities));
            }
            catch (TechnicalError e) {
                compound.appendCommand(interfaceController.removeAllCapabilities());
                var22_23 = CapabilityReader.TYPE.values();
                var21_24 = var22_23.length;
                var20_25 = 0;
                ** while (var20_25 < var21_24)
            }
lbl-1000:
            // 1 sources

            {
                capType = var22_23[var20_25];
                cmd = interfaceController.addCapability(CapabilityController.create((String)capType.name, (String)"", (long)1L));
                compound.appendCommand(cmd);
                ++var20_25;
                continue;
            }
lbl45:
            // 1 sources

            PhysicalConfigurationManager.LOGGER.log(Level.INFO, "Server doesn't support fetching capabilities", e);
            break block6;
            catch (Exception e) {
                PhysicalConfigurationManager.LOGGER.log(Level.SEVERE, "Server doesn't support fetching capabilities", e);
            }
        }
        return compound.unwrap();
    }

    private InterfaceLinkStatus createLinkStatus(LinkStatus apiLinkStatus) {
        if (apiLinkStatus == LinkStatus.Offline) {
            return InterfaceLinkStatus.OFFLINE;
        }
        if (apiLinkStatus == LinkStatus.Online) {
            return InterfaceLinkStatus.ONLINE;
        }
        if (apiLinkStatus == LinkStatus.Unknown) {
            return InterfaceLinkStatus.UNKNOWN;
        }
        if (apiLinkStatus == LinkStatus.Unplugged) {
            return InterfaceLinkStatus.UNPLUGGED;
        }
        LOGGER.info("UNSUPPORTED LINK STATUS TYPE !");
        return null;
    }

    private com.excentis.products.byteblower.server.model.LinkType createLinkType(LinkType apiLinkType) {
        if (apiLinkType == LinkType.Ethernet) {
            return com.excentis.products.byteblower.server.model.LinkType.ETHERNET;
        }
        if (apiLinkType == LinkType.USB) {
            return com.excentis.products.byteblower.server.model.LinkType.USB;
        }
        LOGGER.info("UNSUPPORTED LINK TYPE !");
        return null;
    }

    private InterfaceType createInterfaceType(PhysicalInterfaceType type) {
        if (type == PhysicalInterfaceType.Trunk) {
            return InterfaceType.TRUNKING;
        }
        if (type == PhysicalInterfaceType.NonTrunk) {
            return InterfaceType.NONTRUNKING;
        }
        if (type == PhysicalInterfaceType.NonTrunkUSB) {
            return InterfaceType.USB;
        }
        LOGGER.info("UNSUPPORTED INTERFACE TYPE !");
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Command refreshPhysicalPorts(PhysicalInterfaceController interfaceController, int nofPorts, com.excentis.products.byteblower.communication.api.PhysicalInterface apiPhysicalInterface) {
        block12: {
            compound = CompoundCommandController.createInstance();
            insertIndex = -1;
            origControllers = interfaceController.getPhysicalPortControllers();
            newControllers = new ArrayList<PhysicalPortController>();
            if (interfaceController.getNofPhysicalPorts() == nofPorts) break block12;
            compound.appendCommand(interfaceController.deleteAllPhysicalPorts());
            i = 0;
            while (i < nofPorts) {
                block13: {
                    physicalPort = PhysicalPortController.create((int)i);
                    physicalPortController = new PhysicalPortController(physicalPort);
                    try {
                        server = apiPhysicalInterface.GetByteBlowerServer();
                        capabilities = server.PortCreate(apiPhysicalInterface, 1).CapabilityListGet();
                        compound.appendCommand(this.checkCapabilities((PhysicalDockableController<?>)physicalPortController, capabilities));
                    }
                    catch (TechnicalError e) {
                        compound.appendCommand(physicalPortController.removeAllCapabilities());
                        var15_26 = CapabilityReader.TYPE.values();
                        var14_24 = var15_26.length;
                        var13_20 = 0;
                        ** while (var13_20 < var14_24)
                    }
lbl-1000:
                    // 1 sources

                    {
                        capType = var15_26[var13_20];
                        cmd = physicalPortController.addCapability(CapabilityController.create((String)capType.name, (String)"", (long)1L));
                        compound.appendCommand(cmd);
                        ++var13_20;
                        continue;
                    }
lbl27:
                    // 1 sources

                    PhysicalConfigurationManager.LOGGER.log(Level.INFO, "Server doesn't support fetching capabilities", e);
                    break block13;
                    catch (Exception e) {
                        PhysicalConfigurationManager.LOGGER.log(Level.SEVERE, "Server doesn't support fetching capabilities", e);
                    }
                }
                physicalPort.setPortLinkStatus(PortLinkStatus.ONLINE);
                newControllers.add(ControllerFactory.create((PhysicalPort)physicalPort));
                compound.appendCommand(interfaceController.createAddCommand(physicalPort, insertIndex));
                ++i;
            }
            trunking = nofPorts > 0;
            for (PhysicalPortController origPort : origControllers) {
                dockedPorts = origPort.getAllDockedPorts();
                if (dockedPorts.isEmpty()) continue;
                id = origPort.getPortId();
                if (trunking && id < newControllers.size()) {
                    newController = (PhysicalPortController)newControllers.get(id);
                    compound.appendCommand(newController.createAddDockedPortsCommand(dockedPorts));
                    continue;
                }
                compound.appendCommand(origPort.undock());
            }
        }
        for (PhysicalPortController portController : interfaceController.getPhysicalPortControllers()) {
            compound.appendCommand(portController.setPortLinkStatus(PortLinkStatus.ONLINE));
            try {
                server = apiPhysicalInterface.GetByteBlowerServer();
                capabilities = server.PortCreate(apiPhysicalInterface, 1).CapabilityListGet();
                compound.appendCommand(this.checkCapabilities((PhysicalDockableController<?>)portController, capabilities));
                continue;
            }
            catch (TechnicalError e) {
                compound.appendCommand(portController.removeAllCapabilities());
                var14_25 = CapabilityReader.TYPE.values();
                var13_23 = var14_25.length;
                var12_19 = 0;
                ** while (var12_19 < var13_23)
            }
lbl-1000:
            // 1 sources

            {
                capType = var14_25[var12_19];
                cmd = portController.addCapability(CapabilityController.create((String)capType.name, (String)"", (long)1L));
                compound.appendCommand(cmd);
                ++var12_19;
                continue;
            }
lbl68:
            // 1 sources

            PhysicalConfigurationManager.LOGGER.log(Level.INFO, "Server doesn't support fetching capabilities", e);
            continue;
            catch (Exception e) {
                PhysicalConfigurationManager.LOGGER.log(Level.SEVERE, "Server doesn't support fetching capabilities", e);
            }
        }
        return compound.unwrap();
    }

    public void setProject(ByteBlowerProjectReader activeProjectReader) {
        if (activeProjectReader == null) {
            this.clearDockedPorts();
        } else {
            this.autoDock(activeProjectReader);
            this.autoRefresh(activeProjectReader);
            this.autoUndock(activeProjectReader);
        }
    }

    private void autoUndock(ByteBlowerProjectReader activeProjectReader) {
        Command command = this.createAutoUndockCommand(activeProjectReader);
        UndoableByteBlowerConfigurationOperation op = new UndoableByteBlowerConfigurationOperation("Auto Undock", command);
        op.run();
    }

    private Command createAutoUndockCommand(ByteBlowerProjectReader activeProjectReader) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        PhysicalConfigurationController controller = this.getPhysicalConfigurationController();
        for (ByteBlowerGuiPortReader reader : activeProjectReader.getByteBlowerGuiPortReaders()) {
            PhysicalInterface dockedInterface;
            PhysicalInterfaceController interfaceController;
            if (!reader.isDocked()) continue;
            PhysicalDockable physicalDockable = controller.getPhysicalDockable(reader);
            if (physicalDockable == null) {
                LOGGER.warning("createAutoUndockCommand - PhysicalDockable should never be null here !");
            }
            if (!(physicalDockable instanceof PhysicalInterface) || (interfaceController = ControllerFactory.create((PhysicalInterface)(dockedInterface = (PhysicalInterface)physicalDockable))).getInterfaceType() != InterfaceType.TRUNKING) continue;
            compound.appendCommand(interfaceController.undock(reader.getByteBlowerGuiPortConfiguration()));
        }
        return compound.getCompoundCommand();
    }

    private void clearDockedPorts() {
        CompoundCommand command = this.getPhysicalConfigurationController().clear();
        UndoableByteBlowerConfigurationOperation op = new UndoableByteBlowerConfigurationOperation("Cleanup Docked Ports", (Command)command);
        op.runWithoutHistory();
    }

    private void autoRefresh(ByteBlowerProjectReader activeProjectReader) {
        PhysicalConfigurationController controller = this.getPhysicalConfigurationController();
        ArrayList list = new ArrayList();
        for (String serverAddress : activeProjectReader.getUsedServerAddresses()) {
            PhysicalServerController bb = controller.getPhysicalServerController(serverAddress);
            MeetingPointController mp = controller.getMeetingPointController(serverAddress);
            if (bb != null) {
                list.add((AbstractServerController<?>)bb);
            }
            if (mp == null) continue;
            list.add((AbstractServerController<?>)mp);
        }
        this.refreshJob(list);
    }

    public void refreshJob(AbstractServerController<?> serverController) {
        ArrayList list = new ArrayList();
        list.add(serverController);
        this.refreshJob(list);
    }

    public void refreshJob(final List<AbstractServerController<?>> selectedServers) {
        final RefreshConfigurationJob job = RefreshConfigurationJob.refresh(selectedServers);
        if (this.refreshListener != null) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (PhysicalConfigurationManager.this.refreshListener != null) {
                        PhysicalConfigurationManager.this.refreshListener.refreshDone();
                        job.removeJobChangeListener((IJobChangeListener)this);
                    }
                }
            });
        }
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                job.removeJobChangeListener((IJobChangeListener)this);
                for (AbstractServerController controller : selectedServers) {
                    if (!controller.hasUpdateAvailable()) continue;
                    String type = controller.getServerType();
                    String latestVersion = controller.getLatestVersion().toString();
                    String popuppedVersion = ByteBlowerPreferences.getPopuppedVersion((String)type);
                    if (latestVersion == null || latestVersion.equals(popuppedVersion)) continue;
                    ByteBlowerPreferences.setPopuppedVersion((String)type, (String)latestVersion);
                    final String message = "New Server version available !\nUpdate your ByteBlower " + type + " servers to version " + latestVersion;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                            int index = MessageDialog.open((int)2, (Shell)shell, (String)"New Server Version", (String)message, (int)0, (String[])new String[]{"Help", "Close"});
                            if (index == 0) {
                                try {
                                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("https://support.excentis.com/index.php?/Knowledgebase/Article/View/how-to-update-a-byteblower-server"));
                                }
                                catch (PartInitException e) {
                                    e.printStackTrace();
                                }
                                catch (MalformedURLException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                }
            }
        });
        job.schedule();
    }

    public void autoDock(ByteBlowerProjectReader activeProjectReader) {
        Command command = this.createAutoDockCommand(activeProjectReader);
        UndoableByteBlowerConfigurationOperation op = new UndoableByteBlowerConfigurationOperation("Auto Dock", command);
        op.run();
    }

    private Command createAutoDockCommand(ByteBlowerProjectReader activeProjectReader) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        PhysicalConfigurationController controller = this.getPhysicalConfigurationController();
        for (ByteBlowerGuiPortReader reader : activeProjectReader.getByteBlowerGuiPortReaders()) {
            DockedByteBlowerPort dockedPort;
            if (!reader.isDocked()) continue;
            PhysicalDockable physicalDockable = controller.getPhysicalDockable(reader);
            if (physicalDockable == null) {
                Pair<PhysicalDockable, CompoundCommand> pair = this.createGhostDockable(reader);
                physicalDockable = (PhysicalDockable)pair.getFirst();
                compound.appendCommand((Command)pair.getSecond());
            }
            if (physicalDockable == null) {
                LOGGER.info("PhysicalDockable should never be null here !");
            }
            if ((dockedPort = controller.getDockedPort(reader)) != null) continue;
            compound.appendCommand(this.autoDock(physicalDockable, reader));
        }
        return compound.getCompoundCommand();
    }

    private Command autoDock(PhysicalDockable dockable, ByteBlowerGuiPortReader reader) {
        PhysicalDockableController dockableController = ControllerFactory.create((PhysicalDockable)dockable);
        ByteBlowerGuiPortConfiguration portConfig = reader.getByteBlowerGuiPortConfiguration();
        return dockableController.dock(portConfig);
    }

    private Pair<PhysicalDockable, CompoundCommand> createGhostDockable(ByteBlowerGuiPortReader reader) {
        PhysicalDockable newDockable;
        ByteBlowerGuiPortConfigurationReader configReader = reader.getByteBlowerGuiPortConfigurationReader();
        CompoundCommandController compound = CompoundCommandController.createInstance();
        PhysicalConfigurationController configurationController = this.getPhysicalConfigurationController();
        String serverAddress = configReader.getServerAddress();
        String interfaceId = configReader.getPhysicalInterfaceId();
        ByteBlowerServerType type = configReader.getServerType();
        MeetingPointController serverController = null;
        if (type == ByteBlowerServerType.MEETING_POINT) {
            MeetingPointController controller;
            MobileDeviceController mobileDeviceController;
            serverController = configurationController.getMeetingPointController(serverAddress);
            if (serverController == null) {
                PhysicalConfigurationController.CommandWithMeetingPointReference ref = configurationController.addMeetingPoint();
                compound.appendCommand(ref.getCommand());
                serverController = (AbstractServerController)ref.getCommandReference();
                compound.appendCommand(serverController.setLocalName("ByteBlower Server"));
                compound.appendCommand(serverController.createSetAddressCommand(serverAddress));
            }
            if ((mobileDeviceController = (controller = serverController).getMobileDeviceController(interfaceId)) == null) {
                PhysicalConfigurationController.CommandWithMobileDeviceReference ref = controller.createAddMobileDeviceCommand(interfaceId);
                mobileDeviceController = (MobileDeviceController)ref.getCommandReference();
                compound.appendCommand(ref.getCommand());
                compound.appendCommand(mobileDeviceController.setId(interfaceId));
                compound.appendCommand(mobileDeviceController.createSetNameCommand("Unknown Device"));
            }
            newDockable = (PhysicalDockable)mobileDeviceController.getObject();
        } else {
            boolean trunking;
            serverController = configurationController.getPhysicalServerController(serverAddress);
            if (serverController == null) {
                PhysicalConfigurationController.CommandWithPhysicalServerReference ref = configurationController.addPhysicalServer();
                compound.appendCommand(ref.getCommand());
                serverController = (AbstractServerController)ref.getCommandReference();
                compound.appendCommand(serverController.setLocalName("ByteBlower Server"));
                compound.appendCommand(serverController.createSetAddressCommand(serverAddress));
            }
            PhysicalServerController controller = (PhysicalServerController)serverController;
            PhysicalInterfaceController physicalInterfaceController = controller.getPhysicalInterfaceController(interfaceId);
            Integer portId = configReader.getPhysicalPortId();
            boolean bl = trunking = portId > -1;
            if (physicalInterfaceController == null) {
                PhysicalInterface physicalInterface = PhysicalInterfaceController.create();
                physicalInterfaceController = new PhysicalInterfaceController(physicalInterface);
                compound.appendCommand(controller.createAddCommand(physicalInterface));
                compound.appendCommand(physicalInterfaceController.setId(interfaceId));
                compound.appendCommand(physicalInterfaceController.createSetNameCommand("Interface " + interfaceId + 1));
                compound.appendCommand(physicalInterfaceController.setInterfaceType(trunking ? InterfaceType.TRUNKING : InterfaceType.NONTRUNKING));
            }
            if (!trunking) {
                newDockable = (PhysicalDockable)physicalInterfaceController.getObject();
            } else {
                PhysicalPortController physicalPortController = physicalInterfaceController.getPhysicalPortController(portId);
                if (physicalPortController == null) {
                    PhysicalPort physicalPort = PhysicalPortController.create((int)portId);
                    compound.appendCommand(physicalInterfaceController.createAddCommand(physicalPort));
                    newDockable = physicalPort;
                } else {
                    newDockable = (PhysicalDockable)physicalPortController.getObject();
                }
            }
        }
        compound.execute();
        return new Pair((Object)newDockable, (Object)compound.getCompoundCommand());
    }

    public List<AbstractServerController<?>> getUsedServerControllers(ByteBlowerProjectController controller) {
        List addresses = controller.getUsedServerAddresses();
        return this.getPhysicalConfigurationController().getServerControllers(addresses);
    }

    public boolean isAlreadyDocked(EList<ByteBlowerGuiPortReader> ports, EList<PhysicalDockable> dockables) {
        PhysicalConfigurationReader reader = this.getPhysicalConfigurationReader();
        for (ByteBlowerGuiPortReader portReader : ports) {
            PhysicalDockable physicalDockable = reader.getPhysicalDockable(portReader);
            if (physicalDockable == null) {
                return false;
            }
            boolean dockedHere = dockables.contains((Object)physicalDockable);
            if (dockedHere) continue;
            return false;
        }
        return true;
    }

    public void setRefreshListener(IRefreshListener listener) {
        this.refreshListener = listener;
    }

    public void unsetRefreshListener() {
        this.refreshListener = null;
    }

    public boolean hasDockingRoom(int neededCapacity, EList<PhysicalDockable> dockables) {
        int availableCapacity = 0;
        for (PhysicalDockable dockable : dockables) {
            PhysicalDockableReader reader = ReaderFactory.create((PhysicalDockable)dockable);
            int capacity = reader.getRemainingCapacity();
            if (capacity == -1) {
                return true;
            }
            availableCapacity += capacity;
        }
        return availableCapacity >= neededCapacity;
    }
}

