/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.refresher;

import com.excentis.products.byteblower.communication.api.ByteBlower;
import com.excentis.products.byteblower.gui.history.operations.server.UndoableByteBlowerConfigurationOperation;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.model.control.server.AbstractServerController;
import com.excentis.products.byteblower.model.reader.server.AbstractServerReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class RefreshConfigurationJob
extends Job {
    private static final RefreshConfigurationJob refreshJob = new RefreshConfigurationJob();
    private Set<AbstractServerController<?>> serverControllers = new HashSet();

    private RefreshConfigurationJob() {
        super("Refresh Servers");
    }

    static synchronized RefreshConfigurationJob refresh(List<AbstractServerController<?>> selectedServers) {
        refreshJob.addServers(selectedServers);
        return refreshJob;
    }

    static void cancelRunningJob() {
        refreshJob.cancel();
    }

    public static final boolean isRunning() {
        return refreshJob.getState() == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized IStatus run(IProgressMonitor monitor) {
        try {
            ByteBlower.InstanceGet();
            PhysicalConfigurationManager physicalManager = PhysicalConfigurationManager.getInstance();
            monitor.beginTask("Connecting to ByteBlower Server", -1);
            ArrayList toRefresh = new ArrayList();
            Set<AbstractServerController<?>> set = this.serverControllers;
            synchronized (set) {
                toRefresh.addAll(this.serverControllers);
                this.serverControllers.clear();
            }
            for (AbstractServerController abstractServerController : toRefresh) {
                if (abstractServerController == null || abstractServerController.objectIsNull()) continue;
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                String taskTitle = String.valueOf(abstractServerController.getLocalName()) + " (" + abstractServerController.getServerAddress() + ")";
                monitor.subTask(taskTitle);
                String operationName = abstractServerController.isAbstract() ? "Create Server" : "Refresh Server";
                final UndoableByteBlowerConfigurationOperation operation = new UndoableByteBlowerConfigurationOperation(operationName);
                operation.appendCommand(physicalManager.refreshServer((AbstractServerReader<?>)abstractServerController, monitor));
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null) {
                    workbench.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            operation.run();
                        }
                    });
                } else {
                    operation.run();
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServers(List<AbstractServerController<?>> newPhysicalServerControllers) {
        Set<AbstractServerController<?>> set = this.serverControllers;
        synchronized (set) {
            this.serverControllers.addAll(newPhysicalServerControllers);
        }
    }
}

