/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.runner;

import com.excentis.products.byteblower.bear.operations.Operation;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.runner.BackupGeneration;
import com.excentis.products.byteblower.gui.runner.HtmlReportOpener;
import com.excentis.products.byteblower.gui.runner.ReportGenerationJob;
import com.excentis.products.byteblower.gui.runner.RuntimeViewOpener;
import com.excentis.products.byteblower.gui.runner.ScenarioRotGraphsDisabledDialog;
import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.IOpenCloseListener;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import com.excentis.products.byteblower.report.ReportGenerator;
import com.excentis.products.byteblower.report.ReportPreferences;
import com.excentis.products.byteblower.report.generator.core.ReportExportedListener;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.runner.Runner;
import com.excentis.products.byteblower.runner.jobs.ExecuteBatchJob;
import com.excentis.products.byteblower.runner.jobs.ExecuteScenarioJob;
import com.excentis.products.byteblower.runner.jobs.ExecutionJob;
import com.excentis.products.byteblower.runner.jobs.IBatchJobListener;
import com.excentis.products.byteblower.utils.cloud.CloudStatusPoller;
import com.excentis.products.byteblower.utils.cloud.ExcentisCloudStatus;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GuiRunner
implements Runner.ActiveJobListener,
IOpenCloseListener {
    private static Logger LOGGER = Logger.getGlobal();
    private static GuiRunner instance = null;
    private Object recentScenarioWaitObj = new Object();
    private Object recentBatchWaitObj = new Object();
    private UniqueEList<Scenario> recentScenarioList = new UniqueEList();
    private UniqueEList<Batch> recentBatchList = new UniqueEList();
    private ExecuteScenarioJob activeScenarioJob;
    private final List<ActiveJobListener> listeners = new CopyOnWriteArrayList<ActiveJobListener>();
    private String runTitle = "";

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$utils$cloud$ExcentisCloudStatus = GuiRunner.$SWITCH_TABLE$com$excentis$products$byteblower$utils$cloud$ExcentisCloudStatus();
    }

    public static GuiRunner getInstance() {
        if (instance == null) {
            instance = new GuiRunner();
        }
        return instance;
    }

    private GuiRunner() {
        Runner.getInstance().addListener((Runner.ActiveJobListener)this);
        ReportGenerator.getInstance().addReportExportedListener((ReportExportedListener)new HtmlReportOpener());
        ProjectSwitchNotifier.getInstance().addOpenCloseListener((IOpenCloseListener)this);
    }

    public boolean isRunning() {
        return Runner.getInstance().isRunning();
    }

    public ExecuteScenarioJob getActiveScenarioJob() {
        return this.activeScenarioJob;
    }

    public void onExecutionJobStart() {
        ExecutionJob executionJob = Runner.getInstance().getActiveJob();
        if (executionJob instanceof ExecuteScenarioJob) {
            this.setActiveScenarioJob((ExecuteScenarioJob)executionJob);
        }
    }

    public void onExecutionJobDone(boolean isNextInQueue) {
        this.setActiveScenarioJob(null);
    }

    private void setActiveScenarioJob(ExecuteScenarioJob scenarioJob) {
        this.activeScenarioJob = scenarioJob;
        for (ActiveJobListener listener : this.listeners) {
            listener.activeScenarioJobChanged();
        }
    }

    private boolean continueEvenWithCloudIssue() {
        ExcentisCloudStatus currentStatus;
        return !ByteBlowerPreferences.allowCloudFunctionality() || (currentStatus = CloudStatusPoller.getInstance().now().status()) != ExcentisCloudStatus.EC_UNREACHABLE && currentStatus != ExcentisCloudStatus.BAD_EC_CREDENTIALS && currentStatus != ExcentisCloudStatus.MISSING_EC_CLOUD_CONFIG || this.continueWithCloudWarning(currentStatus);
    }

    public void scheduleBatch(Batch batch) {
        this.updateRecentBatchList(batch);
        if (!this.continueEvenWithCloudIssue()) {
            return;
        }
        String xmlProjectString = this.getXmlProjectString();
        ExecuteBatchJob batchJob = new ExecuteBatchJob(xmlProjectString, batch.getName(), this.runTitle);
        batchJob.addBatchJobListener(new IBatchJobListener(){

            public void handleScenarioJobRunning(ExecuteScenarioJob scenarioJob) {
                GuiRunner.this.setActiveScenarioJob(scenarioJob);
                scenarioJob.addJobChangeListener((IJobChangeListener)new BackupGeneration(scenarioJob));
            }

            public void handleScenarioJobDone(ExecuteScenarioJob scenarioJob) {
                GuiRunner.this.generateReport(scenarioJob.getTestDataPersistenceId(), scenarioJob.getRunningModelProject());
                GuiRunner.this.setActiveScenarioJob(null);
            }

            public void handleBatchJobRunning(ExecuteBatchJob batchJob) {
            }

            public void handleBatchJobDone(ExecuteBatchJob batchJob) {
            }
        });
        batchJob.addJobChangeListener((IJobChangeListener)new RuntimeViewOpener());
        Runner.getInstance().scheduleExecutionJob((ExecutionJob)batchJob);
    }

    public void scheduleScenario(Scenario scenario) {
        this.updateRecentScenarioList(scenario);
        if (!this.continueEvenWithCloudIssue()) {
            return;
        }
        ScenarioReader reader = ReaderFactory.create((Scenario)scenario);
        if (reader.preventResultsOverTime() && ByteBlowerPreferences.getWarningNoRotEnabled()) {
            ScenarioRotGraphsDisabledDialog.open("Scenario Warning", "The scenario contains more than 100 flows.\nGraphs with results over time will be disabled.\n\nThe scenario will continue running after closing this message.");
        }
        String xmlProjectString = this.getXmlProjectString();
        ExecuteScenarioJob scenarioJob = new ExecuteScenarioJob(xmlProjectString, scenario.getName(), this.runTitle);
        ByteBlowerGuiResourceController controller = ByteBlowerGuiResourceController.getInstance();
        if (controller.getActiveProject().isScenarioPauseAfterDhcp()) {
            PauseOperation pause = new PauseOperation(scenario);
            scenarioJob.setPauseOperation("Waiting for user feedback", (Operation)pause);
        }
        scenarioJob.addJobChangeListener((IJobChangeListener)new ReportGeneration(scenario, scenarioJob));
        scenarioJob.addJobChangeListener((IJobChangeListener)new BackupGeneration(scenarioJob));
        scenarioJob.addJobChangeListener((IJobChangeListener)new RuntimeViewOpener());
        Runner.getInstance().scheduleExecutionJob((ExecutionJob)scenarioJob);
    }

    private boolean continueWithCloudWarning(ExcentisCloudStatus status) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        Shell shell = win.getShell();
        String title = "Excentis Cloud Warning";
        String message = "";
        switch (status) {
            case ALL_OK: {
                break;
            }
            case BAD_EC_CREDENTIALS: {
                message = "Invalid Credentials for " + ByteBlowerPreferences.getExcentisCloudUrl() + "\nPlease check your API key.";
                break;
            }
            case EC_UNREACHABLE: {
                message = String.valueOf(ByteBlowerPreferences.getExcentisCloudUrl()) + " is unreachable.";
                break;
            }
            case MISSING_EC_CLOUD_CONFIG: {
                message = "Incomplete cloud configuration for " + ByteBlowerPreferences.getExcentisCloudUrl();
                break;
            }
            case OPT_OUT_EC_CLOUD: {
                break;
            }
        }
        message = String.valueOf(message) + "\n\nYour test results will be stored locally.\nYou can upload them to Excentis Cloud later.";
        String[] buttonLabels = new String[]{"Continue Running", "Stop"};
        MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, buttonLabels, 0);
        int result = dialog.open();
        return result == 0;
    }

    private String getXmlProjectString() {
        ByteBlowerGuiResourceController controller = ByteBlowerGuiResourceController.getInstance();
        return controller.getActiveResourceAsXmlString();
    }

    public void addListener(ActiveJobListener listener) {
        this.listeners.add(listener);
    }

    private void generateReport(Long testDataPersistenceId, ByteBlowerProject project) {
        if (testDataPersistenceId == null) {
            return;
        }
        ReportPreferences reportPreferences = new ReportPreferences(project);
        ReportGenerationJob reportGenerationJob = new ReportGenerationJob(testDataPersistenceId, (ReportPreferencesInterface)reportPreferences);
        reportGenerationJob.schedule();
        try {
            reportGenerationJob.join();
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Report generation process failed", e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecentScenarioList(Scenario scenario) {
        Object object = this.recentScenarioWaitObj;
        synchronized (object) {
            this.recentScenarioList.add((Object)scenario);
            this.recentScenarioList.move(0, (Object)scenario);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecentBatchList(Batch batch) {
        Object object = this.recentBatchWaitObj;
        synchronized (object) {
            this.recentBatchList.add((Object)batch);
            this.recentBatchList.move(0, (Object)batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniqueEList<Scenario> getRecentScenarioList() {
        Object object = this.recentScenarioWaitObj;
        synchronized (object) {
            UniqueEList removedScenarios = new UniqueEList();
            for (Scenario scenario : this.recentScenarioList) {
                if (scenario.eContainer() != null) continue;
                removedScenarios.add((Object)scenario);
            }
            this.recentScenarioList.removeAll((Collection)removedScenarios);
        }
        return this.recentScenarioList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniqueEList<Batch> getRecentBatchList() {
        Object object = this.recentBatchWaitObj;
        synchronized (object) {
            UniqueEList removedBatches = new UniqueEList();
            for (Batch batch : this.recentBatchList) {
                if (batch.eContainer() != null) continue;
                removedBatches.add((Object)batch);
            }
            this.recentBatchList.removeAll((Collection)removedBatches);
        }
        return this.recentBatchList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scenario getMostRecentScenario() {
        Object object = this.recentScenarioWaitObj;
        synchronized (object) {
            for (Scenario scenario : this.getRecentScenarioList()) {
                if (scenario.eContainer() == null) continue;
                return scenario;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Batch getMostRecentBatch() {
        Object object = this.recentBatchWaitObj;
        synchronized (object) {
            for (Batch batch : this.getRecentBatchList()) {
                if (batch.eContainer() == null) continue;
                return batch;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectOpenedOrClosed(ByteBlowerProject project) {
        Object object = this.recentScenarioWaitObj;
        synchronized (object) {
            this.recentScenarioList.clear();
        }
        object = this.recentBatchWaitObj;
        synchronized (object) {
            this.recentBatchList.clear();
        }
    }

    public void setRunTitle(String runTitle) {
        this.runTitle = runTitle;
    }

    public String getRunTitle() {
        return this.runTitle;
    }

    public static interface ActiveJobListener {
        public void activeScenarioJobChanged();

        public void activeScenarioPaused(Resumer var1);

        public void activeScenarioResumed();
    }

    private class PauseOperation
    implements Operation,
    Resumer {
        private static final int SLEEP_TIME = 16;
        private AtomicBoolean canContinue = new AtomicBoolean(false);
        private Scenario scenario;

        public PauseOperation(Scenario scenario) {
            this.scenario = scenario;
        }

        @Override
        public void resume() {
            this.canContinue.set(true);
        }

        public void perform() throws Operation.IsRunningException, Operation.HasRunnedException {
            for (ActiveJobListener listener : GuiRunner.this.listeners) {
                listener.activeScenarioPaused(this);
            }
            while (!this.canContinue.get()) {
                try {
                    Thread.sleep(16L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.INFO, "Interrupted during sleep", e);
                    Thread.currentThread().interrupt();
                }
            }
            for (ActiveJobListener listener : GuiRunner.this.listeners) {
                listener.activeScenarioResumed();
            }
        }

        @Override
        public String currentScenario() {
            return this.scenario.getName();
        }
    }

    private final class ReportGeneration
    extends JobChangeAdapter {
        private final Scenario scenario;
        private final ExecuteScenarioJob scenarioJob;

        private ReportGeneration(Scenario scenario, ExecuteScenarioJob scenarioJob) {
            this.scenario = scenario;
            this.scenarioJob = scenarioJob;
        }

        public void running(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
            Long persistenceId = this.scenarioJob.getTestDataPersistenceId();
            if (persistenceId != null) {
                GuiRunner.this.generateReport(persistenceId, this.scenario.getByteBlowerProject());
            }
        }
    }

    public static interface Resumer {
        public void resume();

        public String currentScenario();
    }
}

