/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.runner;

import com.excentis.products.byteblower.report.ReportGenerator;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public final class ReportGenerationJob
extends Job {
    private final long testReference;
    private final ReportPreferencesInterface reportPreferences;

    public ReportGenerationJob(long testReference, ReportPreferencesInterface reportPreferences) {
        super("Generating report");
        this.testReference = testReference;
        this.reportPreferences = reportPreferences;
    }

    public long getTestReference() {
        return this.testReference;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Generating report", -1);
        try {
            ReportGenerator.getInstance().generateReport(Long.valueOf(this.testReference), this.reportPreferences, monitor);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            System.out.println("ReportGenerationJob::run : Failed to generate report : " + e);
            Status status = new Status(4, "com.excentis.products.byteblower.gui.report.viewer", "Failed to generate report", (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }
}

