/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.actions;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.model.control.undo.ByteBlowerMainUndoContext;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;

public class RedoAction
extends Action
implements IOperationHistoryListener {
    private static final IOperationHistory history = UndoableByteBlowerOperation.history;

    public RedoAction() {
        super("Redo");
        history.addOperationHistoryListener((IOperationHistoryListener)this);
        this.update();
    }

    private IUndoContext getContext() {
        return ByteBlowerMainUndoContext.instance;
    }

    public void run() {
        try {
            history.redo(this.getContext(), (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private boolean canRedo() {
        return history.canRedo(this.getContext());
    }

    public void historyNotification(OperationHistoryEvent event) {
        this.update();
    }

    private void update() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean canRedo = RedoAction.this.canRedo();
                RedoAction.this.setEnabled(canRedo);
                if (canRedo) {
                    IUndoableOperation redoOp = history.getRedoOperation(RedoAction.this.getContext());
                    if (redoOp == null) {
                        RedoAction.this.setText("Redo");
                    } else {
                        String label = redoOp.getLabel();
                        RedoAction.this.setText("Redo " + label);
                    }
                }
            }
        });
    }
}

