/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.actions;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.model.control.undo.ByteBlowerMainUndoContext;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;

public class UndoAction
extends Action
implements IOperationHistoryListener {
    private static final IOperationHistory history = UndoableByteBlowerOperation.history;

    public UndoAction() {
        super("Undo");
        history.addOperationHistoryListener((IOperationHistoryListener)this);
        this.update();
    }

    private IUndoContext getContext() {
        return ByteBlowerMainUndoContext.instance;
    }

    public void run() {
        try {
            history.undo(this.getContext(), (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private boolean canUndo() {
        return history.canUndo(this.getContext());
    }

    public void historyNotification(OperationHistoryEvent event) {
        this.update();
    }

    private void update() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean canUndo = UndoAction.this.canUndo();
                UndoAction.this.setEnabled(canUndo);
                if (canUndo) {
                    IUndoableOperation undoOp = history.getUndoOperation(UndoAction.this.getContext());
                    String label = undoOp.getLabel();
                    UndoAction.this.setText("Undo " + label);
                }
            }
        });
    }
}

