/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.actions.project;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerProjectAction;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.transfer.ByteBlowerTransfer;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import java.util.Collection;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;

public abstract class ByteBlowerCopyAction<TableObjectClass>
extends ByteBlowerProjectAction<TableObjectClass>
implements IAfterOperationListener {
    protected ByteBlowerPasteAction<TableObjectClass> pasteAction;

    public ByteBlowerCopyAction(String text, ByteBlowerViewerComposite<TableObjectClass> composite) {
        super(text, composite);
        this.pasteAction = composite.getPasteAction();
        this.single = text;
        this.multiple = String.valueOf(text) + "s";
    }

    public void afterOperation(UndoableByteBlowerOperation operation) {
        this.composite.viewerSelectionChanged(null);
    }

    public void update() {
        boolean enable = !this.getSelectedObjects().isEmpty();
        this.setEnabled(enable);
    }

    public void run() {
        StructuredViewer viewer = this.composite.getStructuredViewer();
        IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
        ColumnViewer view = (ColumnViewer)viewer;
        if (view.isCellEditorActive()) {
            CellEditor[] tt = view.getCellEditors();
            int i = 0;
            while (i < tt.length) {
                CellEditor t = tt[i];
                if (t.isActivated() && t.isCopyEnabled()) {
                    t.performCopy();
                    this.pasteAction.setEnabled(true);
                    return;
                }
                ++i;
            }
        } else {
            UniqueEList objects = new UniqueEList();
            for (Object object : sel) {
                if (!(object instanceof EByteBlowerObject)) continue;
                objects.add(object);
            }
            Clipboard clipboard = this.composite.getClipboard();
            Transfer[] transfer = new Transfer[]{ByteBlowerTransfer.getInstance(EByteBlowerObject.class)};
            Object[] objectArray = this.copyObjects((Collection<TableObjectClass>)objects);
            clipboard.setContents(objectArray, transfer);
            this.pasteAction.update();
        }
    }

    private final Object[] copyObjects(Collection<TableObjectClass> objects) {
        UniqueEList copiedObjects = new UniqueEList();
        for (TableObjectClass object : objects) {
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            EObject copy = EByteBlowercoreUtil.copy((EObject)eObject);
            if (copy instanceof EByteBlowerObject) {
                EByteBlowerObject bbObject = (EByteBlowerObject)copy;
                bbObject.getStatuses().clear();
            }
            copiedObjects.add((Object)copy);
        }
        Object[] array = copiedObjects.toArray((Object[])new EByteBlowerObject[objects.size()]);
        return new Object[]{array};
    }
}

