/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.server;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.composites.server.GraphicPassPrompt;
import com.excentis.products.byteblower.gui.swt.composites.server.IDockListener;
import com.excentis.products.byteblower.gui.swt.composites.server.IDocker;
import com.excentis.products.byteblower.gui.swt.composites.server.NoServerBoughtPopupMenu;
import com.excentis.products.byteblower.gui.swt.composites.server.ServerComparator;
import com.excentis.products.byteblower.gui.swt.composites.server.SupportToolJob;
import com.excentis.products.byteblower.gui.swt.composites.server.TooltipPicker;
import com.excentis.products.byteblower.gui.swt.composites.server.actions.DeleteServerAction;
import com.excentis.products.byteblower.gui.swt.composites.server.actions.NewServerAction;
import com.excentis.products.byteblower.gui.swt.composites.server.actions.dnd.PortConfigTreeDragAdapter;
import com.excentis.products.byteblower.gui.swt.composites.server.actions.dnd.PortConfigTreeDropAdapter;
import com.excentis.products.byteblower.gui.swt.composites.server.dialogs.PhysicalServerPropertiesDialog;
import com.excentis.products.byteblower.gui.swt.composites.server.wizards.UpgradeWizard;
import com.excentis.products.byteblower.gui.swt.dialogs.PcapCaptureDialog;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.tree.ByteBlowerNewDeleteTreeComposite;
import com.excentis.products.byteblower.gui.swt.widgets.tree.ByteBlowerServerModelTreeViewer;
import com.excentis.products.byteblower.gui.transfer.ByteBlowerTransfer;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.AbstractServerController;
import com.excentis.products.byteblower.model.control.server.PhysicalServerController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.AbstractServerReader;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.EByteBlowerServerObjectReader;
import com.excentis.products.byteblower.model.reader.server.MeetingPointReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalConfigurationReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalDockableReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalServerReader;
import com.excentis.products.byteblower.server.model.AbstractServer;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.EByteBlowerServerObject;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import com.excentis.products.byteblower.server.model.PhysicalConfiguration;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalInterface;
import com.excentis.products.byteblower.server.model.PhysicalMobileDevice;
import com.excentis.products.byteblower.server.model.PhysicalPort;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import com.excentis.products.byteblower.server.model.ServerLinkStatus;
import com.excentis.products.byteblower.utils.ssh.ByteBlowerSupportTool;
import com.excentis.products.byteblower.utils.ssh.UserPrompt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class ServerComposite
extends ByteBlowerNewDeleteTreeComposite
implements IDockListener,
IDoubleClickListener {
    protected static final Logger LOGGER = Logger.getGlobal();
    private static final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
    private List<MenuItem> captureMenuItems;
    private ToolItem itemRefresh;
    private ToolItem itemLink;
    private ToolItem itemExpandAll;
    private ToolItem itemCollapseAll;
    private PhysicalConfigurationReader physicalConfigurationReader = null;
    private IDocker docker;
    private ToolBar toolbar;
    private MenuItem itemSupportMeetingPoint;
    private MenuItem itemUpgradeServer;
    private MenuItem itemUpdateMeetingPoint;
    private EByteBlowerServerObject captureObject;
    private Menu menuNew;
    private Menu menuServer;
    private Menu menuInterface;
    private Menu menuPort;
    private Menu menuByteBlowerPort;
    private Menu menuMeetingPoint;
    private NoServerBoughtPopupMenu wirelessEndpointInfoMenu;

    public ServerComposite(Composite parent, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher, IDocker docker) {
        super(parent, "ServerComposite", actionInterface, focusDispatcher);
        this.docker = docker;
        docker.addDockListener(this);
        this.initializeChildClass();
        this.addLinkToolItem();
    }

    @Override
    protected TreeViewer createTreeViewer() {
        ByteBlowerServerModelTreeViewer viewer = new ByteBlowerServerModelTreeViewer(this, this.getViewedClass(), this.getParentClass(), this.getChildFeatureId());
        return viewer;
    }

    public ServerComposite(Composite parent, IByteBlowerAction actionInterface) {
        super(parent, "ServerComposite", actionInterface, null);
    }

    private static ByteBlowerProjectController getActiveByteBlowerProjectController() {
        if (ByteBlowerGuiResourceController.getInstance().isOpen()) {
            return ByteBlowerGuiResourceController.getProjectController();
        }
        return null;
    }

    private static Image createImage(String img) {
        ImageDescriptor imageDescr = ImageDescriptor.createFromFile(ImageCache.class, (String)img);
        return imageDescr.createImage();
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private boolean treeIsExpandable() {
        List readers = this.getPhysicalConfigurationReader().getAllServerReaders();
        for (AbstractServerReader reader : readers) {
            if (reader.getDockables().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateWidgets() {
        ByteBlowerProjectController projectController;
        if (this.itemRefresh.isDisposed()) {
            return;
        }
        boolean selection = !this.getSelectedPhysicalServerControllers().isEmpty();
        this.enableDeleteAction(selection);
        boolean refreshing = false;
        boolean projectOpened = ByteBlowerGuiResourceController.getInstance().isOpen();
        boolean usingServers = false;
        if (projectOpened && (projectController = ServerComposite.getActiveByteBlowerProjectController()) != null) {
            usingServers = !projectController.getUsedServerAddresses().isEmpty();
        }
        boolean enableRefresh = (selection || usingServers) && !refreshing;
        this.itemRefresh.setEnabled(enableRefresh);
        this.updateLinkItem();
        boolean isExpandable = this.treeIsExpandable();
        this.itemExpandAll.setEnabled(isExpandable);
        this.itemCollapseAll.setEnabled(isExpandable);
    }

    private void updateLinkItem() {
        if (this.itemLink != null) {
            boolean projectOpened = ByteBlowerGuiResourceController.getInstance().isOpen();
            this.itemLink.setEnabled(projectOpened);
            boolean link = ByteBlowerPreferences.getSyncServer();
            this.itemLink.setSelection(link);
        }
    }

    @Override
    public void viewerSelectionChanged(SelectionChangedEvent event) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (event.getSource() == treeViewer) {
            this.treeSelectionChanged();
        }
        super.viewerSelectionChanged(event);
    }

    private void treeSelectionChanged() {
        if (this.hasDocker()) {
            this.docker.setSelectedDockables(this.getSelectedDockables());
            this.docker.setSelectedDockedPorts(this.getSelectedDockedPorts());
        }
        this.updateWidgets();
    }

    private boolean hasDocker() {
        return this.docker != null;
    }

    public void doubleClick(DoubleClickEvent event) {
        ITreeSelection sel;
        Object selectedObject;
        TreeViewer treeViewer = this.getTreeViewer();
        if (event.getSource() == treeViewer && (selectedObject = (sel = (ITreeSelection)treeViewer.getSelection()).getFirstElement()) instanceof AbstractServer) {
            AbstractServer server = (AbstractServer)selectedObject;
            this.editServer(server);
        }
    }

    public EList<PhysicalDockable> getSelectedDockables(ITreeSelection sel) {
        UniqueEList dockables = new UniqueEList();
        UniqueEList remainingObjects = new UniqueEList((Collection)sel.toList());
        TreePath[] treePaths = sel.getPaths();
        int nofPaths = treePaths.length;
        int i = 0;
        while (i < nofPaths) {
            TreePath treePath = treePaths[i];
            int nofSegments = treePath.getSegmentCount();
            int j = 0;
            while (j < nofSegments - 1) {
                Object object = treePath.getSegment(j);
                if (remainingObjects.contains(object)) {
                    remainingObjects.remove(object);
                }
                ++j;
            }
            ++i;
        }
        Iterator it = remainingObjects.iterator();
        while (it.hasNext()) {
            dockables.addAll(ServerComposite.getDockables(it.next()));
        }
        return dockables;
    }

    public static EList<PhysicalDockable> getDockables(Object object) {
        EByteBlowerServerObjectReader reader = ReaderFactory.create((EByteBlowerServerObject)((EByteBlowerServerObject)object));
        return reader.getDockables();
    }

    public EList<PhysicalDockable> getSelectedDockables() {
        return this.getSelectedDockables((ITreeSelection)this.getTreeViewer().getSelection());
    }

    public List<DockedByteBlowerPortReader> getSelectedDockedPorts() {
        return this.getSelectedDockedPorts((ITreeSelection)this.getTreeViewer().getSelection());
    }

    private List<DockedByteBlowerPortReader> getSelectedDockedPorts(ITreeSelection sel) {
        ArrayList<DockedByteBlowerPortReader> dockedPorts = new ArrayList<DockedByteBlowerPortReader>();
        EList<? extends Object> selection = this.getTreeSelection(sel);
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            dockedPorts.addAll(ServerComposite.getSelectedDockedPorts(it.next()));
        }
        return dockedPorts;
    }

    private static List<DockedByteBlowerPortReader> getSelectedDockedPorts(Object selectedObject) {
        ArrayList<DockedByteBlowerPortReader> ret = new ArrayList<DockedByteBlowerPortReader>();
        if (selectedObject instanceof PhysicalServer) {
            PhysicalServer server = (PhysicalServer)selectedObject;
            PhysicalServerReader reader = ReaderFactory.create((PhysicalServer)server);
            ret.addAll(reader.getAllDockedPortReaders());
        } else if (selectedObject instanceof MeetingPoint) {
            MeetingPointReader reader = ReaderFactory.create((MeetingPoint)((MeetingPoint)selectedObject));
            ret.addAll(reader.getAllDockedPortReaders());
        } else if (selectedObject instanceof PhysicalDockable) {
            PhysicalDockable dockable = (PhysicalDockable)selectedObject;
            PhysicalDockableReader reader = ReaderFactory.create((PhysicalDockable)dockable);
            ret.addAll(reader.getDockedPortReaders());
        } else if (selectedObject instanceof DockedByteBlowerPort) {
            DockedByteBlowerPort dockedPort = (DockedByteBlowerPort)selectedObject;
            DockedByteBlowerPortReader reader = ReaderFactory.create((DockedByteBlowerPort)dockedPort);
            ret.add(reader);
        }
        return ret;
    }

    private EList<? extends Object> getTreeSelection(ITreeSelection sel) {
        UniqueEList remainingObjects = new UniqueEList((Collection)sel.toList());
        TreePath[] treePaths = sel.getPaths();
        int nofPaths = treePaths.length;
        int i = 0;
        while (i < nofPaths) {
            TreePath treePath = treePaths[i];
            int nofSegments = treePath.getSegmentCount();
            int j = 0;
            while (j < nofSegments - 1) {
                Object object = treePath.getSegment(j);
                if (remainingObjects.contains(object)) {
                    remainingObjects.remove(object);
                }
                ++j;
            }
            ++i;
        }
        return remainingObjects;
    }

    @Override
    protected ByteBlowerPopupMenu createPopupMenu() {
        this.captureMenuItems = new ArrayList<MenuItem>();
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        Shell shell = win.getShell();
        this.wirelessEndpointInfoMenu = new NoServerBoughtPopupMenu(shell);
        this.menuNew = new Menu((Decorations)shell, 8);
        this.addItemNewServer(this.menuNew);
        this.menuServer = new Menu((Decorations)shell, 8);
        this.addItemRefresh(this.menuServer);
        ServerComposite.addItemSeparator(this.menuServer);
        this.addItemEdit(this.menuServer);
        this.addItemDelete(this.menuServer);
        ServerComposite.addItemSeparator(this.menuServer);
        this.addItemCapture(this.menuServer);
        this.addItemSupport(this.menuServer);
        this.itemUpgradeServer = this.addItemUpgrade(this.menuServer);
        this.menuInterface = new Menu((Decorations)shell, 8);
        this.addItemCapture(this.menuInterface);
        this.menuPort = new Menu((Decorations)shell, 8);
        this.addItemDirectCapture(this.menuPort);
        this.addItemCapture(this.menuPort);
        this.menuByteBlowerPort = new Menu((Decorations)shell, 8);
        this.addItemDirectCapture(this.menuByteBlowerPort);
        this.addItemCapture(this.menuByteBlowerPort);
        this.addItemUndock(this.menuByteBlowerPort);
        this.menuMeetingPoint = new Menu((Decorations)shell, 8);
        this.addItemRefresh(this.menuMeetingPoint);
        ServerComposite.addItemSeparator(this.menuMeetingPoint);
        this.addItemEdit(this.menuMeetingPoint);
        this.addItemDelete(this.menuMeetingPoint);
        ServerComposite.addItemSeparator(this.menuMeetingPoint);
        this.itemSupportMeetingPoint = this.addItemSupport(this.menuMeetingPoint);
        this.itemUpdateMeetingPoint = this.addItemUpgrade(this.menuMeetingPoint);
        return null;
    }

    private static void addItemSeparator(Menu menu) {
        new MenuItem(menu, 2);
    }

    private void addItemNewServer(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText("New Server...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerComposite.this.actionInterface.doNew();
            }
        });
    }

    private void addItemEdit(Menu menu) {
        MenuItem editServer = new MenuItem(menu, 8);
        editServer.setText("Edit...");
        editServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerComposite.this.doEdit();
            }
        });
    }

    private MenuItem addItemRefresh(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setImage(ServerComposite.createImage("config/e_refresh.gif"));
        item.setText("Refresh");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerComposite.this.doRefresh();
            }
        });
        return item;
    }

    private MenuItem addItemUpgrade(Menu menu) {
        MenuItem itemUpdate = new MenuItem(menu, 8);
        itemUpdate.setText("Update...");
        itemUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerComposite.this.updateServer();
            }
        });
        return itemUpdate;
    }

    private MenuItem addItemSupport(Menu menu) {
        MenuItem itemSupport = new MenuItem(menu, 8);
        itemSupport.setText("Run Support Tool...");
        itemSupport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerComposite.this.runSupportTool();
            }
        });
        return itemSupport;
    }

    private MenuItem addItemCapture(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Configure and Start Capture...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.capture();
            }

            private void capture() {
                PcapCaptureDialog toShow = new PcapCaptureDialog(ServerComposite.this.getShell(), ServerComposite.this.captureObject);
                toShow.open();
            }
        });
        this.captureMenuItems.add(item);
        return item;
    }

    private MenuItem addItemDirectCapture(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Start Capture...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.capture();
            }

            private void capture() {
                PcapCaptureDialog toShow = new PcapCaptureDialog(ServerComposite.this.getShell(), ServerComposite.this.captureObject);
                toShow.open();
                toShow.startCapture();
            }
        });
        this.captureMenuItems.add(item);
        return item;
    }

    private void addItemDelete(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setImage(sharedImages.getImage("IMG_TOOL_DELETE"));
        item.setText("Delete");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerComposite.this.doDelete();
            }
        });
    }

    private MenuItem addItemUndock(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Undock");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerComposite.this.docker.undock();
            }
        });
        return item;
    }

    private void createToolbar() {
        this.toolbar = new ToolBar((Composite)this, 256);
        this.itemExpandAll = new ToolItem(this.toolbar, 0);
        Image itemExpandAllImage = ServerComposite.createImage("config/e_expandall.gif");
        this.itemExpandAll.setImage(itemExpandAllImage);
        Image itemExpandAllDisabledImage = ServerComposite.createImage("config/d_expandall.gif");
        this.itemExpandAll.setDisabledImage(itemExpandAllDisabledImage);
        this.itemExpandAll.setToolTipText("Expand All");
        this.itemExpandAll.addSelectionListener((SelectionListener)this);
        this.itemCollapseAll = new ToolItem(this.toolbar, 0);
        Image itemCollapseAllImage = ServerComposite.createImage("config/e_collapseall.gif");
        this.itemCollapseAll.setImage(itemCollapseAllImage);
        Image itemCollapseAllDisabledImage = ServerComposite.createImage("config/d_collapseall.gif");
        this.itemCollapseAll.setDisabledImage(itemCollapseAllDisabledImage);
        this.itemCollapseAll.setToolTipText("Collapse All");
        this.itemCollapseAll.addSelectionListener((SelectionListener)this);
        this.itemRefresh = new ToolItem(this.toolbar, 0);
        Image itemRefreshImage = ServerComposite.createImage("config/e_refresh.gif");
        this.itemRefresh.setImage(itemRefreshImage);
        Image itemRefreshDisabledImage = ServerComposite.createImage("config/d_refresh.gif");
        this.itemRefresh.setDisabledImage(itemRefreshDisabledImage);
        this.itemRefresh.setToolTipText("Refresh all used and selected ByteBlower Servers");
        this.itemRefresh.addSelectionListener((SelectionListener)this);
    }

    private void addLinkToolItem() {
        this.itemLink = new ToolItem(this.toolbar, 32);
        this.itemLink.setImage(ServerComposite.createImage("view/server/e_synced.gif"));
        this.itemLink.setToolTipText("Link with ByteBlower Ports");
        this.itemLink.addSelectionListener((SelectionListener)this);
        boolean link = ByteBlowerPreferences.getSyncServer();
        this.itemLink.setSelection(link);
        this.docker.setLinked(link);
        this.updateLinkItem();
    }

    @Override
    public void widgetSelected(SelectionEvent event) {
        Widget widget = event.widget;
        if (widget == this.itemExpandAll) {
            this.expandAll();
        } else if (widget == this.itemCollapseAll) {
            this.collapseAll();
        } else if (widget == this.itemLink) {
            this.updateLink();
        } else if (widget == this.itemRefresh) {
            this.refreshUsedAndSelectedServers();
        }
        super.widgetSelected(event);
    }

    private void updateLink() {
        boolean link = this.itemLink.getSelection();
        ByteBlowerPreferences.setSyncServer((boolean)link);
        this.docker.setLinked(link);
    }

    private void collapseAll() {
        this.getTreeViewer().collapseAll();
    }

    private void expandAll() {
        this.getTreeViewer().expandAll();
    }

    @Override
    protected void initializeChildClass() {
        this.initializeDragDropSupport();
    }

    @Override
    protected void afterInitialization() {
        TreeViewer treeViewer = this.getTreeViewer();
        final Tree tree = this.getTree();
        final ServerComposite comp = this;
        tree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                ServerComposite.this.captureObject = null;
                if (item != null) {
                    ServerComposite.this.captureObject = (EByteBlowerServerObject)item.getData();
                }
                comp.updateMenu(ServerComposite.this.captureObject);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        TooltipPicker treeListener = new TooltipPicker(treeViewer);
        tree.addListener(5, (Listener)treeListener);
        tree.addListener(32, (Listener)treeListener);
        tree.addListener(12, (Listener)treeListener);
        tree.addListener(1, (Listener)treeListener);
        treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        super.afterInitialization();
    }

    private void captureMenuEnable(boolean isGood) {
        for (MenuItem item : this.captureMenuItems) {
            item.setEnabled(isGood);
        }
    }

    protected void updateMenu(Object selected) {
        PhysicalServerReader reader;
        if (!this.hasFocusDispatcher()) {
            return;
        }
        Menu menu = null;
        if (selected == null) {
            menu = this.menuNew;
        } else if (selected instanceof PhysicalServer) {
            menu = this.menuServer;
            reader = ReaderFactory.create((PhysicalServer)((PhysicalServer)selected));
            boolean statusOk = reader.getServerLinkStatus() == ServerLinkStatus.ONLINE;
            this.captureMenuEnable(statusOk);
            boolean updateAvailable = reader.hasUpdateAvailable();
            if (updateAvailable) {
                Version latest = reader.getLatestVersion();
                this.itemUpgradeServer.setText("Update to " + latest.toString() + " ...");
            } else {
                this.itemUpgradeServer.setText("Update...");
            }
        } else if (selected instanceof MeetingPoint) {
            reader = ReaderFactory.create((MeetingPoint)((MeetingPoint)selected));
            if (reader.isLicenseNotBought()) {
                menu = this.wirelessEndpointInfoMenu.getMenu();
            } else {
                menu = this.menuMeetingPoint;
                boolean statusOk = reader.getServerLinkStatus() == ServerLinkStatus.ONLINE;
                this.itemSupportMeetingPoint.setEnabled(statusOk);
                this.itemUpdateMeetingPoint.setEnabled(statusOk);
                boolean updateAvailable = reader.hasUpdateAvailable();
                if (updateAvailable) {
                    Version latest = reader.getLatestVersion();
                    this.itemUpdateMeetingPoint.setText("Update to " + latest.toString() + " ...");
                } else {
                    this.itemUpdateMeetingPoint.setText("Update...");
                }
            }
        } else if (selected instanceof PhysicalInterface) {
            reader = ReaderFactory.create((PhysicalInterface)((PhysicalInterface)selected));
            menu = reader.isNonTrunking() ? this.menuPort : this.menuInterface;
            boolean statusOk = reader.getPhysicalServerReader().getServerLinkStatus() == ServerLinkStatus.ONLINE;
            this.captureMenuEnable(statusOk);
        } else if (selected instanceof PhysicalPort) {
            menu = this.menuPort;
            reader = ReaderFactory.create((PhysicalPort)((PhysicalPort)selected));
            boolean statusOk = reader.getPhysicalInterfaceReader().getPhysicalServerReader().getServerLinkStatus() == ServerLinkStatus.ONLINE;
            this.captureMenuEnable(statusOk);
        } else if (selected instanceof DockedByteBlowerPort) {
            menu = this.menuByteBlowerPort;
            DockedByteBlowerPort dockedPort = (DockedByteBlowerPort)selected;
            PhysicalDockable dockable = dockedPort.getItsPhysicalDockable();
            PhysicalDockableReader reader2 = ReaderFactory.create((PhysicalDockable)dockable);
            AbstractServer server = reader2.getServer();
            AbstractServerReader serverReader = ReaderFactory.create((AbstractServer)server);
            boolean statusOk = serverReader.getServerLinkStatus() == ServerLinkStatus.ONLINE;
            this.captureMenuEnable(statusOk);
        }
        Tree tree = this.getTree();
        tree.setMenu(menu);
    }

    private static PhysicalConfigurationManager getPhysicalConfigurationManager() {
        return PhysicalConfigurationManager.getInstance();
    }

    private PhysicalConfigurationReader getPhysicalConfigurationReader() {
        if (this.physicalConfigurationReader == null) {
            this.physicalConfigurationReader = ServerComposite.getPhysicalConfigurationManager().getPhysicalConfigurationReader();
        }
        return this.physicalConfigurationReader;
    }

    public Object getInitialInput() {
        PhysicalConfigurationManager manager = PhysicalConfigurationManager.getInstance();
        PhysicalConfiguration knownConfig = (PhysicalConfiguration)this.getPhysicalConfigurationReader().getObject();
        ArrayList<PhysicalServerController> toRefresh = new ArrayList<PhysicalServerController>();
        for (PhysicalServer aServer : knownConfig.getPhysicalServer()) {
            toRefresh.add(ControllerFactory.create((PhysicalServer)aServer));
        }
        manager.refreshJob(toRefresh);
        return knownConfig;
    }

    @Override
    protected String getTreeLabel() {
        return "ByteBlower Servers:";
    }

    @Override
    protected void updateCustomWidgets(boolean enable) {
    }

    @Override
    protected Class<? extends EByteBlowerServerObject> getParentClass() {
        return PhysicalConfiguration.class;
    }

    private void updateSSHCommand(String address) {
        UpgradeWizard.launch(this.getShell(), address);
    }

    private void startSupportTool(String address) {
        Shell shell = this.getShell();
        GraphicPassPrompt prompt = new GraphicPassPrompt(this.getShell(), "Support tool");
        ByteBlowerSupportTool starter = new ByteBlowerSupportTool(address, (UserPrompt)prompt);
        SupportToolJob job = new SupportToolJob(shell, starter, address, prompt);
        job.setSystem(true);
        job.schedule(0L);
    }

    public void runSupportTool() {
        TreeViewer treeViewer = this.getTreeViewer();
        ITreeSelection sel = (ITreeSelection)treeViewer.getSelection();
        Object selectedObject = sel.getFirstElement();
        if (selectedObject instanceof PhysicalServer) {
            PhysicalServer server = (PhysicalServer)selectedObject;
            try {
                this.startSupportTool(server.getAddress());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Not able to remotely run server support tool", ex);
            }
        }
    }

    public void updateServer() {
        TreeViewer treeViewer = this.getTreeViewer();
        ITreeSelection sel = (ITreeSelection)treeViewer.getSelection();
        Object selectedObject = sel.getFirstElement();
        if (selectedObject instanceof AbstractServer) {
            AbstractServer server = (AbstractServer)selectedObject;
            try {
                this.updateSSHCommand(server.getAddress());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Not able to remotely start ByteBlower server", ex);
            }
        }
    }

    public void doEdit() {
        TreeViewer treeViewer = this.getTreeViewer();
        ITreeSelection sel = (ITreeSelection)treeViewer.getSelection();
        Object selectedObject = sel.getFirstElement();
        if (selectedObject instanceof AbstractServer) {
            AbstractServer server = (AbstractServer)selectedObject;
            this.editServer(server);
        }
    }

    private void editServer(AbstractServer server) {
        PhysicalServerPropertiesDialog dlg = new PhysicalServerPropertiesDialog(this.getShell(), server);
        if (dlg.open() == 0) {
            this.updateWidgets();
        }
        PhysicalConfigurationManager manager = PhysicalConfigurationManager.getInstance();
        manager.refreshJob(ControllerFactory.create((AbstractServer)server));
    }

    private void refreshUsedAndSelectedServers() {
        ArrayList servers = new ArrayList();
        PhysicalConfigurationManager manager = ServerComposite.getPhysicalConfigurationManager();
        ByteBlowerProjectController controller = ServerComposite.getActiveByteBlowerProjectController();
        if (controller != null) {
            servers.addAll(manager.getUsedServerControllers(controller));
        }
        servers.addAll(this.getSelectedPhysicalServerControllers());
        manager.refreshJob(servers);
    }

    public void doRefresh() {
        List<AbstractServerController<?>> selectedServers = this.getSelectedPhysicalServerControllers();
        ServerComposite.getPhysicalConfigurationManager().refreshJob(selectedServers);
    }

    public List<AbstractServerController<?>> getSelectedPhysicalServerControllers() {
        ITreeSelection uiSelection = (ITreeSelection)this.getTreeViewer().getSelection();
        ArrayList serverControllers = new ArrayList();
        for (Object selected : uiSelection.toList()) {
            AbstractServer server = null;
            if (selected instanceof AbstractServer) {
                server = (AbstractServer)selected;
            } else if (selected instanceof PhysicalDockable) {
                PhysicalDockableReader dockableReader = ReaderFactory.create((PhysicalDockable)((PhysicalDockable)selected));
                server = dockableReader.getServer();
            }
            if (server == null) continue;
            serverControllers.add(ControllerFactory.create((AbstractServer)server));
        }
        return serverControllers;
    }

    public List<PhysicalServer> getSelectedPhysicalServers() {
        ITreeSelection sel = (ITreeSelection)this.getTreeViewer().getSelection();
        ArrayList<PhysicalServer> physicalServers = new ArrayList<PhysicalServer>();
        for (Object object : sel) {
            if (!(object instanceof PhysicalServer)) continue;
            physicalServers.add((PhysicalServer)object);
        }
        return physicalServers;
    }

    @Override
    public void docked(EList<ByteBlowerGuiPortReader> ports, EList<PhysicalDockable> dockables) {
        this.select((List<?>)ports);
    }

    @Override
    public void link(EList<ByteBlowerGuiPortReader> ports) {
        this.selectReaders((List<ByteBlowerGuiPortReader>)ports);
    }

    private void selectReaders(List<ByteBlowerGuiPortReader> portReaders) {
        EList dockedPorts = this.getPhysicalConfigurationReader().getDockedPorts(portReaders);
        if (!dockedPorts.isEmpty()) {
            this.select((EList<DockedByteBlowerPort>)dockedPorts);
        }
    }

    @Override
    private void select(EList<DockedByteBlowerPort> dockedPorts) {
        TreePath[] paths = new TreePath[dockedPorts.size()];
        int i = 0;
        for (DockedByteBlowerPort dockedPort : dockedPorts) {
            Object[] segments;
            PhysicalServer server;
            PhysicalInterface interf;
            PhysicalDockable dockable = dockedPort.getItsPhysicalDockable();
            if (dockable instanceof PhysicalPort) {
                PhysicalPort port = (PhysicalPort)dockable;
                interf = port.getPhysicalInterface();
                server = interf.getPhysicalServer();
                segments = new Object[]{server, interf, port, dockedPort};
            } else if (dockable instanceof PhysicalInterface) {
                interf = (PhysicalInterface)dockable;
                server = interf.getPhysicalServer();
                segments = new Object[]{server, interf, dockedPort};
            } else {
                if (!(dockable instanceof PhysicalMobileDevice)) continue;
                PhysicalMobileDevice mobile = (PhysicalMobileDevice)dockable;
                server = mobile.getMeetingPoint();
                segments = new Object[]{server, mobile};
            }
            TreePath treePath = new TreePath(segments);
            paths[i++] = treePath;
        }
        TreeSelection newTreeSelection = new TreeSelection(paths);
        this.getTreeViewer().setSelection((ISelection)newTreeSelection, true);
    }

    @Override
    public void select(ByteBlowerGuiPort port) {
        ArrayList<ByteBlowerGuiPortReader> readers = new ArrayList<ByteBlowerGuiPortReader>();
        readers.add(ReaderFactory.create((ByteBlowerGuiPort)port));
        this.select((List<?>)readers);
    }

    @Override
    protected int createTreeChildWidgets() {
        this.createToolbar();
        return 1;
    }

    @Override
    protected void initializeTreeChildListeners() {
    }

    @Override
    protected int getAmount() {
        return 0;
    }

    @Override
    protected ByteBlowerNewAction<?> createNewAction() {
        return new NewServerAction(this);
    }

    @Override
    protected ByteBlowerCutAction<?> createCutAction() {
        return null;
    }

    @Override
    protected ByteBlowerCopyAction<?> createCopyAction() {
        return null;
    }

    @Override
    protected ByteBlowerPasteAction<?> createPasteAction() {
        return null;
    }

    @Override
    protected ByteBlowerDeleteAction<?> createDeleteAction() {
        return new DeleteServerAction(this);
    }

    @Override
    protected void initializeDragDropSupport() {
        Transfer[] transfer = new Transfer[]{ByteBlowerTransfer.getInstance(DockedByteBlowerPort.class), ByteBlowerTransfer.getInstance(ByteBlowerGuiPort.class)};
        this.columnViewer.addDragSupport(2, transfer, this.getDragSourceListener((StructuredViewer)this.columnViewer));
        this.columnViewer.addDropSupport(2, transfer, this.getDropTargetListener((StructuredViewer)this.columnViewer));
    }

    protected DragSourceListener getDragSourceListener(StructuredViewer structuredViewer) {
        return new PortConfigTreeDragAdapter(structuredViewer);
    }

    protected DropTargetListener getDropTargetListener(StructuredViewer structuredViewer) {
        return new PortConfigTreeDropAdapter(this, this.docker);
    }

    @Override
    public int getFirstSelectedIndex() {
        return 0;
    }

    @Override
    protected void projectChanged(ByteBlowerProject project) {
    }

    public void afterServerDelete() {
        this.updateWidgets();
        this.docker.notifyUndockListeners();
    }

    public Class<?> getViewedClass() {
        return EByteBlowerServerObject.class;
    }

    @Override
    public void doJump() {
    }

    @Override
    public int getChildFeatureId() {
        return 0;
    }

    @Override
    protected CellEditor[] createCellEditors() {
        return null;
    }

    @Override
    protected ICellModifier getCellModifier() {
        return null;
    }

    @Override
    protected ByteBlowerComparator createViewerComparator(ColumnViewer columnViewer) {
        return new ServerComparator(columnViewer);
    }
}

