/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.server;

import com.excentis.products.byteblower.gui.model.reader.ByteBlowerGuiPortConfigurationGuiReader;
import com.excentis.products.byteblower.gui.model.reader.ByteBlowerGuiPortGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.gui.server.model.reader.MeetingPointGuiReader;
import com.excentis.products.byteblower.gui.server.model.reader.MobileDeviceGuiReader;
import com.excentis.products.byteblower.gui.server.model.reader.PhysicalServerGuiReader;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import com.excentis.products.byteblower.server.model.PhysicalMobileDevice;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class TooltipPicker
implements Listener {
    private final Tree tree;

    TooltipPicker(TreeViewer treeViewer) {
        this.tree = treeViewer.getTree();
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 1: 
            case 5: 
            case 12: {
                this.tree.setToolTipText(null);
                break;
            }
            case 32: {
                this.pickText(event.x, event.y);
            }
        }
    }

    private void pickText(int x, int y) {
        TreeItem item = this.tree.getItem(new Point(x, y));
        if (item != null && item.getData() != null) {
            Object realObject = item.getData();
            if (realObject instanceof PhysicalServer) {
                PhysicalServer object = (PhysicalServer)realObject;
                PhysicalServerGuiReader reader = GuiReaderFactory.create((PhysicalServer)object);
                this.tree.setToolTipText(reader.getToolTipText());
            } else if (realObject instanceof ByteBlowerGuiPortConfiguration) {
                ByteBlowerGuiPortConfiguration object = (ByteBlowerGuiPortConfiguration)realObject;
                ByteBlowerGuiPortConfigurationGuiReader reader = GuiReaderFactory.create((ByteBlowerGuiPortConfiguration)object);
                this.tree.setToolTipText(reader.getToolTipText());
            } else if (realObject instanceof ByteBlowerGuiPort) {
                ByteBlowerGuiPort object = (ByteBlowerGuiPort)realObject;
                ByteBlowerGuiPortGuiReader reader = GuiReaderFactory.create((ByteBlowerGuiPort)object);
                this.tree.setToolTipText(reader.getToolTipText());
            } else if (realObject instanceof PhysicalMobileDevice) {
                PhysicalMobileDevice object = (PhysicalMobileDevice)realObject;
                MobileDeviceGuiReader reader = GuiReaderFactory.create((PhysicalMobileDevice)object);
                this.tree.setToolTipText(reader.getToolTipText());
            } else if (realObject instanceof MeetingPoint) {
                MeetingPoint object = (MeetingPoint)realObject;
                MeetingPointGuiReader reader = GuiReaderFactory.create((MeetingPoint)object);
                this.tree.setToolTipText(reader.getToolTipText());
            } else {
                this.tree.setToolTipText(null);
            }
        }
    }
}

