/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.server.actions;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.composites.server.IUndockListener;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.DockedByteBlowerPortController;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;

public class UndockAction
extends Action
implements IAfterOperationListener {
    private List<DockedByteBlowerPortReader> dockedPorts;
    private List<IUndockListener> undockListeners = new ArrayList<IUndockListener>();

    public UndockAction() {
        super("Undock");
        this.update();
    }

    public void run() {
        boolean multiplePorts = this.dockedPorts.size() > 1;
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), multiplePorts ? "Undock Ports" : "Undock Port");
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (DockedByteBlowerPortReader reader : this.dockedPorts) {
            DockedByteBlowerPortController controller = ControllerFactory.create((DockedByteBlowerPort)((DockedByteBlowerPort)reader.getObject()));
            compound.appendCommand(controller.undock());
        }
        operation.appendCommand(compound.unwrap());
        operation.addAfterOperationListener((IAfterOperationListener)this);
        operation.run();
    }

    public void setSelectedDockedPorts(List<DockedByteBlowerPortReader> dockedPorts) {
        this.dockedPorts = dockedPorts;
        this.update();
    }

    private void update() {
        boolean enable = this.dockedPorts != null && !this.dockedPorts.isEmpty();
        this.setEnabled(enable);
    }

    public void addUndockListener(IUndockListener undockListener) {
        if (!this.undockListeners.contains(undockListener)) {
            this.undockListeners.add(undockListener);
        }
    }

    public void afterOperation(UndoableByteBlowerOperation operation) {
        this.notifyUndockListeners();
    }

    public void notifyUndockListeners() {
        ArrayList<ByteBlowerGuiPortConfiguration> undockedPortConfigs = new ArrayList<ByteBlowerGuiPortConfiguration>();
        for (DockedByteBlowerPortReader reader : this.dockedPorts) {
            undockedPortConfigs.add(reader.getByteBlowerGuiPortConfiguration());
        }
        for (IUndockListener listener : this.undockListeners) {
            listener.undocked(undockedPortConfigs);
        }
    }
}

