/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.server.actions.dnd;

import com.excentis.products.byteblower.gui.swt.composites.server.IDocker;
import com.excentis.products.byteblower.gui.swt.composites.server.ServerComposite;
import com.excentis.products.byteblower.gui.transfer.ByteBlowerTransfer;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.TreeItem;

public class PortConfigTreeDropAdapter
extends ViewerDropAdapter {
    private Object dropDockObject;
    private ServerComposite serverComposite;
    private IDocker dockAction;

    public PortConfigTreeDropAdapter(ServerComposite serverComposite, IDocker docker) {
        super((Viewer)serverComposite.getTreeViewer());
        this.serverComposite = serverComposite;
        this.dockAction = docker;
    }

    public void dragOver(DropTargetEvent event) {
        Object object;
        TreeItem item = (TreeItem)event.item;
        this.dropDockObject = item == null ? null : (object = item.getData());
        super.dragOver(event);
    }

    public boolean performDrop(Object data) {
        StructuredSelection draggedObjects = (StructuredSelection)data;
        UniqueEList portReaders = new UniqueEList();
        for (Object draggedObject : draggedObjects.toList()) {
            if (draggedObject instanceof ByteBlowerGuiPort) {
                ByteBlowerGuiPort port = (ByteBlowerGuiPort)draggedObject;
                portReaders.add((Object)ReaderFactory.create((ByteBlowerGuiPort)port));
                continue;
            }
            if (draggedObject instanceof ByteBlowerGuiPortConfiguration) {
                ByteBlowerGuiPortConfiguration portConfiguration = (ByteBlowerGuiPortConfiguration)draggedObject;
                portReaders.add((Object)ReaderFactory.create((ByteBlowerGuiPort)portConfiguration.getByteBlowerGuiPort()));
                continue;
            }
            if (!(draggedObject instanceof DockedByteBlowerPort)) continue;
            DockedByteBlowerPort dockedByteBlowerPort = (DockedByteBlowerPort)draggedObject;
            DockedByteBlowerPortReader reader = ReaderFactory.create((DockedByteBlowerPort)dockedByteBlowerPort);
            ByteBlowerGuiPortConfiguration portConfiguration = reader.getByteBlowerGuiPortConfiguration();
            portReaders.add((Object)ReaderFactory.create((ByteBlowerGuiPort)portConfiguration.getByteBlowerGuiPort()));
        }
        this.dockAction.setSelectedByteBlowerGuiPorts((EList<ByteBlowerGuiPortReader>)portReaders);
        TreeViewer treeViewer = (TreeViewer)this.getViewer();
        StructuredSelection treeSel = (StructuredSelection)treeViewer.getSelection();
        EList<PhysicalDockable> physicalDockables = null;
        physicalDockables = treeSel.toList().contains(this.dropDockObject) ? this.serverComposite.getSelectedDockables((ITreeSelection)treeSel) : ServerComposite.getDockables(this.dropDockObject);
        this.dockAction.setSelectedDockables(physicalDockables);
        this.dockAction.dock();
        return true;
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        PhysicalServer server;
        if (target == null) {
            return false;
        }
        if (target instanceof PhysicalServer && (server = (PhysicalServer)target).getPhysicalInterface().isEmpty()) {
            return false;
        }
        boolean valid = ByteBlowerTransfer.getInstance(DockedByteBlowerPort.class).isSupportedType(type) || ByteBlowerTransfer.getInstance(ByteBlowerGuiPort.class).isSupportedType(type);
        return valid;
    }
}

