/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.server.wizards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class UpgradePage
extends WizardPage {
    private TableViewer upgradeStepViewer;
    private List<UpdateElement> elements = new ArrayList<UpdateElement>();

    protected UpgradePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FillLayout(512));
        this.upgradeStepViewer = new TableViewer(comp);
        this.upgradeStepViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        final TableColumn column = new TableColumn(this.upgradeStepViewer.getTable(), 0);
        column.setResizable(false);
        column.setText("Step");
        this.upgradeStepViewer.getControl().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                Rectangle rect = UpgradePage.this.upgradeStepViewer.getTable().getClientArea();
                if (rect.width > 0) {
                    column.setWidth(rect.width);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        this.upgradeStepViewer.setLabelProvider((IBaseLabelProvider)new LabelWithPictureProvider(this.getShell()));
        this.setControl((Control)comp);
    }

    public void resetSteps() {
        this.elements.clear();
        this.upgradeStepViewer.refresh();
    }

    public void updateLastStepFailed() {
        this.elements.get((int)(this.elements.size() - 1)).failed = true;
        this.upgradeStepViewer.update(this.elements.toArray(), null);
        this.getControl().requestLayout();
    }

    public void addStep(String name) {
        UpdateElement e = new UpdateElement(name);
        this.elements.add(e);
        this.upgradeStepViewer.add((Object)e);
    }

    public IWizardPage getPreviousPage() {
        IWizardPage NO_PREVIOUS = null;
        return NO_PREVIOUS;
    }

    public static class LabelWithPictureProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image[] images = new Image[2];

        public LabelWithPictureProvider(Shell shell) {
            this.images[0] = this.createImage(shell, 0, 255, 0);
            this.images[1] = this.createImage(shell, 255, 0, 0);
        }

        private Image createImage(Shell shell, int red, int green, int blue) {
            Color color = new Color((Device)shell.getDisplay(), red, green, blue);
            Image image = new Image((Device)shell.getDisplay(), 10, 10);
            GC gc = new GC((Drawable)image);
            gc.setBackground(color);
            gc.fillRectangle(0, 0, 10, 10);
            gc.dispose();
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.images[((UpdateElement)element).isFailed() ? 1 : 0];
            }
            return null;
        }
    }

    private static final class UpdateElement
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private boolean failed;

        public UpdateElement(String name) {
            this.name = name;
        }

        protected boolean isFailed() {
            return this.failed;
        }

        public String toString() {
            return this.name;
        }
    }
}

