/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.server.wizards;

import com.excentis.products.byteblower.gui.swt.Activator;
import com.excentis.products.byteblower.gui.swt.composites.server.wizards.UpdateOutroPage;
import com.excentis.products.byteblower.gui.swt.composites.server.wizards.UpdateWizardDialog;
import com.excentis.products.byteblower.gui.swt.composites.server.wizards.UpgradeIntroPage;
import com.excentis.products.byteblower.gui.swt.composites.server.wizards.UpgradePage;
import com.excentis.products.byteblower.utils.ssh.Upgrade;
import com.excentis.products.byteblower.utils.ssh.UpgradeStepListener;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class UpgradeWizard
extends Wizard
implements UpgradeStepListener,
IPageChangedListener {
    private UpgradePage fPage;
    private UpdateOutroPage outroPage;
    private final String serverAddress;
    private boolean canFinish;
    private UpdateWizardDialog dialog;

    public static void launch(Shell shell, String serverAddress) {
        UpgradeWizard testWizard = new UpgradeWizard(serverAddress);
        UpdateWizardDialog dialog = new UpdateWizardDialog(shell, (IWizard)testWizard);
        testWizard.setDialog(dialog);
        dialog.addPageChangedListener(testWizard);
        dialog.open();
    }

    public UpgradeWizard(String serverAddress) {
        this.serverAddress = serverAddress;
        this.setNeedsProgressMonitor(true);
        this.canFinish = false;
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public void canFinish(boolean canFinish) {
        this.canFinish = canFinish;
        if (canFinish) {
            this.outroPage.setFinishedOk();
        }
    }

    private void setDialog(UpdateWizardDialog dialog) {
        this.dialog = dialog;
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)new UpgradeIntroPage("Server Update Intro", "Server Update Wizard", null));
        this.fPage = new UpgradePage("Server Update", "Server Update Wizard", null);
        this.addPage((IWizardPage)this.fPage);
        this.outroPage = new UpdateOutroPage("Server Update Finished", "Server Update Wizard", null);
        this.addPage((IWizardPage)this.outroPage);
    }

    public boolean performFinish() {
        return true;
    }

    public boolean runUpdate() {
        final UpgradeWizard wizard = this;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor pMonitor) throws InvocationTargetException, InterruptedException {
                    UpgradeWizard.this.getContainer().getShell().getDisplay().syncExec(() -> {
                        UpgradeWizard.this.fPage.resetSteps();
                        UpgradeWizard.this.fPage.setErrorMessage(null);
                    });
                    Upgrade upgrade = new Upgrade(UpgradeWizard.this.serverAddress, pMonitor);
                    upgrade.setListener((UpgradeStepListener)wizard);
                    wizard.canFinish(upgrade.run());
                }
            });
        }
        catch (Exception e) {
            Activator.log("Update Server failed: ", e);
        }
        this.getContainer().getShell().getDisplay().syncExec(() -> this.dialog.setFinished());
        return false;
    }

    public void onFeedbackReceived(String feedback, IProgressMonitor monitor) {
        this.getContainer().getShell().getDisplay().asyncExec(() -> monitor.setTaskName(feedback));
    }

    public void onStepStarted(String stepName) {
        this.getContainer().getShell().getDisplay().syncExec(() -> this.fPage.addStep(stepName));
    }

    public void onStepError(String stepName, String errorMessage) {
        this.getContainer().getShell().getDisplay().syncExec(() -> {
            this.fPage.setErrorMessage(errorMessage);
            this.fPage.updateLastStepFailed();
            this.outroPage.setFailed(errorMessage);
            this.fPage.setPageComplete(true);
        });
    }

    public void onGeneralErrorOccurred(String errorMessage) {
        this.getContainer().getShell().getDisplay().asyncExec(() -> this.fPage.setErrorMessage(errorMessage));
    }

    public void onStepFinished(String stepName) {
    }

    public void onFinalStepDone() {
        this.getContainer().getShell().getDisplay().syncExec(() -> {
            this.fPage.addStep("Finished");
            this.fPage.setMessage("Finished", 1);
            this.dialog.setFinished();
        });
    }

    public void pageChanged(PageChangedEvent event) {
        if (event.getSelectedPage().equals((Object)this.fPage)) {
            this.runUpdate();
            this.getContainer().updateButtons();
        }
    }
}

