/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.dialogs;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class PasswordDialog
extends Dialog {
    private static final Logger LOGGER = Logger.getGlobal();
    private char[] password = new char[0];
    private Text pass;
    private StyledText outputText;
    private Label motdText;
    private Label prompt;
    private Button passEnter;
    private Label doneText;
    private GridData passwordGrid;
    private Composite passArea;
    private volatile boolean isClosed = false;
    private AtomicBoolean askedToClose = new AtomicBoolean(false);
    private String unmodifiedOutput = new String();
    private final String title;

    public PasswordDialog(Shell parentShell, String title) {
        super(parentShell);
        this.title = title;
    }

    public boolean close() {
        this.isClosed = true;
        return super.close();
    }

    private void cleanPasswordMemory() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PasswordDialog.this.pass.isDisposed()) {
                    PasswordDialog.this.pass.setText(new String());
                }
            }
        });
        Arrays.fill(this.password, '0');
    }

    public String getPassword(final String promptTxt) {
        final AtomicBoolean filledPassword = new AtomicBoolean(false);
        final Runnable disposeListener = new Runnable(){

            @Override
            public void run() {
                filledPassword.set(true);
            }
        };
        final TraverseListener next = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                filledPassword.compareAndSet(false, e.detail == 4);
            }
        };
        final SelectionListener enter = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                filledPassword.set(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        final Display disp = PlatformUI.getWorkbench().getDisplay();
        if (disp == null || this.isClosed) {
            return new String();
        }
        disp.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PasswordDialog.this.prompt.isDisposed() || PasswordDialog.this.passEnter.isDisposed() || PasswordDialog.this.pass.isDisposed() || disp.isDisposed()) {
                    return;
                }
                PasswordDialog.this.passArea.setVisible(true);
                PasswordDialog.this.passwordGrid.exclude = false;
                PasswordDialog.this.prompt.setEnabled(true);
                PasswordDialog.this.passEnter.setEnabled(true);
                PasswordDialog.this.pass.setEnabled(true);
                PasswordDialog.this.pass.addTraverseListener(next);
                PasswordDialog.this.pass.forceFocus();
                PasswordDialog.this.passEnter.addSelectionListener(enter);
                PasswordDialog.this.prompt.setText(promptTxt);
                PasswordDialog.this.prompt.pack();
                PasswordDialog.this.prompt.getParent().pack();
                PasswordDialog.this.prompt.getParent().getParent().pack();
                disp.disposeExec(disposeListener);
            }
        });
        while (!filledPassword.get() && !this.isClosed) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e1) {
                LOGGER.log(Level.WARNING, "Interrupted while waiting for password", e1);
                Thread.currentThread().interrupt();
            }
        }
        if (disp.isDisposed() || this.isClosed) {
            return new String();
        }
        disp.asyncExec(new Runnable(){

            @Override
            public void run() {
                PasswordDialog.this.passwordGrid.exclude = true;
                if (!PasswordDialog.this.passArea.isDisposed()) {
                    PasswordDialog.this.passArea.setVisible(false);
                }
                if (!PasswordDialog.this.pass.isDisposed()) {
                    PasswordDialog.this.pass.removeTraverseListener(next);
                    PasswordDialog.this.pass.setEnabled(false);
                }
                if (!PasswordDialog.this.passEnter.isDisposed()) {
                    PasswordDialog.this.passEnter.removeSelectionListener(enter);
                    PasswordDialog.this.passEnter.setEnabled(false);
                }
                if (!PasswordDialog.this.prompt.isDisposed()) {
                    PasswordDialog.this.prompt.setEnabled(false);
                    PasswordDialog.this.prompt.redraw();
                }
                if (disp.isDisposed()) {
                    disp.disposeExec(null);
                }
            }
        });
        String tmpPass = new String(this.password);
        this.cleanPasswordMemory();
        return tmpPass;
    }

    protected Control createButtonBar(Composite parent) {
        return new Composite(parent, 128);
    }

    public void annotate(byte[] data) {
        if (data.length == 0) {
            return;
        }
        final ArrayList<StyleRange> colorization = new ArrayList<StyleRange>();
        final String txt = this.styleText(data, colorization);
        IWorkbench bench = PlatformUI.getWorkbench();
        if (bench == null) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PasswordDialog.this.outputText.isDisposed()) {
                    PasswordDialog.this.outputText.setText(txt);
                    PasswordDialog.this.outputText.setStyleRanges(colorization.toArray(new StyleRange[0]));
                    PasswordDialog.this.outputText.pack();
                    PasswordDialog.this.outputText.getParent().pack();
                }
            }
        });
    }

    private String styleText(byte[] newData, ArrayList<StyleRange> colorization) {
        String line;
        StringBuilder outText = new StringBuilder();
        this.unmodifiedOutput = String.valueOf(this.unmodifiedOutput) + new String(newData);
        String[] lines = this.unmodifiedOutput.split("\n");
        String[] retained = Arrays.copyOfRange(lines, Math.max(0, lines.length - 15), lines.length);
        StringBuilder unmodifiedStore = new StringBuilder();
        String[] stringArray = retained;
        int n = retained.length;
        int n2 = 0;
        while (n2 < n) {
            line = stringArray[n2];
            unmodifiedStore.append(line);
            unmodifiedStore.append('\n');
            ++n2;
        }
        this.unmodifiedOutput = this.unmodifiedOutput.toString();
        stringArray = retained;
        n = retained.length;
        n2 = 0;
        while (n2 < n) {
            line = stringArray[n2];
            BashColours[] bashColoursArray = BashColours.values();
            int n3 = bashColoursArray.length;
            int n4 = 0;
            while (n4 < n3) {
                BashColours b = bashColoursArray[n4];
                int start = 0;
                while (start >= 0) {
                    int end;
                    if ((start = line.indexOf(b.codeWord, start)) < 0 || (end = (line = String.valueOf(line.substring(0, start)) + line.substring(start + b.codeWord.length())).indexOf("\u001b[0;m]", start)) < 0) break;
                    line = String.valueOf(line.substring(0, end)) + line.substring(end + "\u001b[0;m]".length());
                    if (start < 0 || end <= start) break;
                    StyleRange range = new StyleRange();
                    range.start = outText.length() + start;
                    range.length = end - start;
                    range.foreground = b.color;
                    colorization.add(range);
                    start = end;
                }
                ++n4;
            }
            outText.append(line);
            outText.append('\n');
            ++n2;
        }
        return outText.toString();
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(this.title);
        parent.setLayout((Layout)new GridLayout(1, false));
        this.motdText = new Label(parent, 0);
        Font font = new Font((Device)this.motdText.getDisplay(), new FontData("Courier", 12, 0));
        this.motdText.setFont(font);
        this.motdText.setText("Server not connected");
        this.motdText.setLayoutData((Object)new GridData(1808));
        this.outputText = new StyledText(parent, 266);
        this.outputText.setFont(font);
        GridData outGrid = new GridData(768);
        outGrid.horizontalSpan = 15;
        outGrid.widthHint = 600;
        this.outputText.setLayoutData((Object)outGrid);
        this.outputText.setText("");
        this.passArea = new Composite(parent, 0);
        this.passArea.setVisible(false);
        this.passwordGrid = new GridData(768);
        this.passArea.setLayout((Layout)new GridLayout(2, false));
        this.passArea.setLayoutData((Object)this.passwordGrid);
        this.prompt = new Label(this.passArea, 0);
        this.prompt.setLayoutData((Object)new GridData(768));
        this.prompt.setEnabled(false);
        new Label(this.passArea, 0);
        this.pass = new Text(this.passArea, 0x400800);
        this.pass.setLayoutData((Object)new GridData(768));
        this.pass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Arrays.fill(PasswordDialog.this.password, '0');
                PasswordDialog.this.password = PasswordDialog.this.pass.getText().toCharArray();
            }
        });
        this.pass.setEnabled(false);
        this.passEnter = new Button(this.passArea, 8);
        this.passEnter.setText("Login");
        this.passEnter.setEnabled(false);
        this.doneText = new Label(parent, 0);
        GridData doneGrid = new GridData(768);
        doneGrid.horizontalSpan = 15;
        this.doneText.setLayoutData((Object)doneGrid);
        return super.createContents(parent);
    }

    public void setMOTD(final String msg) {
        Display disp = PlatformUI.getWorkbench().getDisplay();
        if (disp != null) {
            disp.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!PasswordDialog.this.motdText.isDisposed()) {
                        PasswordDialog.this.motdText.setText(msg);
                        PasswordDialog.this.motdText.pack();
                        PasswordDialog.this.motdText.getParent().pack();
                    }
                }
            });
        }
    }

    public void askClose() {
        if (this.askedToClose.compareAndSet(false, true)) {
            WindowClose closingJob = new WindowClose();
            closingJob.schedule();
        }
    }

    private static enum BashColours {
        Red("[\u001b[0;31m", ExcentisColors.red),
        Green("[\u001b[0;32m", ExcentisColors.green);

        final String codeWord;
        final Color color;

        private BashColours(String codeWord, Color color) {
            this.codeWord = codeWord;
            this.color = color;
        }
    }

    private final class WindowClose
    extends Job {
        private static final long SECOND = 1000L;
        private static final long WAIT_TIME = 10000L;
        private final long start;

        private WindowClose() {
            super("Window close");
            this.start = System.currentTimeMillis();
            this.setSystem(true);
            this.setPriority(10);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Display disp = PlatformUI.getWorkbench().getDisplay();
            if (disp != null) {
                disp.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        long closeDelay = WindowClose.this.start + 10000L - System.currentTimeMillis();
                        long secCloseDelay = Math.max(0L, closeDelay / 1000L);
                        if (!((WindowClose)WindowClose.this).PasswordDialog.this.doneText.isDisposed() && !((WindowClose)WindowClose.this).PasswordDialog.this.isClosed) {
                            ((WindowClose)WindowClose.this).PasswordDialog.this.doneText.setText("The connection has finished. This window will close in " + secCloseDelay + " seconds...");
                            if (closeDelay > 0L) {
                                WindowClose.this.schedule(499L);
                            } else {
                                PasswordDialog.this.close();
                            }
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

