/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.dialogs;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.swt.Activator;
import com.excentis.products.byteblower.gui.swt.dialogs.BPFTextFeedback;
import com.excentis.products.byteblower.gui.swt.dialogs.DoCapture;
import com.excentis.products.byteblower.gui.swt.dialogs.URLOpenener;
import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.gui.utils.OSValidator;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.PhysicalConfigurationReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalInterfaceReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalServerReader;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.EByteBlowerServerObject;
import com.excentis.products.byteblower.server.model.InterfaceType;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalInterface;
import com.excentis.products.byteblower.server.model.PhysicalPort;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PcapCaptureDialog
extends Dialog
implements DoCapture.CaptureListener {
    private EByteBlowerServerObject captureObject;
    private DoCapture captureJob;
    private Label lblCaptureDuration;
    private Label lblFileSize;
    private Text statusLabel;
    private Text fileTxt;
    private Button fileBrowseButton;
    private Button startRestartStopButton;
    private Button openPcapButton;
    private Combo comboInterface;
    private Combo comboPort;
    private File storeFile;
    private State state = State.INITIALISING;
    private State initialState;
    private Text txtSnapLen;
    private Text txtFilter;
    private String initialFilter;
    private int initialSnapLen;

    public PcapCaptureDialog(Shell shell, EByteBlowerServerObject captureObject) {
        this(shell, captureObject, 10000, "");
    }

    public PcapCaptureDialog(Shell shell, EByteBlowerServerObject captureObject, int snaplen, String filter) {
        super(shell);
        this.setShellStyle(2160);
        this.setBlockOnOpen(false);
        if (captureObject instanceof DockedByteBlowerPort) {
            DockedByteBlowerPort dockedPort = (DockedByteBlowerPort)captureObject;
            ByteBlowerGuiPortConfiguration portConfig = dockedPort.getDockedConfiguration();
            ByteBlowerGuiPort guiPort = portConfig.getByteBlowerGuiPort();
            ByteBlowerGuiPortReader guiPortReader = ReaderFactory.create((ByteBlowerGuiPort)guiPort);
            PhysicalConfigurationReader actualServerConfig = PhysicalConfigurationManager.getInstance().getPhysicalConfigurationReader();
            PhysicalDockable dockable = actualServerConfig.getPhysicalDockable(guiPortReader);
            this.captureObject = dockable;
        } else {
            this.captureObject = captureObject;
        }
        this.setCaptureObject(captureObject);
        this.initialFilter = filter;
        this.initialSnapLen = snaplen;
    }

    private static String getBbInterface(EByteBlowerServerObject captureObject) {
        if (captureObject instanceof PhysicalInterface) {
            PhysicalInterface selectedInterface = (PhysicalInterface)captureObject;
            PhysicalInterfaceReader reader = ReaderFactory.create((PhysicalInterface)selectedInterface);
            return reader.getInterfaceString();
        }
        if (captureObject instanceof PhysicalPort) {
            PhysicalPort selectedPort = (PhysicalPort)captureObject;
            PhysicalPortReader reader = ReaderFactory.create((PhysicalPort)selectedPort);
            return reader.getInterfaceString();
        }
        return null;
    }

    private static PhysicalServer getServer(EByteBlowerServerObject captureObject) {
        if (captureObject instanceof PhysicalServer) {
            return (PhysicalServer)captureObject;
        }
        if (captureObject instanceof PhysicalInterface) {
            PhysicalInterface selectedInterface = (PhysicalInterface)captureObject;
            return selectedInterface.getPhysicalServer();
        }
        if (captureObject instanceof PhysicalPort) {
            PhysicalPort selectedPort = (PhysicalPort)captureObject;
            PhysicalPortReader reader = ReaderFactory.create((PhysicalPort)selectedPort);
            return (PhysicalServer)reader.getServer();
        }
        return null;
    }

    private static String getServerAddress(EByteBlowerServerObject captureObject) {
        PhysicalServer server = PcapCaptureDialog.getServer(captureObject);
        return server != null ? server.getAddress() : "UNKNOWN";
    }

    public static String captureLocationId(EByteBlowerServerObject captureObject) {
        EByteBlowerServerObject reducedObject;
        if (captureObject instanceof DockedByteBlowerPort) {
            DockedByteBlowerPort dockedPort = (DockedByteBlowerPort)captureObject;
            ByteBlowerGuiPortConfiguration portConfig = dockedPort.getDockedConfiguration();
            ByteBlowerGuiPort guiPort = portConfig.getByteBlowerGuiPort();
            ByteBlowerGuiPortReader guiPortReader = ReaderFactory.create((ByteBlowerGuiPort)guiPort);
            PhysicalConfigurationReader actualServerConfig = PhysicalConfigurationManager.getInstance().getPhysicalConfigurationReader();
            PhysicalDockable dockable = actualServerConfig.getPhysicalDockable(guiPortReader);
            reducedObject = dockable;
        } else {
            reducedObject = captureObject;
        }
        String serverAddr = PcapCaptureDialog.getServerAddress(reducedObject);
        String interfaceId = PcapCaptureDialog.getBbInterface(reducedObject);
        return String.valueOf(serverAddr) + interfaceId;
    }

    public String getCaptureLocation() {
        if (this.captureJob != null) {
            return this.captureJob.getCaptureLocation();
        }
        return "";
    }

    private void updateState() {
        switch (this.state) {
            case INITIALISING: {
                break;
            }
            case WAITING_FOR_INPUT: {
                if (!this.canCapture()) {
                    this.interfaceSelectionChanged();
                }
                this.updateShellText(PcapCaptureDialog.getServerAddress(this.captureObject));
                this.statusLabel.setText("Verify Input and click on Start Capture\n\n\n\n");
                break;
            }
            case RUNNING: {
                this.startCapture();
                break;
            }
            case FINISHED: {
                this.stopCapture();
                break;
            }
        }
    }

    private void setState(State newState) {
        this.state = newState;
        this.updateState();
    }

    private void updateShellText(String captureLocation) {
        String captureText = "Capture Traffic on " + captureLocation;
        this.getShell().setText(captureText);
    }

    public void startCapture() {
        this.comboInterface.setEnabled(false);
        this.comboPort.setEnabled(false);
        this.txtFilter.setEnabled(false);
        this.txtSnapLen.setEnabled(false);
        String captureFilter = this.txtFilter.getText();
        int snapLen = 10000;
        try {
            snapLen = Integer.parseInt(this.txtSnapLen.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getGlobal().info("Snaplen has an invalid number");
        }
        this.openPcapButton.setEnabled(OSValidator.isWindows());
        this.openPcapButton.setToolTipText("Open the results this far ...");
        this.setStartButtonText("Stop Capture", "icons/stop_icon.png");
        String bbInterface = PcapCaptureDialog.getBbInterface(this.captureObject);
        this.updateShellText(bbInterface);
        String serverAddress = PcapCaptureDialog.getServerAddress(this.captureObject);
        String suggestedFile = this.fileTxt.getText();
        if (suggestedFile.isEmpty()) {
            this.storeFile = this.createTempFile(bbInterface);
        } else if (this.storeFile == null) {
            try {
                this.storeFile = new File(this.fileTxt.getText());
            }
            catch (Exception exception) {
                this.storeFile = this.createTempFile(bbInterface);
            }
        } else if (this.storeFile.getAbsolutePath().contentEquals(this.fileTxt.getText())) {
            this.storeFile = this.createTempFile(bbInterface);
        }
        this.fileTxt.setText(this.storeFile.getAbsolutePath());
        this.fileTxt.setEditable(false);
        this.fileBrowseButton.setEnabled(false);
        this.openPcapButton.setText("Open Active Capture");
        this.captureJob = new DoCapture(this.storeFile, bbInterface, serverAddress, this, snapLen, captureFilter);
        this.captureJob.schedule();
    }

    private void setStartButtonText(String txt, String iconPath) {
        this.startRestartStopButton.setText(txt);
        this.startRestartStopButton.setImage(ImageCache.getImageFromString((String)iconPath));
        this.startRestartStopButton.pack();
        this.startRestartStopButton.getParent().pack();
    }

    private void stopCapture() {
        this.startRestartStopButton.setEnabled(false);
        this.setStartButtonText("Stopping...", "icons/stop_icon.png");
        this.captureJob.stop();
    }

    private PhysicalInterface getPhysicalInterface() {
        if (this.captureObject instanceof PhysicalInterface) {
            return (PhysicalInterface)this.captureObject;
        }
        if (this.captureObject instanceof PhysicalPort) {
            PhysicalPort selectedPort = (PhysicalPort)this.captureObject;
            return selectedPort.getPhysicalInterface();
        }
        return null;
    }

    private PhysicalPort getPhysicalPort() {
        if (this.captureObject instanceof PhysicalPort) {
            return (PhysicalPort)this.captureObject;
        }
        return null;
    }

    private boolean canCapture() {
        boolean canCapture = false;
        if (this.captureObject instanceof PhysicalPort) {
            canCapture = true;
        } else if (this.captureObject instanceof PhysicalInterface) {
            PhysicalInterface captureInterface = (PhysicalInterface)this.captureObject;
            PhysicalInterfaceReader reader = ReaderFactory.create((PhysicalInterface)captureInterface);
            canCapture = reader.getInterfaceType() == InterfaceType.NONTRUNKING;
        }
        return canCapture;
    }

    private void initialStartStopLogic() {
        this.startRestartStopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PcapCaptureDialog.this.captureJob == null) {
                    PcapCaptureDialog.this.setState(State.RUNNING);
                } else {
                    PcapCaptureDialog.this.setState(State.FINISHED);
                    PcapCaptureDialog.this.startRestartStopButton.removeSelectionListener((SelectionListener)this);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.startRestartStopButton = new Button(composite, 8);
        this.startRestartStopButton.setImage(ImageCache.getImageFromString((String)"icons/play_icon.png"));
        this.startRestartStopButton.setText("Start Capture");
        this.initialStartStopLogic();
        this.openPcapButton = new Button(composite, 8);
        this.openPcapButton.setData((Object)Boolean.TRUE);
        this.openPcapButton.setImage(ImageCache.getImageFromString((String)"icons/pop_out_icon.png"));
        this.openPcapButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean succeededOpening = false;
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().open(PcapCaptureDialog.this.storeFile);
                        succeededOpening = true;
                    } else {
                        PcapCaptureDialog.this.openPcapButton.setToolTipText("This system doesn't support opening files");
                    }
                }
                catch (IOException iOException) {
                    PcapCaptureDialog.this.openPcapButton.setData((Object)Boolean.FALSE);
                    PcapCaptureDialog.this.openPcapButton.setToolTipText("Previously failed to open the file");
                }
                PcapCaptureDialog.this.openPcapButton.setEnabled(succeededOpening);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.openPcapButton.setText("Open Active Capture");
        this.openPcapButton.setToolTipText("Waiting on capture file...");
        this.openPcapButton.setEnabled(false);
        this.setState(this.initialState);
        return composite;
    }

    @Override
    public void updateContents(final long capturedBytes, final double duration) {
        final long freeDiskSpace = this.storeFile.getFreeSpace();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PcapCaptureDialog.this.lblFileSize.isDisposed() || PcapCaptureDialog.this.lblCaptureDuration.isDisposed() || PcapCaptureDialog.this.openPcapButton.isDisposed()) {
                    return;
                }
                String durationMsg = String.format("%.0f seconds", duration);
                PcapCaptureDialog.this.lblCaptureDuration.setEnabled(true);
                PcapCaptureDialog.this.lblCaptureDuration.setText(durationMsg);
                if (PcapCaptureDialog.this.openPcapButton != null && capturedBytes > 0L && Boolean.TRUE.equals(PcapCaptureDialog.this.openPcapButton.getData())) {
                    PcapCaptureDialog.this.openPcapButton.setEnabled(true);
                }
                String diskSpaceWarning = "";
                if (2L * capturedBytes > freeDiskSpace) {
                    diskSpaceWarning = "Low on diskspace, one half of the available space is used";
                } else if ((double)freeDiskSpace < 5.0E8) {
                    diskSpaceWarning = "Low on diskspace, less than 500 Mbyte available";
                }
                String sizeMsg = String.format("%.1f Mbyte %s", Math.ceil((double)capturedBytes / 100000.0) / 10.0, diskSpaceWarning);
                PcapCaptureDialog.this.lblFileSize.setEnabled(true);
                PcapCaptureDialog.this.lblFileSize.setText(sizeMsg);
            }
        });
    }

    public boolean close() {
        if (this.captureJob != null) {
            this.captureJob.stop();
        }
        return super.close();
    }

    protected Control createContents(Composite parent) {
        this.initialState = State.WAITING_FOR_INPUT;
        parent.setLayout((Layout)new GridLayout(1, false));
        Group inputGroup = new Group(parent, 0);
        inputGroup.setLayoutData((Object)new GridData(768));
        inputGroup.setLayout((Layout)new GridLayout(1, false));
        inputGroup.setText("Input");
        Composite inputComposite = new Composite((Composite)inputGroup, 0);
        inputComposite.setLayoutData((Object)new GridData(768));
        inputComposite.setLayout((Layout)new GridLayout(2, false));
        Label labelServer = new Label(inputComposite, 0);
        labelServer.setText("Server:");
        Label labelAddress = new Label(inputComposite, 0);
        labelAddress.setLayoutData((Object)new GridData(768));
        labelAddress.setText(PcapCaptureDialog.getServerAddress(this.captureObject));
        Label labelInterface = new Label(inputComposite, 0);
        labelInterface.setText("Interface:");
        this.comboInterface = new Combo(inputComposite, 8);
        this.comboInterface.setLayoutData((Object)new GridData(768));
        Label labelPort = new Label(inputComposite, 0);
        labelPort.setText("Port:");
        this.comboPort = new Combo(inputComposite, 8);
        this.comboPort.setLayoutData((Object)new GridData(768));
        this.comboPort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PcapCaptureDialog.this.portSelectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group outputGroup = new Group(parent, 0);
        outputGroup.setLayoutData((Object)new GridData(768));
        outputGroup.setLayout((Layout)new GridLayout(1, false));
        outputGroup.setText("Output");
        Composite fileSelectionGroup = new Composite((Composite)outputGroup, 0);
        fileSelectionGroup.setLayoutData((Object)new GridData(768));
        fileSelectionGroup.setLayout((Layout)new GridLayout(2, false));
        this.fileTxt = new Text(fileSelectionGroup, 2048);
        this.fileTxt.setMessage("Create temporary PCAP file");
        this.fileTxt.setLayoutData((Object)new GridData(768));
        this.fileBrowseButton = new Button(fileSelectionGroup, 0);
        this.fileBrowseButton.setText("Browse...");
        this.fileBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PcapCaptureDialog.this.getShell(), 8192);
                dialog.setOverwrite(true);
                if (!PcapCaptureDialog.this.fileTxt.getText().isEmpty()) {
                    try {
                        PcapCaptureDialog.this.storeFile = new File(PcapCaptureDialog.this.fileTxt.getText());
                    }
                    catch (Exception exception) {}
                }
                if (PcapCaptureDialog.this.storeFile == null) {
                    PcapCaptureDialog.this.storeFile = PcapCaptureDialog.this.createTempFile();
                }
                dialog.setFilterPath(PcapCaptureDialog.this.storeFile.getParent());
                dialog.setFileName(PcapCaptureDialog.this.storeFile.getName());
                PcapCaptureDialog.this.storeFile.delete();
                PcapCaptureDialog.this.storeFile = null;
                String result = dialog.open();
                if (result != null) {
                    PcapCaptureDialog.this.setFileText(result);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblFileSize = new Label((Composite)outputGroup, 0);
        this.lblFileSize.setText(" xxx MBytes");
        this.lblFileSize.setLayoutData((Object)new GridData(768));
        this.lblFileSize.setEnabled(false);
        this.lblCaptureDuration = new Label((Composite)outputGroup, 0);
        this.lblCaptureDuration.setText(" xxx Minutes");
        this.lblCaptureDuration.setLayoutData((Object)new GridData(768));
        this.lblCaptureDuration.setEnabled(false);
        Group advancedGroup = new Group(parent, 0);
        advancedGroup.setLayoutData((Object)new GridData(768));
        advancedGroup.setLayout((Layout)new GridLayout(1, false));
        advancedGroup.setText("Advanced config");
        Composite advancedComposite = new Composite((Composite)advancedGroup, 0);
        advancedComposite.setLayoutData((Object)new GridData(768));
        advancedComposite.setLayout((Layout)new GridLayout(2, false));
        Link labelFilter = new Link(advancedComposite, 0);
        labelFilter.setText("<a>BPF filter</a>:");
        String cheatSheet = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/cheatsheet-bpf-filters";
        labelFilter.addSelectionListener((SelectionListener)new URLOpenener(cheatSheet));
        this.txtFilter = new Text(advancedComposite, 2048);
        this.txtFilter.setLayoutData((Object)new GridData(768));
        this.txtFilter.setMessage("All traffic");
        this.txtFilter.setText(this.initialFilter);
        this.txtFilter.addVerifyListener((VerifyListener)new BPFTextFeedback(this.txtFilter, PcapCaptureDialog.getServerAddress(this.captureObject)));
        Label snapLen = new Label(advancedComposite, 0);
        snapLen.setText("Truncate frames to (bytes):");
        if (this.initialSnapLen != 10000) {
            this.txtSnapLen.setText("" + this.initialSnapLen);
        }
        this.txtSnapLen = IntegerTextFactory.instance().create(advancedComposite, 0L, 10000L);
        this.txtSnapLen.setMessage("No Truncation");
        this.txtSnapLen.setLayoutData((Object)new GridData(768));
        Group statusGroup = new Group(parent, 0);
        statusGroup.setLayoutData((Object)new GridData(768));
        statusGroup.setLayout((Layout)new GridLayout(1, false));
        statusGroup.setText("Status");
        this.statusLabel = new Text((Composite)statusGroup, 74);
        this.statusLabel.setLayoutData((Object)new GridData(1808));
        this.statusLabel.setText("\n\n\n\n");
        this.fillInterfaces(this.comboInterface);
        return super.createContents(parent);
    }

    private void fillInterfaces(Combo comboInterface) {
        PhysicalServer server = PcapCaptureDialog.getServer(this.captureObject);
        PhysicalServerReader reader = ReaderFactory.create((PhysicalServer)server);
        for (PhysicalInterfaceReader interfaceReader : reader.getPhysicalInterfaceReaders()) {
            comboInterface.add(interfaceReader.getDetailedInterfaceString());
        }
        comboInterface.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PcapCaptureDialog.this.interfaceSelectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PhysicalInterface interf = this.getPhysicalInterface();
        if (interf != null) {
            PhysicalInterfaceReader interfaceReader = ReaderFactory.create((PhysicalInterface)interf);
            String selectedInterface = interfaceReader.getDetailedInterfaceString();
            int count = comboInterface.getItemCount();
            int i = 0;
            while (i < count) {
                String interfaceString = comboInterface.getItem(i);
                if (interfaceString.equals(selectedInterface)) {
                    comboInterface.select(i);
                    break;
                }
                ++i;
            }
        } else {
            comboInterface.select(0);
        }
        this.interfaceSelectionChanged();
    }

    private void interfaceSelectionChanged() {
        PhysicalServer server = PcapCaptureDialog.getServer(this.captureObject);
        PhysicalServerReader reader = ReaderFactory.create((PhysicalServer)server);
        int index = this.comboInterface.getSelectionIndex();
        PhysicalInterface selectedInterface = (PhysicalInterface)reader.getPhysicalInterfaces().get(index);
        PhysicalInterfaceReader interfaceReader = ReaderFactory.create((PhysicalInterface)selectedInterface);
        this.setCaptureObject((EByteBlowerServerObject)selectedInterface);
        this.fillPorts(interfaceReader);
    }

    private File createTempFile() {
        return this.createTempFile("byteblower-");
    }

    private File createTempFile(String fileHint) {
        try {
            this.storeFile = File.createTempFile(String.valueOf(fileHint) + "-", ".pcap");
            this.setFileText(this.storeFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            this.logMessage("Can't create temp file");
        }
        return this.storeFile;
    }

    private void setCaptureObject(EByteBlowerServerObject selectedObject) {
        if (this.state != State.INITIALISING) {
            this.captureObject = selectedObject;
            String bbInterface = PcapCaptureDialog.getBbInterface(this.captureObject);
            this.createTempFile(bbInterface);
        }
    }

    private void setFileText(String text) {
        this.fileTxt.setText(text);
    }

    private void logMessage(String msg) {
        Status log = new Status(0, "com.excentis.products.byteblower.gui.swt", "PcapCaptureDialog :: " + msg);
        Activator.getDefault().getLog().log((IStatus)log);
    }

    private void portSelectionChanged() {
        if (this.state != State.INITIALISING) {
            PhysicalInterface selectedInterface;
            int index = this.comboPort.getSelectionIndex();
            if (index != -1 && (selectedInterface = this.getPhysicalInterface()) != null) {
                PhysicalPort capturePort = (PhysicalPort)selectedInterface.getPhysicalPort().get(index);
                this.setCaptureObject((EByteBlowerServerObject)capturePort);
            }
            this.updateState();
        }
    }

    private void fillPorts(PhysicalInterfaceReader interfaceReader) {
        this.comboPort.removeAll();
        if (interfaceReader.isNonTrunking()) {
            this.comboPort.setEnabled(false);
        } else {
            this.comboPort.setEnabled(true);
            List readers = interfaceReader.getPhysicalPortReaders();
            for (PhysicalPortReader reader : readers) {
                String port = reader.getInterfaceString();
                this.comboPort.add(port);
            }
            PhysicalPort port = this.getPhysicalPort();
            if (port != null) {
                PhysicalPortReader portReader = ReaderFactory.create((PhysicalPort)port);
                String selectedPort = portReader.getInterfaceString();
                int count = this.comboPort.getItemCount();
                int i = 0;
                while (i < count) {
                    String portString = this.comboPort.getItem(i);
                    if (portString.equals(selectedPort)) {
                        this.comboPort.select(i);
                        break;
                    }
                    ++i;
                }
            } else {
                this.comboPort.select(0);
            }
        }
        this.portSelectionChanged();
    }

    @Override
    public void reportStatus(final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PcapCaptureDialog.this.statusLabel.isDisposed()) {
                    PcapCaptureDialog.this.statusLabel.setText(msg);
                }
            }
        });
    }

    @Override
    public void stopped() {
        this.storeFile = this.captureJob.getCapturedFile();
        this.captureJob = null;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PcapCaptureDialog.this.startRestartStopButton.isDisposed()) {
                    return;
                }
                PcapCaptureDialog.this.openPcapButton.setText("Open Latest Capture");
                PcapCaptureDialog.this.setStartButtonText("Start capture", "icons/play_icon.png");
                PcapCaptureDialog.this.setState(State.INITIALISING);
                PcapCaptureDialog.this.startRestartStopButton.setEnabled(true);
                PcapCaptureDialog.this.lblCaptureDuration.setEnabled(false);
                PcapCaptureDialog.this.lblFileSize.setEnabled(false);
                PcapCaptureDialog.this.fileTxt.setEditable(false);
                PcapCaptureDialog.this.fileBrowseButton.setEnabled(false);
                PcapCaptureDialog.this.txtSnapLen.setEnabled(true);
                PcapCaptureDialog.this.txtFilter.setEnabled(true);
                PcapCaptureDialog.this.initialStartStopLogic();
            }
        });
    }

    static enum State {
        INITIALISING,
        WAITING_FOR_INPUT,
        RUNNING,
        STOPPING,
        FINISHED;

    }
}

